/*
 * $Id$
 */

package org.apache.maven.doxia.docrenderer.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Describes the overall document model.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentModel
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field outputName.
     */
    private String outputName;

    /**
     * The Meta information properties.
     */
    private DocumentMeta meta;

    /**
     * The TOC information properties.
     */
    private DocumentTOC toc;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentModel ) )
        {
            return false;
        }

        DocumentModel that = (DocumentModel) other;
        boolean result = true;

        result = result && ( getOutputName() == null ? that.getOutputName() == null : getOutputName().equals( that.getOutputName() ) );
        result = result && ( getMeta() == null ? that.getMeta() == null : getMeta().equals( that.getMeta() ) );
        result = result && ( getToc() == null ? that.getToc() == null : getToc().equals( that.getToc() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get the Meta information properties.
     * 
     * @return DocumentMeta
     */
    public DocumentMeta getMeta()
    {
        return this.meta;
    } //-- DocumentMeta getMeta()

    /**
     * Method getModelEncoding.
     * 
     * @return the current encoding used when reading/writing this
     * model
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Get the outputName field.
     * 
     * @return String
     */
    public String getOutputName()
    {
        return this.outputName;
    } //-- String getOutputName()

    /**
     * Get the TOC information properties.
     * 
     * @return DocumentTOC
     */
    public DocumentTOC getToc()
    {
        return this.toc;
    } //-- DocumentTOC getToc()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( outputName != null ? outputName.hashCode() : 0 );
        result = 37 * result + ( meta != null ? meta.hashCode() : 0 );
        result = 37 * result + ( toc != null ? toc.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set the Meta information properties.
     * 
     * @param meta
     */
    public void setMeta( DocumentMeta meta )
    {
        this.meta = meta;
    } //-- void setMeta( DocumentMeta )

    /**
     * Set an encoding used for reading/writing the model.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set the outputName field.
     * 
     * @param outputName
     */
    public void setOutputName( String outputName )
    {
        this.outputName = outputName;
    } //-- void setOutputName( String )

    /**
     * Set the TOC information properties.
     * 
     * @param toc
     */
    public void setToc( DocumentTOC toc )
    {
        this.toc = toc;
    } //-- void setToc( DocumentTOC )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "outputName = '" );
        buf.append( getOutputName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "meta = '" );
        buf.append( getMeta() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "toc = '" );
        buf.append( getToc() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
