/*
 * $Id$
 */

package org.apache.maven.doxia.docrenderer.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Element that contains some meta information about the document.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentMeta
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Title of the document.
     */
    private String title;

    /**
     * The author of the document.
     */
    private String author;

    /**
     * The subject of the document.
     */
    private String subject;

    /**
     * The keywords of the document.
     */
    private String keywords;

    /**
     * The pagesize of the document.
     */
    private String pageSize;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentMeta ) )
        {
            return false;
        }

        DocumentMeta that = (DocumentMeta) other;
        boolean result = true;

        result = result && ( getTitle() == null ? that.getTitle() == null : getTitle().equals( that.getTitle() ) );
        result = result && ( getAuthor() == null ? that.getAuthor() == null : getAuthor().equals( that.getAuthor() ) );
        result = result && ( getSubject() == null ? that.getSubject() == null : getSubject().equals( that.getSubject() ) );
        result = result && ( getKeywords() == null ? that.getKeywords() == null : getKeywords().equals( that.getKeywords() ) );
        result = result && ( getPageSize() == null ? that.getPageSize() == null : getPageSize().equals( that.getPageSize() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get the author of the document.
     * 
     * @return String
     */
    public String getAuthor()
    {
        return this.author;
    } //-- String getAuthor()

    /**
     * Get the keywords of the document.
     * 
     * @return String
     */
    public String getKeywords()
    {
        return this.keywords;
    } //-- String getKeywords()

    /**
     * Get the pagesize of the document.
     * 
     * @return String
     */
    public String getPageSize()
    {
        return this.pageSize;
    } //-- String getPageSize()

    /**
     * Get the subject of the document.
     * 
     * @return String
     */
    public String getSubject()
    {
        return this.subject;
    } //-- String getSubject()

    /**
     * Get title of the document.
     * 
     * @return String
     */
    public String getTitle()
    {
        return this.title;
    } //-- String getTitle()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( title != null ? title.hashCode() : 0 );
        result = 37 * result + ( author != null ? author.hashCode() : 0 );
        result = 37 * result + ( subject != null ? subject.hashCode() : 0 );
        result = 37 * result + ( keywords != null ? keywords.hashCode() : 0 );
        result = 37 * result + ( pageSize != null ? pageSize.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set the author of the document.
     * 
     * @param author
     */
    public void setAuthor( String author )
    {
        this.author = author;
    } //-- void setAuthor( String )

    /**
     * Set the keywords of the document.
     * 
     * @param keywords
     */
    public void setKeywords( String keywords )
    {
        this.keywords = keywords;
    } //-- void setKeywords( String )

    /**
     * Set the pagesize of the document.
     * 
     * @param pageSize
     */
    public void setPageSize( String pageSize )
    {
        this.pageSize = pageSize;
    } //-- void setPageSize( String )

    /**
     * Set the subject of the document.
     * 
     * @param subject
     */
    public void setSubject( String subject )
    {
        this.subject = subject;
    } //-- void setSubject( String )

    /**
     * Set title of the document.
     * 
     * @param title
     */
    public void setTitle( String title )
    {
        this.title = title;
    } //-- void setTitle( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "title = '" );
        buf.append( getTitle() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "author = '" );
        buf.append( getAuthor() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "subject = '" );
        buf.append( getSubject() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "keywords = '" );
        buf.append( getKeywords() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "pageSize = '" );
        buf.append( getPageSize() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
