/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer.document.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.doxia.docrenderer.document.DocumentMeta;
import org.apache.maven.doxia.docrenderer.document.DocumentModel;
import org.apache.maven.doxia.docrenderer.document.DocumentTOC;
import org.apache.maven.doxia.docrenderer.document.DocumentTOCItem;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class DocumentXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, DocumentModel documentModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(documentModel.getModelEncoding(), null);
        this.writeDocumentModel(documentModel, "document", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeDocumentMeta(DocumentMeta documentMeta, String tagName, XmlSerializer serializer) throws IOException {
        if (documentMeta != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (documentMeta.getTitle() != null) {
                serializer.startTag(this.NAMESPACE, "title").text(documentMeta.getTitle()).endTag(this.NAMESPACE, "title");
            }
            if (documentMeta.getAuthor() != null) {
                serializer.startTag(this.NAMESPACE, "author").text(documentMeta.getAuthor()).endTag(this.NAMESPACE, "author");
            }
            if (documentMeta.getSubject() != null) {
                serializer.startTag(this.NAMESPACE, "subject").text(documentMeta.getSubject()).endTag(this.NAMESPACE, "subject");
            }
            if (documentMeta.getKeywords() != null) {
                serializer.startTag(this.NAMESPACE, "keywords").text(documentMeta.getKeywords()).endTag(this.NAMESPACE, "keywords");
            }
            if (documentMeta.getPageSize() != null) {
                serializer.startTag(this.NAMESPACE, "pageSize").text(documentMeta.getPageSize()).endTag(this.NAMESPACE, "pageSize");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDocumentModel(DocumentModel documentModel, String tagName, XmlSerializer serializer) throws IOException {
        if (documentModel != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (documentModel.getOutputName() != null) {
                serializer.attribute(this.NAMESPACE, "outputName", documentModel.getOutputName());
            }
            if (documentModel.getMeta() != null) {
                this.writeDocumentMeta(documentModel.getMeta(), "meta", serializer);
            }
            if (documentModel.getToc() != null) {
                this.writeDocumentTOC(documentModel.getToc(), "toc", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDocumentTOC(DocumentTOC documentTOC, String tagName, XmlSerializer serializer) throws IOException {
        if (documentTOC != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (documentTOC.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", documentTOC.getName());
            }
            if (documentTOC.getItems() != null && documentTOC.getItems().size() > 0) {
                Iterator iter = documentTOC.getItems().iterator();
                while (iter.hasNext()) {
                    DocumentTOCItem o = (DocumentTOCItem)iter.next();
                    this.writeDocumentTOCItem(o, "item", serializer);
                }
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDocumentTOCItem(DocumentTOCItem documentTOCItem, String tagName, XmlSerializer serializer) throws IOException {
        if (documentTOCItem != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (documentTOCItem.getName() != null) {
                serializer.attribute(this.NAMESPACE, "name", documentTOCItem.getName());
            }
            if (documentTOCItem.getRef() != null) {
                serializer.attribute(this.NAMESPACE, "ref", documentTOCItem.getRef());
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

