/*
 * $Id$
 */

package org.apache.maven.doxia.docrenderer.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A Table Of Content for the document.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentTOC implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field items
     */
    private java.util.List items;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addItem
     * 
     * @param documentTOCItem
     */
    public void addItem(DocumentTOCItem documentTOCItem)
    {
        if ( !(documentTOCItem instanceof DocumentTOCItem) )
        {
            throw new ClassCastException( "DocumentTOC.addItems(documentTOCItem) parameter must be instanceof " + DocumentTOCItem.class.getName() );
        }
        getItems().add( documentTOCItem );
    } //-- void addItem(DocumentTOCItem) 

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof DocumentTOC) )
        {
            return false;
        }
        
        DocumentTOC that = (DocumentTOC) other;
        boolean result = true;
        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getItems() == null ? that.getItems() == null : getItems().equals( that.getItems() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Method getItems
     */
    public java.util.List getItems()
    {
        if ( this.items == null )
        {
            this.items = new java.util.ArrayList();
        }
        
        return this.items;
    } //-- java.util.List getItems() 

    /**
     * Get The name to use for the menu.
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( items != null ? items.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Method removeItem
     * 
     * @param documentTOCItem
     */
    public void removeItem(DocumentTOCItem documentTOCItem)
    {
        if ( !(documentTOCItem instanceof DocumentTOCItem) )
        {
            throw new ClassCastException( "DocumentTOC.removeItems(documentTOCItem) parameter must be instanceof " + DocumentTOCItem.class.getName() );
        }
        getItems().remove( documentTOCItem );
    } //-- void removeItem(DocumentTOCItem) 

    /**
     * Set TOC item.
     * 
     * @param items
     */
    public void setItems(java.util.List items)
    {
        this.items = items;
    } //-- void setItems(java.util.List) 

    /**
     * Set The name to use for the menu.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "name = '" );
        buf.append( getName() + "'" );
        buf.append( "\n" ); 
        buf.append( "items = '" );
        buf.append( getItems() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
