/*
 * $Id$
 */

package org.apache.maven.doxia.docrenderer.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Describes the overall document model.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentModel implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field outputName
     */
    private String outputName;

    /**
     * Field meta
     */
    private DocumentMeta meta;

    /**
     * Field toc
     */
    private DocumentTOC toc;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof DocumentModel) )
        {
            return false;
        }
        
        DocumentModel that = (DocumentModel) other;
        boolean result = true;
        result = result && ( getOutputName() == null ? that.getOutputName() == null : getOutputName().equals( that.getOutputName() ) );
        result = result && ( getMeta() == null ? that.getMeta() == null : getMeta().equals( that.getMeta() ) );
        result = result && ( getToc() == null ? that.getToc() == null : getToc().equals( that.getToc() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get The Meta information properties.
     */
    public DocumentMeta getMeta()
    {
        return this.meta;
    } //-- DocumentMeta getMeta() 

    /**
     * Get null
     */
    public String getOutputName()
    {
        return this.outputName;
    } //-- String getOutputName() 

    /**
     * Get The TOC information properties.
     */
    public DocumentTOC getToc()
    {
        return this.toc;
    } //-- DocumentTOC getToc() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( outputName != null ? outputName.hashCode() : 0 );
        result = 37 * result + ( meta != null ? meta.hashCode() : 0 );
        result = 37 * result + ( toc != null ? toc.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set The Meta information properties.
     * 
     * @param meta
     */
    public void setMeta(DocumentMeta meta)
    {
        this.meta = meta;
    } //-- void setMeta(DocumentMeta) 

    /**
     * Set null
     * 
     * @param outputName
     */
    public void setOutputName(String outputName)
    {
        this.outputName = outputName;
    } //-- void setOutputName(String) 

    /**
     * Set The TOC information properties.
     * 
     * @param toc
     */
    public void setToc(DocumentTOC toc)
    {
        this.toc = toc;
    } //-- void setToc(DocumentTOC) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "outputName = '" );
        buf.append( getOutputName() + "'" );
        buf.append( "\n" ); 
        buf.append( "meta = '" );
        buf.append( getMeta() + "'" );
        buf.append( "\n" ); 
        buf.append( "toc = '" );
        buf.append( getToc() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
