/*
 * $Id$
 */

package org.apache.maven.doxia.docrenderer.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Element that contains some meta information about the document.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentMeta implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field title
     */
    private String title;

    /**
     * Field author
     */
    private String author;

    /**
     * Field subject
     */
    private String subject;

    /**
     * Field keywords
     */
    private String keywords;

    /**
     * Field pageSize
     */
    private String pageSize;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof DocumentMeta) )
        {
            return false;
        }
        
        DocumentMeta that = (DocumentMeta) other;
        boolean result = true;
        result = result && ( getTitle() == null ? that.getTitle() == null : getTitle().equals( that.getTitle() ) );
        result = result && ( getAuthor() == null ? that.getAuthor() == null : getAuthor().equals( that.getAuthor() ) );
        result = result && ( getSubject() == null ? that.getSubject() == null : getSubject().equals( that.getSubject() ) );
        result = result && ( getKeywords() == null ? that.getKeywords() == null : getKeywords().equals( that.getKeywords() ) );
        result = result && ( getPageSize() == null ? that.getPageSize() == null : getPageSize().equals( that.getPageSize() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get The author of the document.
     */
    public String getAuthor()
    {
        return this.author;
    } //-- String getAuthor() 

    /**
     * Get The keywords of the document
     */
    public String getKeywords()
    {
        return this.keywords;
    } //-- String getKeywords() 

    /**
     * Get The pagesize of the document
     */
    public String getPageSize()
    {
        return this.pageSize;
    } //-- String getPageSize() 

    /**
     * Get The subject of the document.
     */
    public String getSubject()
    {
        return this.subject;
    } //-- String getSubject() 

    /**
     * Get Title of the document.
     */
    public String getTitle()
    {
        return this.title;
    } //-- String getTitle() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( title != null ? title.hashCode() : 0 );
        result = 37 * result + ( author != null ? author.hashCode() : 0 );
        result = 37 * result + ( subject != null ? subject.hashCode() : 0 );
        result = 37 * result + ( keywords != null ? keywords.hashCode() : 0 );
        result = 37 * result + ( pageSize != null ? pageSize.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set The author of the document.
     * 
     * @param author
     */
    public void setAuthor(String author)
    {
        this.author = author;
    } //-- void setAuthor(String) 

    /**
     * Set The keywords of the document
     * 
     * @param keywords
     */
    public void setKeywords(String keywords)
    {
        this.keywords = keywords;
    } //-- void setKeywords(String) 

    /**
     * Set The pagesize of the document
     * 
     * @param pageSize
     */
    public void setPageSize(String pageSize)
    {
        this.pageSize = pageSize;
    } //-- void setPageSize(String) 

    /**
     * Set The subject of the document.
     * 
     * @param subject
     */
    public void setSubject(String subject)
    {
        this.subject = subject;
    } //-- void setSubject(String) 

    /**
     * Set Title of the document.
     * 
     * @param title
     */
    public void setTitle(String title)
    {
        this.title = title;
    } //-- void setTitle(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "title = '" );
        buf.append( getTitle() + "'" );
        buf.append( "\n" ); 
        buf.append( "author = '" );
        buf.append( getAuthor() + "'" );
        buf.append( "\n" ); 
        buf.append( "subject = '" );
        buf.append( getSubject() + "'" );
        buf.append( "\n" ); 
        buf.append( "keywords = '" );
        buf.append( getKeywords() + "'" );
        buf.append( "\n" ); 
        buf.append( "pageSize = '" );
        buf.append( getPageSize() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
