/*
 * $Id$
 */

package org.apache.maven.doxia.docrenderer.document.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.doxia.docrenderer.document.DocumentMeta;
import org.apache.maven.doxia.docrenderer.document.DocumentModel;
import org.apache.maven.doxia.docrenderer.document.DocumentTOC;
import org.apache.maven.doxia.docrenderer.document.DocumentTOCItem;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class DocumentXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param documentModel
     */
    public void write(Writer writer, DocumentModel documentModel)
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( documentModel.getModelEncoding(), null );
        writeDocumentModel( documentModel, "document", serializer );
        serializer.endDocument();
    } //-- void write(Writer, DocumentModel) 

    /**
     * Method writeDocumentMeta
     * 
     * @param documentMeta
     * @param serializer
     * @param tagName
     */
    private void writeDocumentMeta(DocumentMeta documentMeta, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( documentMeta != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentMeta.getTitle() != null )
            {
                serializer.startTag( NAMESPACE, "title" ).text( documentMeta.getTitle() ).endTag( NAMESPACE, "title" );
            }
            if ( documentMeta.getAuthor() != null )
            {
                serializer.startTag( NAMESPACE, "author" ).text( documentMeta.getAuthor() ).endTag( NAMESPACE, "author" );
            }
            if ( documentMeta.getSubject() != null )
            {
                serializer.startTag( NAMESPACE, "subject" ).text( documentMeta.getSubject() ).endTag( NAMESPACE, "subject" );
            }
            if ( documentMeta.getKeywords() != null )
            {
                serializer.startTag( NAMESPACE, "keywords" ).text( documentMeta.getKeywords() ).endTag( NAMESPACE, "keywords" );
            }
            if ( documentMeta.getPageSize() != null )
            {
                serializer.startTag( NAMESPACE, "pageSize" ).text( documentMeta.getPageSize() ).endTag( NAMESPACE, "pageSize" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentMeta(DocumentMeta, String, XmlSerializer) 

    /**
     * Method writeDocumentModel
     * 
     * @param documentModel
     * @param serializer
     * @param tagName
     */
    private void writeDocumentModel(DocumentModel documentModel, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( documentModel != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentModel.getOutputName() != null )
            {
                serializer.attribute( NAMESPACE, "outputName", documentModel.getOutputName() );
            }
            if ( documentModel.getMeta() != null )
            {
                writeDocumentMeta( (DocumentMeta) documentModel.getMeta(), "meta", serializer );
            }
            if ( documentModel.getToc() != null )
            {
                writeDocumentTOC( (DocumentTOC) documentModel.getToc(), "toc", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentModel(DocumentModel, String, XmlSerializer) 

    /**
     * Method writeDocumentTOC
     * 
     * @param documentTOC
     * @param serializer
     * @param tagName
     */
    private void writeDocumentTOC(DocumentTOC documentTOC, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( documentTOC != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentTOC.getName() != null )
            {
                serializer.attribute( NAMESPACE, "name", documentTOC.getName() );
            }
            if ( documentTOC.getItems() != null && documentTOC.getItems().size() > 0 )
            {
                for ( Iterator iter = documentTOC.getItems().iterator(); iter.hasNext(); )
                {
                    DocumentTOCItem o = (DocumentTOCItem) iter.next();
                    writeDocumentTOCItem( o, "item", serializer );
                }
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentTOC(DocumentTOC, String, XmlSerializer) 

    /**
     * Method writeDocumentTOCItem
     * 
     * @param documentTOCItem
     * @param serializer
     * @param tagName
     */
    private void writeDocumentTOCItem(DocumentTOCItem documentTOCItem, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( documentTOCItem != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( documentTOCItem.getName() != null )
            {
                serializer.attribute( NAMESPACE, "name", documentTOCItem.getName() );
            }
            if ( documentTOCItem.getRef() != null )
            {
                serializer.attribute( NAMESPACE, "ref", documentTOCItem.getRef() );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeDocumentTOCItem(DocumentTOCItem, String, XmlSerializer) 


}
