/*
 * $Id$
 */

package org.apache.maven.doxia.docrenderer.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A menu item.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentTOCItem implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field ref
     */
    private String ref;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof DocumentTOCItem) )
        {
            return false;
        }
        
        DocumentTOCItem that = (DocumentTOCItem) other;
        boolean result = true;
        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getRef() == null ? that.getRef() == null : getRef().equals( that.getRef() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get The name to use for the toc.
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get The ref to use for the item.
     */
    public String getRef()
    {
        return this.ref;
    } //-- String getRef() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( ref != null ? ref.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set The name to use for the toc.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set The ref to use for the item.
     * 
     * @param ref
     */
    public void setRef(String ref)
    {
        this.ref = ref;
    } //-- void setRef(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "name = '" );
        buf.append( getName() + "'" );
        buf.append( "\n" ); 
        buf.append( "ref = '" );
        buf.append( getRef() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
