/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.cli;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.doxia.ConverterException;
import org.apache.maven.doxia.DefaultConverter;
import org.apache.maven.doxia.UnsupportedFormatException;
import org.apache.maven.doxia.cli.CLIManager;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.SystemStreamLog;
import org.apache.maven.doxia.wrapper.InputFileWrapper;
import org.apache.maven.doxia.wrapper.OutputFileWrapper;
import org.codehaus.plexus.util.Os;

public class ConverterCli {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            args = new String[]{"-h"};
        }
        System.exit(ConverterCli.doMain(args));
    }

    private static int doMain(String[] args) {
        OutputFileWrapper output;
        InputFileWrapper input;
        boolean showErrors;
        CommandLine commandLine;
        CLIManager cliManager = new CLIManager();
        try {
            commandLine = cliManager.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            CLIManager.displayHelp();
            return 1;
        }
        if ("1.4".compareTo(System.getProperty("java.specification.version")) > 0) {
            System.err.println("Sorry, but JDK 1.4 or above is required to execute Doxia. You appear to be using Java:");
            System.err.println("java version \"" + System.getProperty("java.version", "<unknown java version>") + "\"");
            System.err.println(System.getProperty("java.runtime.name", "<unknown runtime name>") + " (build " + System.getProperty("java.runtime.version", "<unknown runtime version>") + ")");
            System.err.println(System.getProperty("java.vm.name", "<unknown vm name>") + " (build " + System.getProperty("java.vm.version", "<unknown vm version>") + ", " + System.getProperty("java.vm.info", "<unknown vm info>") + ")");
            return 1;
        }
        if (commandLine.hasOption('h')) {
            CLIManager.displayHelp();
            return 0;
        }
        if (commandLine.hasOption('v')) {
            ConverterCli.showVersion();
            return 0;
        }
        boolean debug = commandLine.hasOption('X');
        boolean bl = showErrors = debug || commandLine.hasOption('e');
        if (showErrors) {
            System.out.println("+ Error stacktraces are turned on.");
        }
        DefaultConverter converter = new DefaultConverter();
        SystemStreamLog log = new SystemStreamLog();
        if (debug) {
            log.setLogLevel(0);
        }
        converter.enableLogging((Log)log);
        try {
            input = InputFileWrapper.valueOf(commandLine.getOptionValue("in"), commandLine.getOptionValue("from"), commandLine.getOptionValue("inEncoding"), converter.getInputFormats());
            output = OutputFileWrapper.valueOf(commandLine.getOptionValue("out"), commandLine.getOptionValue("to"), commandLine.getOptionValue("outEncoding"), converter.getOutputFormats());
        }
        catch (IllegalArgumentException e) {
            ConverterCli.showFatalError("Illegal argument: " + e.getMessage(), e, showErrors);
            CLIManager.displayHelp();
            return 1;
        }
        catch (UnsupportedEncodingException e) {
            ConverterCli.showFatalError(e.getMessage(), e, showErrors);
            return 1;
        }
        catch (FileNotFoundException e) {
            ConverterCli.showFatalError(e.getMessage(), e, showErrors);
            return 1;
        }
        boolean format = commandLine.hasOption('f');
        converter.setFormatOutput(format);
        try {
            converter.convert(input, output);
        }
        catch (UnsupportedFormatException e) {
            ConverterCli.showFatalError(e.getMessage(), e, showErrors);
            return 1;
        }
        catch (ConverterException e) {
            ConverterCli.showFatalError("Converter exception: " + e.getMessage(), e, showErrors);
            return 1;
        }
        catch (IllegalArgumentException e) {
            ConverterCli.showFatalError("Illegal argument: " + e.getMessage(), e, showErrors);
            return 1;
        }
        catch (RuntimeException e) {
            ConverterCli.showFatalError("Runtime exception: " + e.getMessage(), e, showErrors);
            return 1;
        }
        return 0;
    }

    private static void showVersion() {
        try {
            Properties properties = new Properties();
            InputStream resourceAsStream = ConverterCli.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven.doxia/doxia-converter/pom.properties");
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
                if (properties.getProperty("builtOn") != null) {
                    System.out.println("Doxia Converter version: " + properties.getProperty("version", "unknown") + " built on " + properties.getProperty("builtOn"));
                } else {
                    System.out.println("Doxia Converter version: " + properties.getProperty("version", "unknown"));
                }
            } else {
                System.out.println("Doxia Converter version: " + properties.getProperty("version", "unknown"));
            }
            System.out.println("Java version: " + System.getProperty("java.version", "<unknown java version>"));
            System.out.println("OS name: \"" + Os.OS_NAME + "\" version: \"" + Os.OS_VERSION + "\" arch: \"" + Os.OS_ARCH + "\" family: \"" + Os.OS_FAMILY + "\"");
        }
        catch (IOException e) {
            System.err.println("Unable to determine version from JAR file: " + e.getMessage());
        }
    }

    private static void showFatalError(String message, Exception e, boolean show) {
        System.err.println("FATAL ERROR: " + message);
        if (show) {
            System.err.println("Error stacktrace:");
            e.printStackTrace();
        } else {
            System.err.println("For more information, run with the -e flag");
        }
    }
}

