/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.cli;

import com.ibm.icu.text.CharsetDetector;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.doxia.DefaultConverter;
import org.codehaus.plexus.util.StringUtils;

class CLIManager {
    static final char HELP = 'h';
    static final char VERSION = 'v';
    static final String IN = "in";
    static final String OUT = "out";
    static final String FROM = "from";
    static final String TO = "to";
    static final String INENCODING = "inEncoding";
    static final char FORMAT = 'f';
    static final String OUTENCODING = "outEncoding";
    static final char DEBUG = 'X';
    static final char ERRORS = 'e';
    private static final Options OPTIONS = new Options();

    CLIManager() {
    }

    CommandLine parse(String[] args) throws ParseException {
        if (args == null) {
            throw new IllegalArgumentException("args is required.");
        }
        String[] cleanArgs = this.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(OPTIONS, cleanArgs);
    }

    static void displayHelp() {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("doxia [options] -in <arg> [-from <arg>] [-inEncoding <arg>] -out <arg> -to <arg> [-outEncoding <arg>]\n", "\nOptions:", OPTIONS, CLIManager.getSupportedFormatAndEncoding());
    }

    private static String getSupportedFormatAndEncoding() {
        return CLIManager.getSupportedFormat() + "\n" + CLIManager.getSupportedEncoding();
    }

    private static String getSupportedFormat() {
        return "\nSupported Formats:\n from: " + StringUtils.join((Object[])DefaultConverter.SUPPORTED_FROM_FORMAT, (String)", ") + " or autodetect" + "\n out: " + StringUtils.join((Object[])DefaultConverter.SUPPORTED_TO_FORMAT, (String)", ") + "\n";
    }

    private static String getSupportedEncoding() {
        return "\nSupported Encoding:\n " + StringUtils.join((Object[])CharsetDetector.getAllDetectableCharsets(), (String)", ");
    }

    private String[] cleanArgs(String[] args) {
        ArrayList<String> cleaned = new ArrayList<String>();
        StringBuffer currentArg = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            boolean addedToBuffer = false;
            if (arg.startsWith("\"")) {
                if (currentArg != null) {
                    cleaned.add(currentArg.toString());
                }
                currentArg = new StringBuffer(arg.substring(1));
                addedToBuffer = true;
            }
            if (arg.endsWith("\"")) {
                String cleanArgPart = arg.substring(0, arg.length() - 1);
                if (currentArg != null) {
                    if (addedToBuffer) {
                        currentArg.setLength(currentArg.length() - 1);
                    } else {
                        currentArg.append(' ').append(cleanArgPart);
                    }
                    cleaned.add(currentArg.toString());
                } else {
                    cleaned.add(cleanArgPart);
                }
                currentArg = null;
                continue;
            }
            if (addedToBuffer) continue;
            if (currentArg != null) {
                currentArg.append(' ').append(arg);
                continue;
            }
            cleaned.add(arg);
        }
        if (currentArg != null) {
            cleaned.add(currentArg.toString());
        }
        int cleanedSz = cleaned.size();
        String[] cleanArgs = null;
        cleanArgs = cleanedSz == 0 ? args : cleaned.toArray(new String[cleanedSz]);
        return cleanArgs;
    }

    static {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Display help information.");
        OPTIONS.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"Display version information.");
        OPTIONS.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.withDescription((String)"Input file or directory.");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((String)IN));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"Output file or directory.");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((String)OUT));
        OptionBuilder.withDescription((String)"From format. If not specified, try to autodetect it.");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((String)FROM));
        OptionBuilder.withDescription((String)"To format.");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((String)TO));
        OptionBuilder.withLongOpt((String)"inputEncoding");
        OptionBuilder.withDescription((String)"Input file encoding. If not specified, try to autodetect it.");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((String)INENCODING));
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.withDescription((String)"Format the output (actually only xml based outputs)  to be human readable.");
        OPTIONS.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"outputEncoding");
        OptionBuilder.withDescription((String)"Output file encoding. If not specified, use the input encoding (or autodetected).");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create((String)OUTENCODING));
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"Produce execution debug output.");
        OPTIONS.addOption(OptionBuilder.create((char)'X'));
        OptionBuilder.withLongOpt((String)"errors");
        OptionBuilder.withDescription((String)"Produce execution error messages.");
        OPTIONS.addOption(OptionBuilder.create((char)'e'));
    }
}

