/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xdoc;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlUtil;

public class XmlWriterXdocSink
extends XdocSink {
    private StringWriter xdocWriter;
    private XMLWriter xmlWriter;

    private XmlWriterXdocSink(StringWriter out, String encoding) {
        super(out, encoding);
        this.xdocWriter = out;
        this.xmlWriter = new PrettyPrintXMLWriter(out);
    }

    public XmlWriterXdocSink(XMLWriter out) {
        this(new StringWriter(), "UTF-8");
        this.xmlWriter = out;
    }

    public void close() {
        super.close();
        String xdocContent = this.xdocWriter.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Xdoc content: " + xdocContent);
        }
        StringWriter formattedContent = new StringWriter();
        try {
            XmlUtil.prettyFormat(new StringReader(xdocContent), formattedContent);
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error("IOException: " + e.getMessage(), e);
            }
            formattedContent = new StringWriter();
            formattedContent.write(xdocContent);
        }
        this.xmlWriter.writeMarkup(formattedContent.toString());
    }
}

