/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.module.twiki.parser.AnchorBlock;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.ImageBlock;
import org.apache.maven.doxia.module.twiki.parser.LinkBlock;
import org.apache.maven.doxia.module.twiki.parser.TextBlock;
import org.apache.maven.doxia.module.twiki.parser.WikiWordBlock;
import org.apache.maven.doxia.module.twiki.parser.WikiWordLinkResolver;
import org.apache.maven.doxia.module.twiki.parser.XHTMLBlock;

public class TextParser {
    private static final Pattern WIKIWORD_PATTERN = Pattern.compile("(!?([A-Z]\\w*[.])?([A-Z][a-z]+){2,}(#\\w*)?)");
    private static final Pattern SPECIFICLINK_PATTERN = Pattern.compile("!?\\[\\[([^\\]]+)\\]\\[([^\\]]+)\\]\\]");
    private static final Pattern FORCEDLINK_PATTERN = Pattern.compile("(!)?(\\[\\[(.+)\\]\\])");
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("#(([A-Z][A-Za-z]*){2,})");
    private static final Pattern URL_PATTERN = Pattern.compile("(\\w+):[/][/][^\\s]*");
    private static final Pattern IMAGE_PATTERN = Pattern.compile("(.*)\\.(png|jpg|gif|bmp)");
    private static final Pattern IMAGE_TAG_PATTERN = Pattern.compile("<img\\b.*?\\bsrc=([\"'])(.*?)\\1.*>", 2);
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<(/?)([\\w]*)(.*?)(/?)>", 32);
    private final WikiWordLinkResolver wikiWordLinkResolver;
    private boolean noautolink;

    public TextParser(WikiWordLinkResolver resolver) {
        this.wikiWordLinkResolver = resolver;
    }

    public final List parse(String line) {
        ArrayList<TextBlock> ret = new ArrayList<TextBlock>();
        Matcher linkMatcher = SPECIFICLINK_PATTERN.matcher(line);
        Matcher wikiMatcher = WIKIWORD_PATTERN.matcher(line);
        Matcher forcedLinkMatcher = FORCEDLINK_PATTERN.matcher(line);
        Matcher anchorMatcher = ANCHOR_PATTERN.matcher(line);
        Matcher urlMatcher = URL_PATTERN.matcher(line);
        Matcher imageTagMatcher = IMAGE_TAG_PATTERN.matcher(line);
        Matcher tagMatcher = HTML_TAG_PATTERN.matcher(line);
        Matcher xhtmlMatcher = null;
        if (tagMatcher.find()) {
            String tag = tagMatcher.group(2);
            Pattern pattern = Pattern.compile("(\\<" + tag + ".*\\>)(.*)?(\\<\\/" + tag + "\\>)(.*)?", 32);
            xhtmlMatcher = pattern.matcher(line);
        }
        if (xhtmlMatcher != null && xhtmlMatcher.find()) {
            this.parseXHTML(line, ret, xhtmlMatcher);
        } else if (linkMatcher.find()) {
            this.parseLink(line, ret, linkMatcher);
        } else if (wikiMatcher.find() && this.startLikeWord(wikiMatcher, line) && !this.noautolink) {
            this.parseWiki(line, ret, wikiMatcher);
        } else if (forcedLinkMatcher.find()) {
            this.parseForcedLink(line, ret, forcedLinkMatcher);
        } else if (anchorMatcher.find() && this.isAWord(anchorMatcher, line)) {
            this.parseAnchor(line, ret, anchorMatcher);
        } else if (urlMatcher.find() && this.isAWord(urlMatcher, line)) {
            this.parseUrl(line, ret, urlMatcher);
        } else if (imageTagMatcher.find()) {
            this.parseImage(line, ret, imageTagMatcher);
        } else if (line.length() != 0) {
            ret.add(new TextBlock(line));
        }
        return ret;
    }

    private void parseImage(String line, List ret, Matcher imageTagMatcher) {
        ret.addAll(this.parse(line.substring(0, imageTagMatcher.start())));
        String src = imageTagMatcher.group(2);
        ret.add(new ImageBlock(src));
        ret.addAll(this.parse(line.substring(imageTagMatcher.end(), line.length())));
    }

    private void parseUrl(String line, List ret, Matcher urlMatcher) {
        ret.addAll(this.parse(line.substring(0, urlMatcher.start())));
        String url = urlMatcher.group(0);
        Matcher imageMatcher = IMAGE_PATTERN.matcher(url);
        if (imageMatcher.matches()) {
            ret.add(new ImageBlock(url));
        } else {
            ret.add(new LinkBlock(url, new TextBlock(url)));
        }
        ret.addAll(this.parse(line.substring(urlMatcher.end(), line.length())));
    }

    private void parseAnchor(String line, List ret, Matcher anchorMatcher) {
        ret.addAll(this.parse(line.substring(0, anchorMatcher.start())));
        ret.add(new AnchorBlock(anchorMatcher.group(1)));
        ret.addAll(this.parse(line.substring(anchorMatcher.end(), line.length())));
    }

    private void parseForcedLink(String line, List ret, Matcher forcedLinkMatcher) {
        if (forcedLinkMatcher.group(1) != null) {
            ret.add(new TextBlock(forcedLinkMatcher.group(2)));
        } else {
            String showText = forcedLinkMatcher.group(3);
            if (showText.trim().startsWith("mailto:")) {
                String s = showText.trim();
                int i = s.indexOf(32);
                if (i == -1) {
                    ret.add(new TextBlock(s));
                } else {
                    ret.add(new LinkBlock(s.substring(0, i), new TextBlock(s.substring(i).trim())));
                }
            } else {
                ret.addAll(this.parse(line.substring(0, forcedLinkMatcher.start())));
                ret.add(this.createLink(showText, showText));
                ret.addAll(this.parse(line.substring(forcedLinkMatcher.end(), line.length())));
            }
        }
    }

    private Block createLink(String link, String showText) {
        Block content = URL_PATTERN.matcher(showText).matches() && IMAGE_PATTERN.matcher(showText).matches() ? new ImageBlock(showText) : new TextBlock(showText);
        if (URL_PATTERN.matcher(link).matches()) {
            return new LinkBlock(link, content);
        }
        StringTokenizer tokenizer = new StringTokenizer(link);
        StringBuffer sb = new StringBuffer();
        while (tokenizer.hasMoreElements()) {
            String s = tokenizer.nextToken();
            sb.append(s.substring(0, 1).toUpperCase());
            sb.append(s.substring(1));
        }
        return new WikiWordBlock(sb.toString(), content, this.wikiWordLinkResolver);
    }

    private void parseWiki(String line, List ret, Matcher wikiMatcher) {
        String wikiWord = wikiMatcher.group();
        ret.addAll(this.parse(line.substring(0, wikiMatcher.start())));
        if (wikiWord.startsWith("!")) {
            ret.add(new TextBlock(wikiWord.substring(1)));
        } else {
            ret.add(new WikiWordBlock(wikiWord, this.wikiWordLinkResolver));
        }
        ret.addAll(this.parse(line.substring(wikiMatcher.end(), line.length())));
    }

    private void parseLink(String line, List ret, Matcher linkMatcher) {
        ret.addAll(this.parse(line.substring(0, linkMatcher.start())));
        if (line.charAt(linkMatcher.start()) == '!') {
            ret.add(new TextBlock(line.substring(linkMatcher.start() + 1, linkMatcher.end())));
        } else {
            ret.add(this.createLink(linkMatcher.group(1), linkMatcher.group(2)));
        }
        ret.addAll(this.parse(line.substring(linkMatcher.end(), line.length())));
    }

    private void parseXHTML(String line, List ret, Matcher xhtmlMatcher) {
        if (xhtmlMatcher.group(1).indexOf("noautolink") != -1) {
            this.noautolink = true;
        } else {
            ret.add(new XHTMLBlock(xhtmlMatcher.group(1)));
        }
        ret.addAll(this.parse(xhtmlMatcher.group(2)));
        if (xhtmlMatcher.group(1).indexOf("noautolink") != -1) {
            this.noautolink = false;
        } else {
            ret.add(new XHTMLBlock(xhtmlMatcher.group(3)));
        }
        ret.addAll(this.parse(xhtmlMatcher.group(4)));
    }

    private boolean isAWord(Matcher m, String line) {
        return this.startLikeWord(m, line) && this.endLikeWord(m, line);
    }

    private boolean startLikeWord(Matcher m, String line) {
        int start = m.start();
        boolean ret = false;
        if (start == 0) {
            ret = true;
        } else if (start > 0 && this.isSpace(line.charAt(start - 1))) {
            ret = true;
        }
        return ret;
    }

    private boolean endLikeWord(Matcher m, String line) {
        int end = m.end();
        boolean ret = true;
        if (end < line.length()) {
            ret = this.isSpace(line.charAt(end));
        }
        return ret;
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }
}

