/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BoldBlock;
import org.apache.maven.doxia.module.twiki.parser.FormatBlockFactory;
import org.apache.maven.doxia.module.twiki.parser.ItalicBlock;
import org.apache.maven.doxia.module.twiki.parser.MonospaceBlock;
import org.apache.maven.doxia.module.twiki.parser.TextParser;

public class FormatedTextParser {
    private TextParser textParser;
    private static final Map FACTORY_MAP = new HashMap();
    private static final FormatBlockFactory BOLD_FACTORY = new FormatBlockFactory(){

        public Block createBlock(Block[] childrens) {
            return new BoldBlock(childrens);
        }
    };
    private static final FormatBlockFactory ITALIC_FACTORY = new FormatBlockFactory(){

        public Block createBlock(Block[] childrens) {
            return new ItalicBlock(childrens);
        }
    };
    private static final FormatBlockFactory MONOSPACED_FACTORY = new FormatBlockFactory(){

        public Block createBlock(Block[] childrens) {
            return new MonospaceBlock(childrens);
        }
    };
    private static final FormatBlockFactory BOLDITALIC_FACTORY = new FormatBlockFactory(){

        public Block createBlock(Block[] childrens) {
            return new BoldBlock(new Block[]{new ItalicBlock(childrens)});
        }
    };
    private static final FormatBlockFactory BOLDMONO_FACTORY = new FormatBlockFactory(){

        public Block createBlock(Block[] childrens) {
            return new BoldBlock(new Block[]{new MonospaceBlock(childrens)});
        }
    };
    private static final String[] SPECIAL_CHAR = new String[]{"__", "==", "*", "_", "="};

    final Block[] parse(String line) {
        return this.parseFormat(line).toArray(new Block[0]);
    }

    static boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    static boolean isSpecial(char c) {
        boolean ret = false;
        for (int i = 0; !ret && i < SPECIAL_CHAR.length; ++i) {
            if (SPECIAL_CHAR[i].charAt(0) != c) continue;
            ret = true;
        }
        return ret;
    }

    private List parseFormat(String line) {
        int t;
        int specialLen;
        int i;
        ArrayList<Block> ret = new ArrayList<Block>();
        int[] lhOffsets = new int[SPECIAL_CHAR.length];
        int[] rhOffsets = new int[SPECIAL_CHAR.length];
        for (i = 0; i < SPECIAL_CHAR.length; ++i) {
            specialLen = SPECIAL_CHAR[i].length();
            t = 0;
            while (t != -1 && (t = line.indexOf(SPECIAL_CHAR[i], t)) != -1) {
                if (t == 0 || FormatedTextParser.isSpace(line.charAt(t - 1)) || this.isParenthesis(line.charAt(t - 1))) {
                    if (t + specialLen < line.length()) {
                        if (!FormatedTextParser.isSpecial(line.charAt(t + specialLen))) break;
                        t += specialLen;
                        continue;
                    }
                    t = -1;
                    continue;
                }
                t += specialLen;
            }
            lhOffsets[i] = t;
        }
        for (i = 0; i < lhOffsets.length; ++i) {
            specialLen = SPECIAL_CHAR[i].length();
            if (lhOffsets[i] == -1) continue;
            t = lhOffsets[i] + specialLen;
            while ((t = line.indexOf(SPECIAL_CHAR[i], t)) != -1) {
                char c = line.charAt(t - 1);
                if (t > 0 && !FormatedTextParser.isSpace(c) && !FormatedTextParser.isSpecial(c)) break;
                t += specialLen;
            }
            rhOffsets[i] = t;
        }
        int minIndex = -1;
        int charType = 0;
        for (int i2 = 0; i2 < lhOffsets.length; ++i2) {
            if (lhOffsets[i2] == -1 || rhOffsets[i2] == 1 || minIndex != -1 && lhOffsets[i2] >= minIndex || rhOffsets[i2] <= lhOffsets[i2]) continue;
            minIndex = lhOffsets[i2];
            charType = i2;
        }
        if (minIndex == -1) {
            ret.addAll(this.textParser.parse(line));
        } else {
            int len = SPECIAL_CHAR[charType].length();
            ret.addAll(this.parseFormat(line.substring(0, minIndex)));
            ret.add(((FormatBlockFactory)FACTORY_MAP.get(SPECIAL_CHAR[charType])).createBlock(this.parseFormat(line.substring(minIndex + len, rhOffsets[charType])).toArray(new Block[0])));
            ret.addAll(this.parseFormat(line.substring(rhOffsets[charType] + len)));
        }
        return ret;
    }

    private boolean isParenthesis(char c) {
        return c == '(' || c == ')';
    }

    public final void setTextParser(TextParser textParser) {
        if (textParser == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        this.textParser = textParser;
    }

    static {
        FACTORY_MAP.put("*", BOLD_FACTORY);
        FACTORY_MAP.put("_", ITALIC_FACTORY);
        FACTORY_MAP.put("=", MONOSPACED_FACTORY);
        FACTORY_MAP.put("__", BOLDITALIC_FACTORY);
        FACTORY_MAP.put("==", BOLDMONO_FACTORY);
    }
}

