/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.itext;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.doxia.module.itext.ITextFont;
import org.apache.maven.doxia.module.itext.ITextHeader;
import org.apache.maven.doxia.module.itext.ITextUtil;
import org.apache.maven.doxia.module.itext.SinkActionContext;
import org.apache.maven.doxia.sink.AbstractXmlSink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class ITextSink
extends AbstractXmlSink {
    public static final String DTD = "http://itext.sourceforge.net/itext.dtd";
    public static final String DOCTYPE = "ITEXT SYSTEM \"http://itext.sourceforge.net/itext.dtd\"";
    public static final String DEFAULT_CHAPTER_TITLE_LEADING = "36.0";
    public static final String DEFAULT_SECTION_TITLE_LEADING = "24.0";
    private ClassLoader currentClassLoader;
    private SinkActionContext actionContext;
    private Writer writer;
    private final XMLWriter xmlWriter;
    private boolean writeStart;
    private ITextHeader header;
    private ITextFont font;
    private int numberDepth = 1;
    private int depth = 0;
    private StringWriter tableCaptionWriter = null;
    private XMLWriter tableCaptionXMLWriter = null;
    private boolean anchorDefined = false;
    private boolean figureDefined = false;
    private Map warnMessages;

    protected ITextSink(Writer writer) {
        this(writer, "UTF-8");
    }

    protected ITextSink(Writer writer, String encoding) {
        this(new PrettyPrintXMLWriter(writer, encoding, null));
        this.writer = writer;
        this.writeStart = true;
    }

    protected ITextSink(PrettyPrintXMLWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.writeStart = false;
        this.init();
    }

    public ClassLoader getClassLoader() {
        return this.currentClassLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.currentClassLoader = cl;
    }

    public void close() {
        IOUtil.close(this.writer);
        if (this.getLog().isWarnEnabled() && this.warnMessages != null) {
            Iterator it = this.warnMessages.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Set set = (Set)entry.getValue();
                Iterator it2 = set.iterator();
                while (it2.hasNext()) {
                    String msg = (String)it2.next();
                    this.getLog().warn(msg);
                }
            }
            this.warnMessages = null;
        }
        this.init();
    }

    public void flush() {
        super.flush();
    }

    public void head_() {
        this.actionContext.release();
    }

    public void head() {
        this.init();
        this.actionContext.setAction(3);
    }

    public void author_() {
        this.actionContext.release();
    }

    public void author() {
        this.actionContext.setAction(1);
    }

    public void date_() {
        this.actionContext.release();
    }

    public void date() {
        this.actionContext.setAction(2);
    }

    public void title_() {
        this.actionContext.release();
    }

    public void title() {
        this.actionContext.setAction(0);
    }

    public void body_() {
        if (this.writeStart) {
            this.writeEndElement();
            this.writeEndElement();
        }
        this.actionContext.release();
    }

    public void body() {
        if (this.writeStart) {
            this.writeStartElement("itext");
            this.writeAddAttribute("title", this.header.getTitle());
            this.writeAddAttribute("author", this.header.getAuthors());
            this.writeAddAttribute("creationdate", this.header.getDate());
            this.writeAddAttribute("subject", this.header.getTitle());
            this.writeAddAttribute("keywords", "");
            this.writeAddAttribute("producer", "Generated with Doxia by " + System.getProperty("user.name"));
            this.writeAddAttribute("pagesize", ITextUtil.getPageSize(ITextUtil.getDefaultPageSize()));
            this.writeStartElement("chapter");
            this.writeAddAttribute("numberdepth", this.numberDepth);
            this.writeAddAttribute("depth", this.depth);
            this.writeAddAttribute("indent", "0.0");
            this.writeStartElement("title");
            this.writeAddAttribute("leading", DEFAULT_CHAPTER_TITLE_LEADING);
            this.writeAddAttribute("font", "Helvetica");
            this.writeAddAttribute("size", ITextFont.getSectionFontSize(0));
            this.writeAddAttribute("fontstyle", "bold");
            this.writeAddAttribute("blue", ITextFont.DEFAULT_FONT_COLOR_BLUE);
            this.writeAddAttribute("green", ITextFont.DEFAULT_FONT_COLOR_GREEN);
            this.writeAddAttribute("red", ITextFont.DEFAULT_FONT_COLOR_RED);
            this.writeAddAttribute("align", "Center");
            this.writeStartElement("chunk");
            this.writeAddAttribute("font", "Helvetica");
            this.writeAddAttribute("size", ITextFont.getSectionFontSize(0));
            this.writeAddAttribute("fontstyle", "bold");
            this.writeAddAttribute("blue", ITextFont.DEFAULT_FONT_COLOR_BLUE);
            this.writeAddAttribute("green", ITextFont.DEFAULT_FONT_COLOR_GREEN);
            this.writeAddAttribute("red", ITextFont.DEFAULT_FONT_COLOR_RED);
            this.write(this.header.getTitle());
            this.writeEndElement();
            this.writeEndElement();
        }
        this.actionContext.setAction(4);
    }

    public void sectionTitle() {
        this.actionContext.release();
    }

    public void sectionTitle_() {
        this.actionContext.setAction(10);
    }

    public void section1_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 0;
        this.actionContext.release();
    }

    public void section1() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(20);
    }

    public void sectionTitle1_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle1() {
        this.font.setSize(ITextFont.getSectionFontSize(1));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(11);
    }

    public void section2_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 0;
        this.actionContext.release();
    }

    public void section2() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(21);
    }

    public void sectionTitle2_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle2() {
        this.font.setSize(ITextFont.getSectionFontSize(2));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(12);
    }

    public void section3_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 1;
        this.actionContext.release();
    }

    public void section3() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(22);
    }

    public void sectionTitle3_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle3() {
        this.font.setSize(ITextFont.getSectionFontSize(3));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(13);
    }

    public void section4_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 1;
        this.actionContext.release();
    }

    public void section4() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(23);
    }

    public void sectionTitle4_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle4() {
        this.font.setSize(ITextFont.getSectionFontSize(4));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(14);
    }

    public void section5_() {
        this.writeEndElement();
        --this.numberDepth;
        this.depth = 1;
        this.actionContext.release();
    }

    public void section5() {
        ++this.numberDepth;
        this.depth = 1;
        this.writeStartElement("section");
        this.writeAddAttribute("numberdepth", this.numberDepth);
        this.writeAddAttribute("depth", this.depth);
        this.writeAddAttribute("indent", "0.0");
        this.lineBreak();
        this.actionContext.setAction(24);
    }

    public void sectionTitle5_() {
        this.writeEndElement();
        this.font.setSize(12.0f);
        this.bold_();
        this.actionContext.release();
    }

    public void sectionTitle5() {
        this.font.setSize(ITextFont.getSectionFontSize(5));
        this.font.setColor(Color.BLACK);
        this.bold();
        this.writeStartElement("title");
        this.writeAddAttribute("leading", DEFAULT_SECTION_TITLE_LEADING);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(15);
    }

    public void paragraph_() {
        if (this.actionContext.getCurrentAction() == 40 || this.actionContext.getCurrentAction() == 41 || this.actionContext.getCurrentAction() == 43) {
            return;
        }
        this.writeEndElement();
        this.actionContext.release();
    }

    public void paragraph() {
        if (this.actionContext.getCurrentAction() == 40 || this.actionContext.getCurrentAction() == 41 || this.actionContext.getCurrentAction() == 43) {
            return;
        }
        this.writeStartElement("paragraph");
        this.writeStartElement("newline");
        this.writeEndElement();
        this.actionContext.setAction(44);
    }

    public void list_() {
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void list() {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("list");
        this.writeAddAttribute("numbered", Boolean.FALSE.toString());
        this.writeAddAttribute("symbolindent", "15");
        this.actionContext.setAction(45);
    }

    public void listItem_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void listItem() {
        this.writeStartElement("listitem");
        this.writeAddAttribute("indentationleft", "20.0");
        this.actionContext.setAction(40);
    }

    public void numberedList_() {
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void numberedList(int numbering) {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("list");
        this.writeAddAttribute("numbered", Boolean.TRUE.toString());
        this.writeAddAttribute("symbolindent", "20");
        switch (numbering) {
            case 2: {
                this.writeAddAttribute("lettered", Boolean.TRUE.toString());
                this.writeAddAttribute("first", 65);
                break;
            }
            case 1: {
                this.writeAddAttribute("lettered", Boolean.TRUE.toString());
                this.writeAddAttribute("first", 97);
                break;
            }
            case 4: {
                this.writeAddAttribute("lettered", Boolean.TRUE.toString());
                this.writeAddAttribute("first", 73);
                break;
            }
            case 3: {
                this.writeAddAttribute("lettered", Boolean.TRUE.toString());
                this.writeAddAttribute("first", 105);
                break;
            }
            default: {
                this.writeAddAttribute("lettered", Boolean.FALSE.toString());
            }
        }
        this.actionContext.setAction(42);
    }

    public void numberedListItem_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void numberedListItem() {
        this.writeStartElement("listitem");
        this.writeAddAttribute("indentationleft", "20");
        this.actionContext.setAction(41);
    }

    public void definitionList_() {
        this.actionContext.release();
    }

    public void definitionList() {
        this.lineBreak();
        this.actionContext.setAction(30);
    }

    public void definedTerm_() {
        this.font.setSize(12.0f);
        this.bold_();
        this.writeEndElement();
        this.actionContext.release();
        this.lineBreak();
    }

    public void definedTerm() {
        this.font.setSize(14.0f);
        this.bold();
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(32);
    }

    public void definition_() {
        this.writeEndElement();
        this.actionContext.release();
        this.lineBreak();
    }

    public void definition() {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.write("\u00a0" + StringUtils.repeat(" ", 16), false, false);
        this.writeEndElement();
        this.actionContext.setAction(43);
    }

    public void definitionListItem_() {
        this.actionContext.release();
    }

    public void definitionListItem() {
        this.actionContext.setAction(31);
    }

    public void table_() {
        if (this.tableCaptionXMLWriter != null) {
            this.tableCaptionXMLWriter = null;
            this.writeEndElement();
            this.writeEndElement();
            this.writeStartElement("paragraph");
            this.writeAddAttribute("align", "Center");
            this.write(this.tableCaptionWriter.toString(), true);
            this.writeEndElement();
            this.tableCaptionWriter = null;
        } else {
            this.writeEndElement();
            this.writeEndElement();
        }
        this.actionContext.release();
    }

    public void table() {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("table");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.writeAddAttribute("align", "Center");
        this.writeAddAttribute("width", "100.0%");
        this.writeAddAttribute("tablefitspage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellsfitpage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellpadding", "10");
        this.actionContext.setAction(50);
    }

    public void tableCaption_() {
        this.actionContext.release();
    }

    public void tableCaption() {
        this.tableCaptionWriter = new StringWriter();
        this.tableCaptionXMLWriter = new PrettyPrintXMLWriter(this.tableCaptionWriter);
        this.actionContext.setAction(51);
    }

    public void tableCell_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void tableCell() {
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.writeAddAttribute("horizontalalign", "Left");
        this.actionContext.setAction(52);
    }

    public void tableCell(String width) {
        this.actionContext.setAction(52);
    }

    public void tableHeaderCell_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void tableHeaderCell() {
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.writeAddAttribute("header", Boolean.TRUE.toString());
        this.writeAddAttribute("bgred", Color.GRAY.getRed());
        this.writeAddAttribute("bgblue", Color.GRAY.getBlue());
        this.writeAddAttribute("bggreen", Color.GRAY.getGreen());
        this.writeAddAttribute("horizontalalign", "Center");
        this.actionContext.setAction(53);
    }

    public void tableHeaderCell(String width) {
        this.actionContext.setAction(53);
    }

    public void tableRow_() {
        this.writeEndElement();
        this.actionContext.release();
    }

    public void tableRow() {
        this.writeStartElement("row");
        this.actionContext.setAction(54);
    }

    public void tableRows_() {
        this.actionContext.release();
    }

    public void tableRows(int[] justification, boolean grid) {
        this.writeAddAttribute("columns", justification.length);
        this.actionContext.setAction(55);
    }

    public void verbatim_() {
        this.writeEndElement();
        this.writeEndElement();
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
    }

    public void verbatim(boolean boxed) {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("table");
        this.writeAddAttribute("columns", "1");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.writeAddAttribute("align", "Center");
        this.writeAddAttribute("tablefitspage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellsfitpage", Boolean.TRUE.toString());
        this.writeAddAttribute("cellpadding", "10");
        this.writeAddAttribute("width", "100.0%");
        this.writeStartElement("row");
        this.writeStartElement("cell");
        this.writeAddAttribute("left", Boolean.TRUE.toString());
        this.writeAddAttribute("right", Boolean.TRUE.toString());
        this.writeAddAttribute("top", Boolean.TRUE.toString());
        this.writeAddAttribute("bottom", Boolean.TRUE.toString());
        this.actionContext.setAction(60);
    }

    public void figure_() {
        this.writeEndElement();
        this.writeEndElement();
        this.actionContext.release();
        this.figureDefined = false;
    }

    public void figure() {
        this.figureDefined = true;
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.writeStartElement("image");
        this.actionContext.setAction(70);
    }

    public void figureCaption_() {
        this.actionContext.release();
    }

    public void figureCaption() {
        this.actionContext.setAction(71);
    }

    public void figureGraphics(String name) {
        String urlName = null;
        File nameFile = null;
        if (name.toLowerCase(Locale.ENGLISH).startsWith("http://") || name.toLowerCase(Locale.ENGLISH).startsWith("https://")) {
            urlName = name;
        } else if (System.getProperty("itext.basedir") != null) {
            try {
                nameFile = new File(System.getProperty("itext.basedir"), name);
                urlName = nameFile.toURL().toString();
            }
            catch (MalformedURLException e) {
                this.getLog().error("MalformedURLException: " + e.getMessage(), e);
            }
        } else if (this.getClassLoader() != null) {
            if (this.getClassLoader().getResource(name) != null) {
                urlName = this.getClassLoader().getResource(name).toString();
            }
        } else if (ITextSink.class.getClassLoader().getResource(name) != null) {
            urlName = ITextSink.class.getClassLoader().getResource(name).toString();
        }
        if (urlName == null) {
            String msg = "No image '" + name + "' found in the class loader. Try to call setClassLoader(ClassLoader) before.";
            this.logMessage("imageNotFound", msg);
            return;
        }
        if (nameFile != null && !nameFile.exists()) {
            String msg = "No image '" + nameFile + "' found in your system, check the path.";
            this.logMessage("imageNotFound", msg);
            return;
        }
        boolean figureCalled = this.figureDefined;
        if (!figureCalled) {
            this.figure();
        }
        float width = 0.0f;
        float height = 0.0f;
        try {
            Image image = Image.getInstance(new URL(urlName));
            image.scaleToFit(ITextUtil.getDefaultPageSize().width() / 2.0f, ITextUtil.getDefaultPageSize().height() / 2.0f);
            width = image.plainWidth();
            height = image.plainHeight();
        }
        catch (BadElementException e) {
            this.getLog().error("BadElementException: " + e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            this.getLog().error("MalformedURLException: " + e.getMessage(), e);
        }
        catch (IOException e) {
            this.getLog().error("IOException: " + e.getMessage(), e);
        }
        this.writeAddAttribute("url", urlName);
        this.writeAddAttribute("align", "Middle");
        this.writeAddAttribute("plainwidth", String.valueOf(width));
        this.writeAddAttribute("plainheight", String.valueOf(height));
        this.actionContext.setAction(72);
        if (!figureCalled) {
            this.figure_();
        }
    }

    public void bold_() {
        this.font.removeBold();
    }

    public void bold() {
        this.font.addBold();
    }

    public void italic_() {
        this.font.removeItalic();
    }

    public void italic() {
        this.font.addItalic();
    }

    public void monospaced_() {
        this.font.setMonoSpaced(false);
    }

    public void monospaced() {
        this.font.setMonoSpaced(true);
    }

    public void link_() {
        this.writeEndElement();
        this.font.setColor(Color.BLACK);
        this.font.removeUnderlined();
        this.actionContext.release();
    }

    public void link(String name) {
        if (name == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        this.font.setColor(Color.BLUE);
        this.font.addUnderlined();
        this.writeStartElement("anchor");
        if (StringUtils.isNotEmpty(name) && name.startsWith("#") && StringUtils.isNotEmpty(this.header.getTitle())) {
            name = "#" + DoxiaUtils.encodeId(this.header.getTitle(), true) + "_" + name.substring(1);
        }
        this.writeAddAttribute("reference", HtmlTools.escapeHTML(name));
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.actionContext.setAction(80);
    }

    public void anchor_() {
        if (!this.anchorDefined) {
            this.writeAddAttribute("blue", "255");
            this.writeAddAttribute("green", "255");
            this.writeAddAttribute("red", "255");
            this.write("_");
        }
        this.anchorDefined = false;
        this.writeEndElement();
        this.actionContext.release();
    }

    public void anchor(String name) {
        String id;
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        if (StringUtils.isNotEmpty(this.header.getTitle())) {
            name = this.header.getTitle() + "_" + name;
        }
        if (!DoxiaUtils.isValidId(id = name)) {
            id = DoxiaUtils.encodeId(name, true);
            String msg = "Modified invalid link: '" + name + "' to '" + id + "'";
            this.logMessage("modifiedLink", msg);
        }
        this.writeStartElement("anchor");
        this.writeAddAttribute("name", id);
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.actionContext.setAction(81);
    }

    public void lineBreak() {
        if (this.actionContext.getCurrentAction() == 1 || this.actionContext.getCurrentAction() == 2 || this.actionContext.getCurrentAction() == 0) {
            return;
        }
        this.writeStartElement("newline");
        this.writeEndElement();
    }

    public void nonBreakingSpace() {
        this.write(" ");
    }

    public void pageBreak() {
        this.writeStartElement("newpage");
        this.writeEndElement();
    }

    public void horizontalRule() {
        this.writeStartElement("paragraph");
        this.writeAddAttribute("blue", "255");
        this.writeAddAttribute("green", "255");
        this.writeAddAttribute("red", "255");
        this.write("_");
        this.writeEndElement();
        this.writeStartElement("paragraph");
        this.writeStartElement("horizontalrule");
        this.writeEndElement();
        this.writeEndElement();
    }

    public void rawText(String text) {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", this.font.getFontName());
        this.writeAddAttribute("size", this.font.getFontSize());
        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
        this.writeAddAttribute("blue", this.font.getFontColorBlue());
        this.writeAddAttribute("green", this.font.getFontColorGreen());
        this.writeAddAttribute("red", this.font.getFontColorRed());
        this.write(text, false);
        this.writeEndElement();
    }

    public void text(String text) {
        if (StringUtils.isEmpty(text)) {
            return;
        }
        switch (this.actionContext.getCurrentAction()) {
            case 1: {
                this.header.addAuthor(text);
                break;
            }
            case 2: {
                this.header.setDate(text);
                break;
            }
            case 0: {
                this.header.setTitle(text);
                break;
            }
            case 51: {
                this.tableCaptionXMLWriter.writeText(text);
                break;
            }
            case 60: {
                LineNumberReader lnr = new LineNumberReader(new StringReader(text));
                try {
                    String line;
                    while ((line = lnr.readLine()) != null) {
                        this.writeStartElement("chunk");
                        this.writeAddAttribute("font", this.font.getFontName());
                        this.writeAddAttribute("size", this.font.getFontSize());
                        this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                        this.writeAddAttribute("blue", this.font.getFontColorBlue());
                        this.writeAddAttribute("green", this.font.getFontColorGreen());
                        this.writeAddAttribute("red", this.font.getFontColorRed());
                        this.write("<![CDATA[", true);
                        line = StringUtils.replace(line, "<![CDATA[", "< ![CDATA[");
                        line = StringUtils.replace(line, "]]>", "]] >");
                        this.write(line, true, false);
                        this.write("]]>", true);
                        this.writeEndElement();
                        this.lineBreak();
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException: ", e);
                }
            }
            case 71: {
                this.writeAddAttribute("alt", text);
                break;
            }
            case 3: 
            case 10: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 50: 
            case 54: 
            case 70: 
            case 72: 
            case 82: {
                break;
            }
            case 81: {
                this.anchorDefined = true;
            }
            default: {
                this.writeStartElement("chunk");
                this.writeAddAttribute("font", this.font.getFontName());
                this.writeAddAttribute("size", this.font.getFontSize());
                this.writeAddAttribute("fontstyle", this.font.getFontStyle());
                this.writeAddAttribute("blue", this.font.getFontColorBlue());
                this.writeAddAttribute("green", this.font.getFontColorGreen());
                this.writeAddAttribute("red", this.font.getFontColorRed());
                this.write(text);
                this.writeEndElement();
            }
        }
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        String msg = "Unknown Sink event: '" + name + "', ignoring!";
        this.logMessage("unknownEvent", msg);
    }

    protected void init() {
        super.init();
        this.actionContext = new SinkActionContext();
        this.font = new ITextFont();
        this.header = new ITextHeader();
        this.numberDepth = 1;
        this.depth = 0;
        this.tableCaptionWriter = null;
        this.tableCaptionXMLWriter = null;
        this.anchorDefined = false;
        this.figureDefined = false;
        this.warnMessages = null;
    }

    private void writeStartElement(String tag) {
        if (this.tableCaptionXMLWriter == null) {
            this.xmlWriter.startElement(tag);
        } else {
            this.tableCaptionXMLWriter.startElement(tag);
        }
    }

    private void writeAddAttribute(String key, String value) {
        if (this.tableCaptionXMLWriter == null) {
            this.xmlWriter.addAttribute(key, value);
        } else {
            this.tableCaptionXMLWriter.addAttribute(key, value);
        }
    }

    private void writeAddAttribute(String key, int value) {
        if (this.tableCaptionXMLWriter == null) {
            this.xmlWriter.addAttribute(key, String.valueOf(value));
        } else {
            this.tableCaptionXMLWriter.addAttribute(key, String.valueOf(value));
        }
    }

    private void writeEndElement() {
        if (this.tableCaptionXMLWriter == null) {
            this.xmlWriter.endElement();
        } else {
            this.tableCaptionXMLWriter.endElement();
        }
    }

    protected void write(String aString) {
        this.write(aString, false);
    }

    private void write(String aString, boolean escapeHtml) {
        this.write(aString, escapeHtml, true);
    }

    private void write(String aString, boolean escapeHtml, boolean trim) {
        if (aString == null) {
            return;
        }
        if (trim) {
            aString = StringUtils.replace(aString, "\n", "");
            LineNumberReader lnr = new LineNumberReader(new StringReader(aString));
            StringBuffer sb = new StringBuffer();
            try {
                String line;
                while ((line = lnr.readLine()) != null) {
                    sb.append(ITextSink.beautifyPhrase(line.trim()));
                    sb.append(" ");
                }
                aString = sb.toString();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (aString.trim().length() == 0) {
                return;
            }
        }
        if (escapeHtml) {
            if (this.tableCaptionXMLWriter == null) {
                this.xmlWriter.writeMarkup(aString);
            } else {
                this.tableCaptionXMLWriter.writeMarkup(aString);
            }
        } else if (this.tableCaptionXMLWriter == null) {
            this.xmlWriter.writeText(aString);
        } else {
            this.tableCaptionXMLWriter.writeText(aString);
        }
    }

    private static String beautifyPhrase(String aString) {
        String[] strings = StringUtils.split(aString, " ");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].trim().length() == 0) continue;
            sb.append(strings[i].trim());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    private void startChunk(String fontName, int fontSize, String fontStyle, int fontColorBlue, int fontColorGreen, int fontColorRed, String localDestination) {
        this.writeStartElement("chunk");
        this.writeAddAttribute("font", fontName);
        this.writeAddAttribute("size", fontSize);
        this.writeAddAttribute("fontstyle", fontStyle);
        this.writeAddAttribute("blue", fontColorBlue);
        this.writeAddAttribute("green", fontColorGreen);
        this.writeAddAttribute("red", fontColorRed);
    }

    private void logMessage(String key, String msg) {
        TreeSet<String> set;
        msg = "[iText Sink] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(msg);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap();
        }
        if ((set = (TreeSet<String>)this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(msg);
        this.warnMessages.put(key, set);
    }
}

