/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.Converter;
import org.apache.maven.doxia.ConverterException;
import org.apache.maven.doxia.UnsupportedFormatException;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.SystemStreamLog;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.util.ConverterUtil;
import org.apache.maven.doxia.wrapper.InputFileWrapper;
import org.apache.maven.doxia.wrapper.InputReaderWrapper;
import org.apache.maven.doxia.wrapper.OutputFileWrapper;
import org.apache.maven.doxia.wrapper.OutputStreamWrapper;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.XmlUtil;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultConverter
implements Converter {
    private static final String APT_PARSER = "apt";
    private static final String CONFLUENCE_PARSER = "confluence";
    private static final String DOCBOOK_PARSER = "docbook";
    private static final String FML_PARSER = "fml";
    private static final String TWIKI_PARSER = "twiki";
    private static final String XDOC_PARSER = "xdoc";
    private static final String XHTML_PARSER = "xhtml";
    public static final String[] SUPPORTED_FROM_FORMAT = new String[]{"apt", "confluence", "docbook", "fml", "twiki", "xdoc", "xhtml"};
    private static final String APT_SINK = "apt";
    private static final String CONFLUENCE_SINK = "confluence";
    private static final String DOCBOOK_SINK = "docbook";
    private static final String FO_SINK = "fo";
    private static final String ITEXT_SINK = "itext";
    private static final String LATEX_SINK = "latex";
    private static final String RTF_SINK = "rtf";
    private static final String TWIKI_SINK = "twiki";
    private static final String XDOC_SINK = "xdoc";
    private static final String XHTML_SINK = "xhtml";
    public static final String[] SUPPORTED_TO_FORMAT = new String[]{"apt", "confluence", "docbook", "fo", "itext", "latex", "rtf", "twiki", "xdoc", "xhtml"};
    private boolean formatOutput;
    private PlexusContainer plexus;
    private Log log;

    public void enableLogging(Log log) {
        this.log = log;
    }

    protected Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public String[] getInputFormats() {
        return SUPPORTED_FROM_FORMAT;
    }

    public String[] getOutputFormats() {
        return SUPPORTED_TO_FORMAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(InputFileWrapper input, OutputFileWrapper output) throws UnsupportedFormatException, ConverterException {
        block12: {
            if (input == null) {
                throw new IllegalArgumentException("input is required");
            }
            if (output == null) {
                throw new IllegalArgumentException("output is required");
            }
            try {
                this.startPlexusContainer();
            }
            catch (PlexusContainerException e) {
                throw new ConverterException("PlexusContainerException: " + e.getMessage(), e);
            }
            try {
                List files;
                if (input.getFile().isFile()) {
                    this.parse(input.getFile(), input.getEncoding(), input.getFormat(), output);
                    break block12;
                }
                try {
                    files = FileUtils.getFiles(input.getFile(), "**/*." + input.getFormat(), StringUtils.join(FileUtils.getDefaultExcludes(), ", "));
                }
                catch (IOException e) {
                    throw new ConverterException("IOException: " + e.getMessage(), e);
                }
                catch (IllegalStateException e) {
                    throw new ConverterException("IllegalStateException: " + e.getMessage(), e);
                }
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    File f = (File)it.next();
                    this.parse(f, input.getEncoding(), input.getFormat(), output);
                }
            }
            finally {
                this.stopPlexusContainer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(InputReaderWrapper input, OutputStreamWrapper output) throws UnsupportedFormatException, ConverterException {
        if (input == null) {
            throw new IllegalArgumentException("input is required");
        }
        if (output == null) {
            throw new IllegalArgumentException("output is required");
        }
        try {
            this.startPlexusContainer();
        }
        catch (PlexusContainerException e) {
            throw new ConverterException("PlexusContainerException: " + e.getMessage(), e);
        }
        try {
            Sink sink;
            SinkFactory sinkFactory;
            Parser parser;
            try {
                parser = ConverterUtil.getParser(this.plexus, input.getFormat(), SUPPORTED_FROM_FORMAT);
                parser.enableLogging(this.log);
            }
            catch (ComponentLookupException e) {
                throw new ConverterException("ComponentLookupException: " + e.getMessage(), e);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Parser used: " + parser.getClass().getName());
            }
            try {
                sinkFactory = ConverterUtil.getSinkFactory(this.plexus, output.getFormat(), SUPPORTED_TO_FORMAT);
            }
            catch (ComponentLookupException e) {
                throw new ConverterException("ComponentLookupException: " + e.getMessage(), e);
            }
            try {
                sink = sinkFactory.createSink(output.getOutputStream(), output.getEncoding());
            }
            catch (IOException e) {
                throw new ConverterException("IOException: " + e.getMessage(), e);
            }
            sink.enableLogging(this.log);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Sink used: " + sink.getClass().getName());
            }
            this.parse(parser, input.getReader(), sink);
        }
        finally {
            this.stopPlexusContainer();
        }
    }

    public void setFormatOutput(boolean formatOutput) {
        this.formatOutput = formatOutput;
    }

    private void parse(File inputFile, String inputEncoding, String inputFormat, OutputFileWrapper output) throws ConverterException, UnsupportedFormatException {
        Sink sink;
        SinkFactory sinkFactory;
        Reader reader;
        File outputFile;
        Parser parser;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Parsing file from '" + inputFile.getAbsolutePath() + "' with the encoding '" + inputEncoding + "' to '" + output.getFile().getAbsolutePath() + "' with the encoding '" + output.getEncoding() + "'");
        }
        if (inputEncoding.equals("auto")) {
            inputEncoding = DefaultConverter.autoDetectEncoding(inputFile);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Auto detect encoding: " + inputEncoding);
            }
        }
        if (inputFormat.equals("auto")) {
            inputFormat = DefaultConverter.autoDetectFormat(inputFile, inputEncoding);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug("Auto detect input format: " + inputFormat);
            }
        }
        try {
            parser = ConverterUtil.getParser(this.plexus, inputFormat, SUPPORTED_FROM_FORMAT);
            parser.enableLogging(this.log);
        }
        catch (ComponentLookupException e) {
            throw new ConverterException("ComponentLookupException: " + e.getMessage(), e);
        }
        if (output.getFile().exists() && output.getFile().isDirectory()) {
            outputFile = new File(output.getFile(), inputFile.getName() + "." + output.getFormat());
        } else if (!SelectorUtils.match("**.*", output.getFile().getName())) {
            output.getFile().mkdirs();
            outputFile = new File(output.getFile(), inputFile.getName() + "." + output.getFormat());
        } else {
            output.getFile().getParentFile().mkdirs();
            outputFile = output.getFile();
        }
        try {
            reader = inputEncoding != null ? (parser.getType() == 2 ? ReaderFactory.newXmlReader(inputFile) : ReaderFactory.newReader(inputFile, inputEncoding)) : ReaderFactory.newPlatformReader(inputFile);
        }
        catch (IOException e) {
            throw new ConverterException("IOException: " + e.getMessage(), e);
        }
        try {
            sinkFactory = ConverterUtil.getSinkFactory(this.plexus, output.getFormat(), SUPPORTED_TO_FORMAT);
        }
        catch (ComponentLookupException e) {
            throw new ConverterException("ComponentLookupException: " + e.getMessage(), e);
        }
        try {
            String outputEncoding = StringUtils.isEmpty(output.getEncoding()) || output.getEncoding().equals("auto") ? inputEncoding : output.getEncoding();
            FileOutputStream out = new FileOutputStream(outputFile);
            sink = sinkFactory.createSink(out, outputEncoding);
        }
        catch (IOException e) {
            throw new ConverterException("IOException: " + e.getMessage(), e);
        }
        sink.enableLogging(this.log);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Sink used: " + sink.getClass().getName());
        }
        this.parse(parser, reader, sink);
        if (this.formatOutput && (output.getFormat().equals("docbook") || output.getFormat().equals(FO_SINK) || output.getFormat().equals(ITEXT_SINK) || output.getFormat().equals("xdoc") || output.getFormat().equals("xhtml"))) {
            if (output.getFormat().equals("docbook") || inputFormat.equals("docbook")) {
                return;
            }
            XmlStreamReader r = null;
            XmlStreamWriter w = null;
            try {
                r = ReaderFactory.newXmlReader(outputFile);
                CharArrayWriter caw = new CharArrayWriter();
                XmlUtil.prettyFormat(r, caw);
                w = WriterFactory.newXmlWriter(outputFile);
                w.write(caw.toString());
            }
            catch (IOException e) {
                try {
                    throw new ConverterException("IOException: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(r);
                    IOUtil.close(w);
                    throw throwable;
                }
            }
            IOUtil.close(r);
            IOUtil.close(w);
        }
    }

    private void parse(Parser parser, Reader reader, Sink sink) throws ConverterException {
        try {
            parser.parse(reader, sink);
        }
        catch (ParseException e) {
            throw new ConverterException("ParseException: " + e.getMessage(), e);
        }
        finally {
            IOUtil.close(reader);
            sink.flush();
            sink.close();
        }
    }

    private void startPlexusContainer() throws PlexusContainerException {
        if (this.plexus != null) {
            return;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("basedir", new File("").getAbsolutePath());
        DefaultContainerConfiguration containerConfiguration = new DefaultContainerConfiguration();
        containerConfiguration.setName("Doxia");
        containerConfiguration.setContext(context);
        this.plexus = new DefaultPlexusContainer(containerConfiguration);
    }

    private void stopPlexusContainer() {
        if (this.plexus == null) {
            return;
        }
        this.plexus.dispose();
        this.plexus = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String autoDetectEncoding(File f) {
        block7: {
            String string;
            BufferedInputStream is;
            XmlStreamReader reader;
            block6: {
                if (!f.isFile()) {
                    throw new IllegalArgumentException("The file '" + f.getAbsolutePath() + "' is not a file, could not detect encoding.");
                }
                reader = null;
                is = null;
                if (!XmlUtil.isXml(f)) break block6;
                reader = ReaderFactory.newXmlReader(f);
                String string2 = reader.getEncoding();
                IOUtil.close(reader);
                IOUtil.close(is);
                return string2;
            }
            try {
                is = new BufferedInputStream(new FileInputStream(f));
                CharsetDetector detector = new CharsetDetector();
                detector.setText(is);
                CharsetMatch match = detector.detect();
                string = match.getName().toUpperCase(Locale.ENGLISH);
            }
            catch (IOException e) {
                IOUtil.close(reader);
                IOUtil.close(is);
                break block7;
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    IOUtil.close(is);
                    throw throwable;
                }
            }
            IOUtil.close(reader);
            IOUtil.close(is);
            return string;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Could not detect the encoding for file: ");
        msg.append(f.getAbsolutePath());
        msg.append("\n Specify explicitly the encoding.");
        throw new UnsupportedOperationException(msg.toString());
    }

    private static String autoDetectFormat(File f, String encoding) {
        if (!f.isFile()) {
            throw new IllegalArgumentException("The file '" + f.getAbsolutePath() + "' is not a file, could not detect format.");
        }
        for (int i = 0; i < SUPPORTED_FROM_FORMAT.length; ++i) {
            String supportedFromFormat = SUPPORTED_FROM_FORMAT[i];
            if (supportedFromFormat.equalsIgnoreCase("apt") && DefaultConverter.isDoxiaFileName(f, supportedFromFormat)) {
                return supportedFromFormat;
            }
            if (supportedFromFormat.equalsIgnoreCase("confluence") && DefaultConverter.isDoxiaFileName(f, supportedFromFormat)) {
                return supportedFromFormat;
            }
            if (supportedFromFormat.equalsIgnoreCase("twiki") && DefaultConverter.isDoxiaFileName(f, supportedFromFormat)) {
                return supportedFromFormat;
            }
            String firstTag = DefaultConverter.getFirstTag(f);
            if (firstTag == null) continue;
            if (firstTag.equals("article") && supportedFromFormat.equalsIgnoreCase("docbook")) {
                return supportedFromFormat;
            }
            if (firstTag.equals("faqs") && supportedFromFormat.equalsIgnoreCase(FML_PARSER)) {
                return supportedFromFormat;
            }
            if (firstTag.equals("document") && supportedFromFormat.equalsIgnoreCase("xdoc")) {
                return supportedFromFormat;
            }
            if (!firstTag.equals("html") || !supportedFromFormat.equalsIgnoreCase("xhtml")) continue;
            return supportedFromFormat;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Could not detect the Doxia format for file: ");
        msg.append(f.getAbsolutePath());
        msg.append("\n Specify explicitly the Doxia format.");
        throw new UnsupportedOperationException(msg.toString());
    }

    private static boolean isDoxiaFileName(File f, String format) {
        if (f == null) {
            throw new IllegalArgumentException("f is required.");
        }
        Pattern pattern = Pattern.compile("(.*?)\\." + format.toLowerCase(Locale.ENGLISH) + "$");
        Matcher matcher = pattern.matcher(f.getName().toLowerCase(Locale.ENGLISH));
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFirstTag(File xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("xmlFile is required.");
        }
        if (!xmlFile.isFile()) {
            throw new IllegalArgumentException("The file '" + xmlFile.getAbsolutePath() + "' is not a file.");
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(xmlFile);
            MXParser parser = new MXParser();
            parser.setInput(reader);
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String string = parser.getName();
                    return string;
                }
                eventType = parser.nextToken();
            }
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        catch (XmlPullParserException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            IOUtil.close(reader);
        }
        return null;
    }
}

