/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.ps.ImageEncoderCCITTFax;
import org.apache.fop.render.ps.ImageEncoderJPEG;
import org.apache.fop.render.ps.PSFontUtils;
import org.apache.fop.render.ps.PSGraphics2DAdapter;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSSupportedFlavors;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRawEPS;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.ps.FormGenerator;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSets;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCFilter;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.DSCParserConstants;
import org.apache.xmlgraphics.ps.dsc.DefaultNestedDocumentHandler;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;
import org.apache.xmlgraphics.ps.dsc.events.DSCComment;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentBoundingBox;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentNeededResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentSuppliedResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentHiResBoundingBox;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentLanguageLevel;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPage;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPages;
import org.apache.xmlgraphics.ps.dsc.events.DSCEvent;
import org.apache.xmlgraphics.ps.dsc.events.DSCHeaderComment;
import org.apache.xmlgraphics.ps.dsc.events.PostScriptComment;
import org.apache.xmlgraphics.ps.dsc.tools.DSCTools;

public class ResourceHandler
implements DSCParserConstants,
PSSupportedFlavors {
    public static void process(FOUserAgent userAgent, InputStream in, OutputStream out, FontInfo fontInfo, ResourceTracker resTracker, Map formResources, int pageCount, Rectangle2D documentBoundingBox) throws DSCException, IOException {
        DSCEvent event;
        DSCParser parser = new DSCParser(in);
        PSGenerator gen = new PSGenerator(out);
        parser.setNestedDocumentHandler(new DefaultNestedDocumentHandler(gen));
        DSCHeaderComment header = DSCTools.checkAndSkipDSC30Header(parser);
        header.generate(gen);
        parser.setFilter(new DSCFilter(){
            private final Set filtered = new HashSet();
            {
                this.filtered.add("Pages");
                this.filtered.add("BoundingBox");
                this.filtered.add("HiResBoundingBox");
                this.filtered.add("DocumentNeededResources");
                this.filtered.add("DocumentSuppliedResources");
            }

            public boolean accept(DSCEvent event) {
                if (event.isDSCComment()) {
                    return !this.filtered.contains(event.asDSCComment().getName());
                }
                return true;
            }
        });
        while (true) {
            DSCComment comment;
            if ((event = parser.nextEvent()) == null) {
                ResourceHandler.reportInvalidDSC();
            }
            if (DSCTools.headerCommentsEndHere(event)) break;
            if (event.isDSCComment() && "LanguageLevel".equals((comment = event.asDSCComment()).getName())) {
                DSCCommentLanguageLevel level = (DSCCommentLanguageLevel)comment;
                gen.setPSLevel(level.getLanguageLevel());
            }
            event.generate(gen);
        }
        DSCCommentPages pages = new DSCCommentPages(pageCount);
        pages.generate(gen);
        new DSCCommentBoundingBox(documentBoundingBox).generate(gen);
        new DSCCommentHiResBoundingBox(documentBoundingBox).generate(gen);
        PSFontUtils.determineSuppliedFonts(resTracker, fontInfo, fontInfo.getUsedFonts());
        ResourceHandler.registerSuppliedForms(resTracker, formResources);
        DSCCommentDocumentSuppliedResources supplied = new DSCCommentDocumentSuppliedResources(resTracker.getDocumentSuppliedResources());
        supplied.generate(gen);
        DSCCommentDocumentNeededResources needed = new DSCCommentDocumentNeededResources(resTracker.getDocumentNeededResources());
        needed.generate(gen);
        event.generate(gen);
        PostScriptComment fontSetupPlaceholder = parser.nextPSComment("FOPFontSetup", gen);
        if (fontSetupPlaceholder == null) {
            throw new DSCException("Didn't find %FOPFontSetup comment in stream");
        }
        PSFontUtils.writeFontDict(gen, fontInfo, fontInfo.getUsedFonts());
        ResourceHandler.generateForms(resTracker, userAgent, formResources, gen);
        DSCComment pageOrTrailer = parser.nextDSCComment("Page", gen);
        if (pageOrTrailer == null) {
            throw new DSCException("Page expected, but none found");
        }
        while (true) {
            DSCCommentPage page = (DSCCommentPage)pageOrTrailer;
            page.generate(gen);
            pageOrTrailer = DSCTools.nextPageOrTrailer(parser, gen);
            if (pageOrTrailer == null) {
                ResourceHandler.reportInvalidDSC();
                continue;
            }
            if (!"Page".equals(pageOrTrailer.getName())) break;
        }
        pageOrTrailer.generate(gen);
        while (parser.hasNext()) {
            DSCEvent event2 = parser.nextEvent();
            event2.generate(gen);
        }
    }

    private static void reportInvalidDSC() throws DSCException {
        throw new DSCException("File is not DSC-compliant: Unexpected end of file");
    }

    private static void registerSuppliedForms(ResourceTracker resTracker, Map formResources) throws IOException {
        if (formResources == null) {
            return;
        }
        Iterator iter = formResources.values().iterator();
        while (iter.hasNext()) {
            PSImageFormResource form = (PSImageFormResource)iter.next();
            resTracker.registerSuppliedResource(form);
        }
    }

    private static void generateForms(ResourceTracker resTracker, FOUserAgent userAgent, Map formResources, PSGenerator gen) throws IOException {
        if (formResources == null) {
            return;
        }
        Iterator iter = formResources.values().iterator();
        while (iter.hasNext()) {
            PSImageFormResource form = (PSImageFormResource)iter.next();
            String uri = form.getImageURI();
            ImageManager manager = userAgent.getFactory().getImageManager();
            ImageInfo info = null;
            try {
                ImageSessionContext sessionContext = userAgent.getImageSessionContext();
                info = manager.getImageInfo(uri, sessionContext);
                ImageFlavor[] flavors = gen.getPSLevel() >= 3 ? LEVEL_3_FLAVORS_FORM : LEVEL_2_FLAVORS_FORM;
                Map hints = ImageUtil.getDefaultHints(sessionContext);
                Image img = manager.getImage(info, flavors, hints, sessionContext);
                String imageDescription = info.getMimeType() + " " + info.getOriginalURI();
                Dimension2D dimensionsPt = info.getSize().getDimensionPt();
                final Dimension dimensionsMpt = info.getSize().getDimensionMpt();
                if (img instanceof ImageGraphics2D) {
                    final ImageGraphics2D imageG2D = (ImageGraphics2D)img;
                    FormGenerator formGen = new FormGenerator(form.getName(), imageDescription, dimensionsPt){

                        protected void generatePaintProc(PSGenerator gen) throws IOException {
                            gen.getResourceTracker().notifyResourceUsageOnPage(PSProcSets.EPS_PROCSET);
                            gen.writeln("BeginEPSF");
                            PSGraphics2DAdapter adapter = new PSGraphics2DAdapter(gen, false);
                            adapter.paintImage(imageG2D.getGraphics2DImagePainter(), null, 0, 0, (int)Math.round(dimensionsMpt.getWidth()), (int)Math.round(dimensionsMpt.getHeight()));
                            gen.writeln("EndEPSF");
                        }
                    };
                    formGen.generate(gen);
                    continue;
                }
                if (img instanceof ImageRendered) {
                    ImageRendered imgRend = (ImageRendered)img;
                    RenderedImage ri = imgRend.getRenderedImage();
                    ImageFormGenerator formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), ri, false);
                    formGen.generate(gen);
                    continue;
                }
                if (img instanceof ImageXMLDOM) {
                    throw new UnsupportedOperationException("Embedding an ImageXMLDOM as a form isn't supported, yet");
                }
                if (img instanceof ImageRawStream) {
                    ImageFormGenerator formGen;
                    ImageEncoder encoder;
                    ImageRawStream jpeg;
                    ImageRawStream raw = (ImageRawStream)img;
                    if (raw instanceof ImageRawEPS) {
                        ImageRawEPS eps = (ImageRawEPS)raw;
                        throw new UnsupportedOperationException("Embedding EPS as forms isn't supported, yet");
                    }
                    if (raw instanceof ImageRawCCITTFax) {
                        jpeg = (ImageRawCCITTFax)raw;
                        encoder = new ImageEncoderCCITTFax((ImageRawCCITTFax)jpeg);
                        formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), info.getSize().getDimensionPx(), encoder, ((ImageRawCCITTFax)jpeg).getColorSpace(), 1, false);
                        formGen.generate(gen);
                        continue;
                    }
                    if (raw instanceof ImageRawJPEG) {
                        jpeg = (ImageRawJPEG)raw;
                        encoder = new ImageEncoderJPEG((ImageRawJPEG)jpeg);
                        formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), info.getSize().getDimensionPx(), encoder, ((ImageRawJPEG)jpeg).getColorSpace(), ((ImageRawJPEG)jpeg).isInverted());
                        formGen.generate(gen);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unsupported raw image: " + info);
                }
                throw new UnsupportedOperationException("Unsupported image type: " + img);
            }
            catch (ImageException ie) {
                throw new IOException("Error while generating form for image: " + ie.getMessage());
            }
        }
    }

    private static FormGenerator createMissingForm(String formName, final Dimension2D dimensions) {
        FormGenerator formGen = new FormGenerator(formName, null, dimensions){

            protected void generatePaintProc(PSGenerator gen) throws IOException {
                gen.writeln("0 setgray");
                gen.writeln("0 setlinewidth");
                String w = gen.formatDouble(dimensions.getWidth());
                String h = gen.formatDouble(dimensions.getHeight());
                gen.writeln(w + " " + h + " scale");
                gen.writeln("0 0 1 1 rectstroke");
                gen.writeln("newpath");
                gen.writeln("0 0 moveto");
                gen.writeln("1 1 lineto");
                gen.writeln("stroke");
                gen.writeln("newpath");
                gen.writeln("0 1 moveto");
                gen.writeln("1 0 lineto");
                gen.writeln("stroke");
            }
        };
        return formGen;
    }
}

