/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.modca.ImageContent;

public class ImageSegment
extends AbstractAFPObject {
    private static final String DEFAULT_NAME = "IS01";
    private String name;
    private byte[] nameBytes;
    private ImageContent imageContent = null;

    public ImageSegment() {
        this(DEFAULT_NAME);
    }

    public ImageSegment(String name) {
        if (name.length() != 4) {
            String msg = "Image segment name must be 4 characters long " + name;
            log.error("Constructor:: " + msg);
            throw new IllegalArgumentException(msg);
        }
        this.name = name;
        try {
            this.nameBytes = name.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            this.nameBytes = name.getBytes();
            log.warn("Constructor:: UnsupportedEncodingException translating the name " + name);
        }
    }

    public void setImageSize(int hresol, int vresol, int hsize, int vsize) {
        if (this.imageContent == null) {
            this.imageContent = new ImageContent();
        }
        this.imageContent.setImageSize(hresol, vresol, hsize, vsize);
    }

    public void setImageEncoding(byte encoding) {
        if (this.imageContent == null) {
            this.imageContent = new ImageContent();
        }
        this.imageContent.setImageEncoding(encoding);
    }

    public void setImageCompression(byte compression) {
        if (this.imageContent == null) {
            this.imageContent = new ImageContent();
        }
        this.imageContent.setImageCompression(compression);
    }

    public void setImageIDESize(byte size) {
        if (this.imageContent == null) {
            this.imageContent = new ImageContent();
        }
        this.imageContent.setImageIDESize(size);
    }

    public void setImageIDEColorModel(byte colorModel) {
        if (this.imageContent == null) {
            this.imageContent = new ImageContent();
        }
        this.imageContent.setImageIDEColorModel(colorModel);
    }

    public void setImageData(byte[] data) {
        if (this.imageContent == null) {
            this.imageContent = new ImageContent();
        }
        this.imageContent.setImageData(data);
    }

    public void writeDataStream(OutputStream os) throws IOException {
        this.writeStart(os);
        if (this.imageContent != null) {
            this.imageContent.writeDataStream(os);
        }
        this.writeEnd(os);
    }

    private void writeStart(OutputStream os) throws IOException {
        byte[] data = new byte[]{112, 4, 0, 0, 0, 0};
        for (int i = 0; i < this.nameBytes.length; ++i) {
            data[2 + i] = this.nameBytes[i];
        }
        os.write(data);
    }

    private void writeEnd(OutputStream os) throws IOException {
        byte[] data = new byte[]{113, 0};
        os.write(data);
    }
}

