/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.base14.Courier;
import org.apache.fop.fonts.base14.Helvetica;
import org.apache.fop.fonts.base14.TimesRoman;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.afp.AFPFontAttributes;
import org.apache.fop.render.afp.AFPGraphics2DAdapter;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.fonts.AFPFontInfo;
import org.apache.fop.render.afp.fonts.FopCharacterSet;
import org.apache.fop.render.afp.fonts.OutlineFont;
import org.apache.fop.render.afp.modca.AFPDataStream;
import org.apache.fop.render.afp.modca.ImageObject;
import org.apache.fop.render.afp.modca.PageObject;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;

public class AFPRenderer
extends AbstractPathOrientedRenderer {
    private static final int DEFAULT_DPI_RESOLUTION = 240;
    private static final int DPI_CONVERSION_FACTOR = 72000;
    private AFPDataStream afpDataStream = null;
    private HashMap pageSegmentsMap = null;
    private HashMap currentPageFonts = null;
    private Color currentColor = null;
    private int pageFontCounter = 0;
    private int currentFontSize = 0;
    private int pageWidth = 0;
    private int pageHeight = 0;
    private int portraitRotation = 0;
    private int landscapeRotation = 270;
    private Map pages = null;
    private boolean colorImages = false;
    private int bitsPerPixel = 8;
    private int resolution = 240;
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_CCITTFAX, ImageFlavor.GRAPHICS2D, ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE, ImageFlavor.XML_DOM};
    private List viewPortPositions = new ArrayList();

    public void setupFontInfo(FontInfo inFontInfo) {
        OutlineFont bf;
        FopCharacterSet cs;
        this.fontInfo = inFontInfo;
        int num = 1;
        if (this.fontList != null && this.fontList.size() > 0) {
            Iterator it = this.fontList.iterator();
            while (it.hasNext()) {
                AFPFontInfo afi = (AFPFontInfo)it.next();
                AFPFont bf2 = afi.getAFPFont();
                Iterator it2 = afi.getFontTriplets().iterator();
                while (it2.hasNext()) {
                    FontTriplet ft = (FontTriplet)it2.next();
                    this.fontInfo.addFontProperties("F" + num, ft.getName(), ft.getStyle(), ft.getWeight());
                    this.fontInfo.addMetrics("F" + num, bf2);
                    ++num;
                }
            }
        } else {
            log.warn("No AFP fonts configured - using default setup");
        }
        if (this.fontInfo.fontLookup("sans-serif", "normal", 400) == null) {
            cs = new FopCharacterSet("T1V10500", "Cp500", "CZH200  ", 1, new Helvetica());
            bf = new OutlineFont("Helvetica", cs);
            this.fontInfo.addFontProperties("F" + num, "sans-serif", "normal", 400);
            this.fontInfo.addMetrics("F" + num, bf);
            ++num;
        }
        if (this.fontInfo.fontLookup("serif", "normal", 400) == null) {
            cs = new FopCharacterSet("T1V10500", "Cp500", "CZN200  ", 1, new TimesRoman());
            bf = new OutlineFont("Helvetica", cs);
            this.fontInfo.addFontProperties("F" + num, "serif", "normal", 400);
            this.fontInfo.addMetrics("F" + num, bf);
            ++num;
        }
        if (this.fontInfo.fontLookup("monospace", "normal", 400) == null) {
            cs = new FopCharacterSet("T1V10500", "Cp500", "CZ4200  ", 1, new Courier());
            bf = new OutlineFont("Helvetica", cs);
            this.fontInfo.addFontProperties("F" + num, "monospace", "normal", 400);
            this.fontInfo.addMetrics("F" + num, bf);
            ++num;
        }
        if (this.fontInfo.fontLookup("any", "normal", 400) == null) {
            FontTriplet ft = this.fontInfo.fontLookup("sans-serif", "normal", 400);
            this.fontInfo.addFontProperties(this.fontInfo.getInternalFontKey(ft), "any", "normal", 400);
        }
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.currentPageFonts = new HashMap();
        this.currentColor = new Color(255, 255, 255);
        this.afpDataStream = new AFPDataStream();
        this.afpDataStream.setPortraitRotation(this.portraitRotation);
        this.afpDataStream.setLandscapeRotation(this.landscapeRotation);
        this.afpDataStream.startDocument(outputStream);
    }

    public void stopRenderer() throws IOException {
        this.afpDataStream.endDocument();
    }

    public boolean supportsOutOfOrder() {
        return true;
    }

    public void preparePage(PageViewport page) {
        this.currentFontSize = 0;
        this.pageFontCounter = 0;
        this.currentPageFonts.clear();
        Rectangle2D bounds = page.getViewArea();
        this.pageWidth = this.mpts2units(bounds.getWidth());
        this.pageHeight = this.mpts2units(bounds.getHeight());
        boolean pageRotation = false;
        this.afpDataStream.startPage(this.pageWidth, this.pageHeight, 0, this.getResolution(), this.getResolution());
        this.renderPageObjectExtensions(page);
        if (this.pages == null) {
            this.pages = new HashMap();
        }
        this.pages.put(page, this.afpDataStream.savePage());
    }

    public void processOffDocumentItem(OffDocumentItem odi) {
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new AFPGraphics2DAdapter();
    }

    public void startVParea(CTM ctm, Rectangle2D clippingRect) {
    }

    public void endVParea() {
    }

    public void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            Rectangle2D view = port.getViewArea();
            this.currentBPPosition = 0;
            this.currentIPPosition = 0;
            RegionReference regionReference = port.getRegionReference();
            this.handleRegionTraits(port);
            this.pushViewPortPos(new ViewPortPos(view, regionReference.getCTM()));
            if (regionReference.getRegionClass() == 36) {
                this.renderBodyRegion((BodyRegion)regionReference);
            } else {
                this.renderRegion(regionReference);
            }
            this.popViewPortPos();
        }
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        CTM ctm = bv.getCTM();
        int borderPaddingStart = bv.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = bv.getBorderAndPaddingWidthBefore();
        float width = (float)bv.getIPD() / 1000.0f;
        float height = (float)bv.getBPD() / 1000.0f;
        if (bv.getPositioning() == 2 || bv.getPositioning() == 3) {
            List breakOutList = null;
            if (bv.getPositioning() == 3) {
                breakOutList = this.breakOutOfStateStack();
            }
            AffineTransform positionTransform = new AffineTransform();
            positionTransform.translate(bv.getXOffset(), bv.getYOffset());
            positionTransform.translate(-borderPaddingStart, -borderPaddingBefore);
            float bpwidth = (float)(borderPaddingStart + bv.getBorderAndPaddingWidthEnd()) / 1000.0f;
            float bpheight = (float)(borderPaddingBefore + bv.getBorderAndPaddingWidthAfter()) / 1000.0f;
            Point ptSrc = new Point(0, 0);
            Point2D ptDst = positionTransform.transform(ptSrc, null);
            Rectangle2D.Double borderRect = new Rectangle2D.Double(ptDst.getX(), ptDst.getY(), 1000.0f * (width + bpwidth), 1000.0f * (height + bpheight));
            this.pushViewPortPos(new ViewPortPos(borderRect, new CTM(positionTransform)));
            this.drawBackAndBorders(bv, 0.0f, 0.0f, width + bpwidth, height + bpheight);
            AffineTransform contentRectTransform = new AffineTransform();
            contentRectTransform.translate(borderPaddingStart, borderPaddingBefore);
            ptSrc = new Point(0, 0);
            ptDst = contentRectTransform.transform(ptSrc, null);
            Rectangle2D.Double contentRect = new Rectangle2D.Double(ptDst.getX(), ptDst.getY(), 1000.0f * width, 1000.0f * height);
            this.pushViewPortPos(new ViewPortPos(contentRect, new CTM(contentRectTransform)));
            AffineTransform contentTransform = ctm.toAffineTransform();
            contentRect = new Rectangle2D.Double(0.0, 0.0, 1000.0f * width, 1000.0f * height);
            this.pushViewPortPos(new ViewPortPos(contentRect, new CTM(contentTransform)));
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.popViewPortPos();
            this.popViewPortPos();
            this.popViewPortPos();
            if (breakOutList != null) {
                this.restoreStateStackAfterBreakOut(breakOutList);
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            this.currentBPPosition += bv.getSpaceBefore();
            this.handleBlockTraits(bv);
            this.currentIPPosition += bv.getStartIndent();
            CTM tempctm = new CTM(this.containingIPPosition, this.currentBPPosition);
            ctm = tempctm.multiply(ctm);
            this.currentBPPosition += borderPaddingBefore;
            Rectangle clippingRect = null;
            clippingRect = new Rectangle(this.currentIPPosition, this.currentBPPosition, bv.getIPD(), bv.getBPD());
            this.pushViewPortPos(new ViewPortPos(clippingRect, ctm));
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.popViewPortPos();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getAllocBPD();
        }
    }

    protected void renderReferenceArea(Block block) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        AffineTransform at = new AffineTransform();
        at.translate(this.currentIPPosition, this.currentBPPosition);
        at.translate(block.getXOffset(), block.getYOffset());
        at.translate(0.0, block.getSpaceBefore());
        if (!at.isIdentity()) {
            Rectangle2D.Double contentRect = new Rectangle2D.Double(at.getTranslateX(), at.getTranslateY(), block.getAllocIPD(), block.getAllocBPD());
            this.pushViewPortPos(new ViewPortPos(contentRect, new CTM(at)));
        }
        this.currentIPPosition = 0;
        this.currentBPPosition = 0;
        this.handleBlockTraits(block);
        List children = block.getChildAreas();
        if (children != null) {
            this.renderBlocks(block, children);
        }
        if (!at.isIdentity()) {
            this.popViewPortPos();
        }
        this.currentIPPosition = saveIP;
        this.currentBPPosition = saveBP;
    }

    protected void renderFlow(NormalFlow flow) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        AffineTransform at = new AffineTransform();
        at.translate(this.currentIPPosition, this.currentBPPosition);
        if (!at.isIdentity()) {
            Rectangle2D.Double contentRect = new Rectangle2D.Double(at.getTranslateX(), at.getTranslateY(), flow.getAllocIPD(), flow.getAllocBPD());
            this.pushViewPortPos(new ViewPortPos(contentRect, new CTM(at)));
        }
        this.currentIPPosition = 0;
        this.currentBPPosition = 0;
        super.renderFlow(flow);
        if (!at.isIdentity()) {
            this.popViewPortPos();
        }
        this.currentIPPosition = saveIP;
        this.currentBPPosition = saveBP;
    }

    protected void concatenateTransformationMatrix(AffineTransform at) {
        throw new UnsupportedOperationException("NYI");
    }

    public void renderPage(PageViewport pageViewport) {
        this.currentFontSize = 0;
        this.pageFontCounter = 0;
        this.currentPageFonts.clear();
        Rectangle2D bounds = pageViewport.getViewArea();
        this.pageWidth = this.mpts2units(bounds.getWidth());
        this.pageHeight = this.mpts2units(bounds.getHeight());
        if (this.pages != null && this.pages.containsKey(pageViewport)) {
            this.afpDataStream.restorePage((PageObject)this.pages.remove(pageViewport));
        } else {
            boolean pageRotation = false;
            this.afpDataStream.startPage(this.pageWidth, this.pageHeight, 0, this.getResolution(), this.getResolution());
            this.renderPageObjectExtensions(pageViewport);
        }
        this.pushViewPortPos(new ViewPortPos());
        this.renderPageAreas(pageViewport.getPage());
        Iterator i = this.currentPageFonts.values().iterator();
        while (i.hasNext()) {
            AFPFontAttributes afpFontAttributes = (AFPFontAttributes)i.next();
            this.afpDataStream.createFont((byte)afpFontAttributes.getFontReference(), afpFontAttributes.getFont(), afpFontAttributes.getPointSize());
        }
        try {
            this.afpDataStream.endPage();
        }
        catch (IOException ioex) {
            // empty catch block
        }
        this.popViewPortPos();
    }

    public void clip() {
    }

    public void clipRect(float x, float y, float width, float height) {
    }

    public void moveTo(float x, float y) {
    }

    public void lineTo(float x, float y) {
    }

    public void closePath() {
    }

    public void fillRect(float x, float y, float width, float height) {
        this.afpDataStream.createLine(this.pts2units(x), this.pts2units(y), this.pts2units(x + width), this.pts2units(y), this.pts2units(height), this.currentColor);
    }

    public void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            log.error("Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 37: {
                if (horz) {
                    float h3 = h / 3.0f;
                    float ym1 = y1;
                    float ym2 = ym1 + h3 + h3;
                    this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym1), this.pts2units(x2), this.pts2units(ym1), this.pts2units(h3), col);
                    this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym2), this.pts2units(x2), this.pts2units(ym2), this.pts2units(h3), col);
                    break;
                }
                float w3 = w / 3.0f;
                float xm1 = x1;
                float xm2 = xm1 + w3 + w3;
                this.afpDataStream.createLine(this.pts2units(xm1), this.pts2units(y1), this.pts2units(xm1), this.pts2units(y2), this.pts2units(w3), col);
                this.afpDataStream.createLine(this.pts2units(xm2), this.pts2units(y1), this.pts2units(xm2), this.pts2units(y2), this.pts2units(w3), col);
                break;
            }
            case 31: {
                if (horz) {
                    float w2 = 2.0f * h;
                    while (x1 + w2 < x2) {
                        this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(x1 + w2), this.pts2units(y1), this.pts2units(h), col);
                        x1 += 2.0f * w2;
                    }
                } else {
                    float h2 = 2.0f * w;
                    while (y1 + h2 < y2) {
                        this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(x1), this.pts2units(y1 + h2), this.pts2units(w), col);
                        y1 += 2.0f * h2;
                    }
                }
                break;
            }
            case 36: {
                if (horz) {
                    while (x1 + h < x2) {
                        this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(x1 + h), this.pts2units(y1), this.pts2units(h), col);
                        x1 += 2.0f * h;
                    }
                } else {
                    while (y1 + w < y2) {
                        this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(x1), this.pts2units(y1 + w), this.pts2units(w), col);
                        y1 += 2.0f * w;
                    }
                }
                break;
            }
            case 55: 
            case 119: {
                float colFactor;
                float f = colFactor = style == 55 ? 0.4f : -0.4f;
                if (horz) {
                    Color uppercol = AFPRenderer.lightenColor(col, -colFactor);
                    Color lowercol = AFPRenderer.lightenColor(col, colFactor);
                    float h3 = h / 3.0f;
                    float ym1 = y1;
                    this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym1), this.pts2units(x2), this.pts2units(ym1), this.pts2units(h3), uppercol);
                    this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym1 + h3), this.pts2units(x2), this.pts2units(ym1 + h3), this.pts2units(h3), col);
                    this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(ym1 + h3 + h3), this.pts2units(x2), this.pts2units(ym1 + h3 + h3), this.pts2units(h3), lowercol);
                    break;
                }
                Color leftcol = AFPRenderer.lightenColor(col, -colFactor);
                Color rightcol = AFPRenderer.lightenColor(col, colFactor);
                float w3 = w / 3.0f;
                float xm1 = x1 + w3 / 2.0f;
                this.afpDataStream.createLine(this.pts2units(xm1), this.pts2units(y1), this.pts2units(xm1), this.pts2units(y2), this.pts2units(w3), leftcol);
                this.afpDataStream.createLine(this.pts2units(xm1 + w3), this.pts2units(y1), this.pts2units(xm1 + w3), this.pts2units(y2), this.pts2units(w3), col);
                this.afpDataStream.createLine(this.pts2units(xm1 + w3 + w3), this.pts2units(y1), this.pts2units(xm1 + w3 + w3), this.pts2units(y2), this.pts2units(w3), rightcol);
                break;
            }
            case 57: {
                break;
            }
            default: {
                this.afpDataStream.createLine(this.pts2units(x1), this.pts2units(y1), this.pts2units(horz ? x2 : x1), this.pts2units(horz ? y1 : y2), this.pts2units(Math.abs(horz ? y2 - y1 : x2 - x1)), col);
            }
        }
    }

    protected RendererContext createRendererContext(int x, int y, int width, int height, Map foreignAttributes) {
        RendererContext context = super.createRendererContext(x, y, width, height, foreignAttributes);
        context.setProperty("afpGrayscale", new Boolean(!this.colorImages));
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(String uri, Rectangle2D pos, Map foreignAttributes) {
        block19: {
            uri = URISpecification.getURL(uri);
            Rectangle posInt = new Rectangle((int)pos.getX(), (int)pos.getY(), (int)pos.getWidth(), (int)pos.getHeight());
            Point origin = new Point(this.currentIPPosition, this.currentBPPosition);
            int x = origin.x + posInt.x;
            int y = origin.y + posInt.y;
            String name = null;
            if (this.pageSegmentsMap != null) {
                name = (String)this.pageSegmentsMap.get(uri);
            }
            if (name != null) {
                this.afpDataStream.createIncludePageSegment(name, this.mpts2units(x), this.mpts2units(y));
            } else {
                ImageManager manager = this.getUserAgent().getFactory().getImageManager();
                ImageInfo info = null;
                try {
                    ImageSessionContext sessionContext = this.getUserAgent().getImageSessionContext();
                    info = manager.getImageInfo(uri, sessionContext);
                    Map hints = ImageUtil.getDefaultHints(sessionContext);
                    org.apache.xmlgraphics.image.loader.Image img = manager.getImage(info, FLAVORS, hints, sessionContext);
                    if (img instanceof ImageGraphics2D) {
                        ImageGraphics2D imageG2D = (ImageGraphics2D)img;
                        RendererContext context = this.createRendererContext(posInt.x, posInt.y, posInt.width, posInt.height, foreignAttributes);
                        this.getGraphics2DAdapter().paintImage(imageG2D.getGraphics2DImagePainter(), context, origin.x + posInt.x, origin.y + posInt.y, posInt.width, posInt.height);
                        break block19;
                    }
                    if (img instanceof ImageRendered) {
                        ImageRendered imgRend = (ImageRendered)img;
                        RenderedImage ri = imgRend.getRenderedImage();
                        this.drawBufferedImage(ri, this.getResolution(), posInt.x + this.currentIPPosition, posInt.y + this.currentBPPosition, posInt.width, posInt.height);
                        break block19;
                    }
                    if (img instanceof ImageRawCCITTFax) {
                        ImageRawCCITTFax ccitt = (ImageRawCCITTFax)img;
                        int afpx = this.mpts2units(posInt.x + this.currentIPPosition);
                        int afpy = this.mpts2units(posInt.y + this.currentBPPosition);
                        int afpw = this.mpts2units(posInt.getWidth());
                        int afph = this.mpts2units(posInt.getHeight());
                        int afpres = this.getResolution();
                        ImageObject io = this.afpDataStream.getImageObject(afpx, afpy, afpw, afph, afpres, afpres);
                        io.setImageParameters((int)(ccitt.getSize().getDpiHorizontal() * 10.0), (int)(ccitt.getSize().getDpiVertical() * 10.0), ccitt.getSize().getWidthPx(), ccitt.getSize().getHeightPx());
                        int compression = ccitt.getCompression();
                        switch (compression) {
                            case 2: {
                                io.setImageEncoding((byte)-128);
                                break;
                            }
                            case 3: {
                                io.setImageEncoding((byte)-127);
                                break;
                            }
                            case 4: {
                                io.setImageEncoding((byte)-126);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Invalid compression scheme: " + compression);
                            }
                        }
                        InputStream in = ccitt.createInputStream();
                        try {
                            byte[] buf = IOUtils.toByteArray(in);
                            io.setImageData(buf);
                            break block19;
                        }
                        finally {
                            IOUtils.closeQuietly(in);
                        }
                    }
                    if (img instanceof ImageXMLDOM) {
                        ImageXMLDOM imgXML = (ImageXMLDOM)img;
                        this.renderDocument(imgXML.getDocument(), imgXML.getRootNamespace(), pos, foreignAttributes);
                        break block19;
                    }
                    throw new UnsupportedOperationException("Unsupported image type: " + img);
                }
                catch (ImageException ie) {
                    log.error("Error while processing image: " + (info != null ? info.toString() : uri), ie);
                }
                catch (FileNotFoundException fe) {
                    log.error(fe.getMessage());
                }
                catch (IOException ioe) {
                    log.error("I/O error while processing image: " + (info != null ? info.toString() : uri), ioe);
                }
            }
        }
    }

    public static void writeImage(RenderedImage image, OutputStream out) throws IOException {
        ImageEncodingHelper.encodeRenderedImageAsRGB(image, out);
    }

    public void drawBufferedImage(RenderedImage image, int imageResolution, int x, int y, int w, int h) {
        int afpx = this.mpts2units(x);
        int afpy = this.mpts2units(y);
        int afpw = this.mpts2units(w);
        int afph = this.mpts2units(h);
        int afpres = this.getResolution();
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        try {
            AFPRenderer.writeImage(image, baout);
            byte[] buf = baout.toByteArray();
            ImageObject io = this.afpDataStream.getImageObject(afpx, afpy, afpw, afph, afpres, afpres);
            io.setImageParameters(imageResolution, imageResolution, image.getWidth(), image.getHeight());
            if (this.colorImages) {
                io.setImageIDESize((byte)24);
                io.setImageData(buf);
            } else {
                AFPRenderer.convertToGrayScaleImage(io, buf, image.getWidth(), image.getHeight(), this.bitsPerPixel);
            }
        }
        catch (IOException ioe) {
            log.error("Error while serializing bitmap: " + ioe.getMessage(), ioe);
        }
    }

    public void updateColor(Color col, boolean fill) {
        if (fill) {
            this.currentColor = col;
        }
    }

    public List breakOutOfStateStack() {
        log.debug("Block.FIXED --> break out");
        ArrayList<ViewPortPos> breakOutList = new ArrayList<ViewPortPos>();
        while (this.viewPortPositions.size() > 1) {
            breakOutList.add(0, this.popViewPortPos());
        }
        return breakOutList;
    }

    public void restoreStateStackAfterBreakOut(List breakOutList) {
        log.debug("Block.FIXED --> restoring context after break-out");
        int c = breakOutList.size();
        for (int i = 0; i < c; ++i) {
            ViewPortPos vps = (ViewPortPos)breakOutList.get(i);
            this.pushViewPortPos(vps);
        }
    }

    public void saveGraphicsState() {
    }

    public void restoreGraphicsState() {
    }

    public void beginTextObject() {
    }

    public void endTextObject() {
    }

    public void renderImage(Image image, Rectangle2D pos) {
        String url = image.getURL();
        this.drawImage(url, pos);
    }

    public void renderText(TextArea text) {
        this.renderInlineAreaBackAndBorders(text);
        String name = this.getInternalFontNameForArea(text);
        this.currentFontSize = (Integer)text.getTrait(Trait.FONT_SIZE);
        AFPFont tf = (AFPFont)this.fontInfo.getFonts().get(name);
        Color col = (Color)text.getTrait(Trait.COLOR);
        int vsci = this.mpts2units(tf.getWidth(32, this.currentFontSize) / 1000 + text.getTextWordSpaceAdjust() + text.getTextLetterSpaceAdjust());
        int rx = this.currentIPPosition + text.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + text.getOffset() + text.getBaselineOffset();
        String worddata = text.getText();
        AFPFontAttributes afpFontAttributes = new AFPFontAttributes(name, tf, this.currentFontSize);
        if (!this.currentPageFonts.containsKey(afpFontAttributes.getFontKey())) {
            ++this.pageFontCounter;
            afpFontAttributes.setFontReference(this.pageFontCounter);
            this.currentPageFonts.put(afpFontAttributes.getFontKey(), afpFontAttributes);
        } else {
            afpFontAttributes = (AFPFontAttributes)this.currentPageFonts.get(afpFontAttributes.getFontKey());
        }
        String encoding = null;
        try {
            encoding = tf.getCharacterSet(this.currentFontSize).getEncoding();
        }
        catch (Throwable ex) {
            encoding = "Cp1146";
            log.warn("renderText():: Error getting encoding for font  - using default encoding " + encoding);
        }
        try {
            this.afpDataStream.createText(afpFontAttributes.getFontReference(), this.mpts2units(rx), this.mpts2units(bl), col, vsci, this.mpts2units(text.getTextLetterSpaceAdjust()), worddata.getBytes(encoding));
        }
        catch (UnsupportedEncodingException usee) {
            log.error("renderText:: Font " + afpFontAttributes.getFontKey() + " caused UnsupportedEncodingException");
        }
        super.renderText(text);
        this.renderTextDecoration(tf, this.currentFontSize, text, bl, rx);
    }

    public void renderWord(WordArea word) {
        super.renderWord(word);
    }

    public void renderSpace(SpaceArea space) {
        super.renderSpace(space);
    }

    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders(area);
        int style = area.getRuleStyle();
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        float ruleThickness = (float)area.getRuleThickness() / 1000.0f;
        Color col = (Color)area.getTrait(Trait.COLOR);
        switch (style) {
            case 31: 
            case 36: 
            case 37: 
            case 55: 
            case 119: 
            case 133: {
                this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        super.renderLeader(area);
    }

    public void setPortraitRotation(int rotation) {
        if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
            throw new IllegalArgumentException("The portrait rotation must be one of the values 0, 90, 180, 270");
        }
        this.portraitRotation = rotation;
    }

    public void setLandscapeRotation(int rotation) {
        if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
            throw new IllegalArgumentException("The landscape rotation must be one of the values 0, 90, 180, 270");
        }
        this.landscapeRotation = rotation;
    }

    public String getMimeType() {
        return "application/x-afp";
    }

    private void renderPageObjectExtensions(PageViewport pageViewport) {
        this.pageSegmentsMap = null;
        if (pageViewport.getExtensionAttachments() != null && pageViewport.getExtensionAttachments().size() > 0) {
            Iterator i = pageViewport.getExtensionAttachments().iterator();
            while (i.hasNext()) {
                String content;
                String name;
                ExtensionAttachment attachment = (ExtensionAttachment)i.next();
                if (!"apache:fop:extensions:afp".equals(attachment.getCategory())) continue;
                AFPPageSetup aps = (AFPPageSetup)attachment;
                String element = aps.getElementName();
                if ("include-page-overlay".equals(element)) {
                    String overlay = aps.getName();
                    if (overlay == null) continue;
                    this.afpDataStream.createIncludePageOverlay(overlay);
                    continue;
                }
                if ("include-page-segment".equals(element)) {
                    name = aps.getName();
                    String source = aps.getValue();
                    if (this.pageSegmentsMap == null) {
                        this.pageSegmentsMap = new HashMap();
                    }
                    this.pageSegmentsMap.put(source, name);
                    continue;
                }
                if ("tag-logical-element".equals(element)) {
                    name = aps.getName();
                    String value = aps.getValue();
                    if (this.pageSegmentsMap == null) {
                        this.pageSegmentsMap = new HashMap();
                    }
                    this.afpDataStream.createTagLogicalElement(name, value);
                    continue;
                }
                if (!"no-operation".equals(element) || (content = aps.getContent()) == null) continue;
                this.afpDataStream.createNoOperation(content);
            }
        }
    }

    private int mpts2units(int mpt) {
        return this.mpts2units((double)mpt);
    }

    private int pts2units(float mpt) {
        return this.mpts2units((double)mpt * 1000.0);
    }

    private int mpts2units(double mpt) {
        return (int)Math.round(mpt / (double)(72000 / this.getResolution()));
    }

    protected static void convertToGrayScaleImage(ImageObject io, byte[] raw, int width, int height, int bitsPerPixel) {
        int pixelsPerByte = 8 / bitsPerPixel;
        int bytewidth = width / pixelsPerByte;
        if (width % pixelsPerByte != 0) {
            ++bytewidth;
        }
        byte[] bw = new byte[height * bytewidth];
        for (int y = 0; y < height; ++y) {
            byte ib = 0;
            int i = 3 * y * width;
            int x = 0;
            while (x < width) {
                double greyVal = 0.212671 * (double)(raw[i] & 0xFF) + 0.71516 * (double)(raw[i + 1] & 0xFF) + 0.072169 * (double)(raw[i + 2] & 0xFF);
                switch (bitsPerPixel) {
                    case 1: {
                        if (!(greyVal < 128.0)) break;
                        ib = (byte)(ib | (byte)(1 << 7 - x % 8));
                        break;
                    }
                    case 4: {
                        ib = (byte)(ib | (byte)((byte)(greyVal /= 16.0) << (1 - x % 2) * 4));
                        break;
                    }
                    case 8: {
                        ib = (byte)greyVal;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported bits per pixel: " + bitsPerPixel);
                    }
                }
                if (x % pixelsPerByte == pixelsPerByte - 1 || x + 1 == width) {
                    bw[y * bytewidth + x / pixelsPerByte] = ib;
                    ib = 0;
                }
                ++x;
                i += 3;
            }
        }
        io.setImageIDESize((byte)bitsPerPixel);
        io.setImageData(bw);
    }

    private void pushViewPortPos(ViewPortPos vpp) {
        this.viewPortPositions.add(vpp);
        this.afpDataStream.setOffsets(vpp.x, vpp.y, vpp.rot);
    }

    private ViewPortPos popViewPortPos() {
        ViewPortPos current = (ViewPortPos)this.viewPortPositions.remove(this.viewPortPositions.size() - 1);
        if (this.viewPortPositions.size() > 0) {
            ViewPortPos vpp = (ViewPortPos)this.viewPortPositions.get(this.viewPortPositions.size() - 1);
            this.afpDataStream.setOffsets(vpp.x, vpp.y, vpp.rot);
        }
        return current;
    }

    public void setBitsPerPixel(int bitsPerPixel) {
        this.bitsPerPixel = bitsPerPixel;
        switch (bitsPerPixel) {
            case 1: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                log.warn("Invalid bits_per_pixel value, must be 1, 4 or 8.");
                bitsPerPixel = 8;
            }
        }
    }

    public void setColorImages(boolean colorImages) {
        this.colorImages = colorImages;
    }

    public void setResolution(int resolution) {
        if (log.isDebugEnabled()) {
            log.debug("renderer-resolution set to: " + resolution + "dpi");
        }
        this.resolution = resolution;
    }

    public int getResolution() {
        return this.resolution;
    }

    private final class ViewPortPos {
        private int x = 0;
        private int y = 0;
        private int rot = 0;

        private ViewPortPos() {
        }

        private ViewPortPos(Rectangle2D view, CTM ctm) {
            int yOrigin;
            int xOrigin;
            int height;
            int width;
            ViewPortPos currentVP = (ViewPortPos)AFPRenderer.this.viewPortPositions.get(AFPRenderer.this.viewPortPositions.size() - 1);
            switch (currentVP.rot) {
                case 90: {
                    width = AFPRenderer.this.mpts2units(view.getHeight());
                    height = AFPRenderer.this.mpts2units(view.getWidth());
                    xOrigin = AFPRenderer.this.pageWidth - width - AFPRenderer.this.mpts2units(view.getY()) - currentVP.y;
                    yOrigin = AFPRenderer.this.mpts2units(view.getX()) + currentVP.x;
                    break;
                }
                case 180: {
                    width = AFPRenderer.this.mpts2units(view.getWidth());
                    height = AFPRenderer.this.mpts2units(view.getHeight());
                    xOrigin = AFPRenderer.this.pageWidth - width - AFPRenderer.this.mpts2units(view.getX()) - currentVP.x;
                    yOrigin = AFPRenderer.this.pageHeight - height - AFPRenderer.this.mpts2units(view.getY()) - currentVP.y;
                    break;
                }
                case 270: {
                    width = AFPRenderer.this.mpts2units(view.getHeight());
                    height = AFPRenderer.this.mpts2units(view.getWidth());
                    xOrigin = AFPRenderer.this.mpts2units(view.getY()) + currentVP.y;
                    yOrigin = AFPRenderer.this.pageHeight - height - AFPRenderer.this.mpts2units(view.getX()) - currentVP.x;
                    break;
                }
                default: {
                    xOrigin = AFPRenderer.this.mpts2units(view.getX()) + currentVP.x;
                    yOrigin = AFPRenderer.this.mpts2units(view.getY()) + currentVP.y;
                    width = AFPRenderer.this.mpts2units(view.getWidth());
                    height = AFPRenderer.this.mpts2units(view.getHeight());
                }
            }
            this.rot = currentVP.rot;
            double[] ctmf = ctm.toArray();
            if (ctmf[0] == 0.0 && ctmf[1] == -1.0 && ctmf[2] == 1.0 && ctmf[3] == 0.0) {
                this.rot += 270;
            } else if (ctmf[0] == -1.0 && ctmf[1] == 0.0 && ctmf[2] == 0.0 && ctmf[3] == -1.0) {
                this.rot += 180;
            } else if (ctmf[0] == 0.0 && ctmf[1] == 1.0 && ctmf[2] == -1.0 && ctmf[3] == 0.0) {
                this.rot += 90;
            }
            this.rot %= 360;
            switch (this.rot) {
                case 0: {
                    this.x = xOrigin;
                    this.y = yOrigin;
                    break;
                }
                case 90: {
                    this.x = yOrigin;
                    this.y = AFPRenderer.this.pageWidth - width - xOrigin;
                    break;
                }
                case 180: {
                    this.x = AFPRenderer.this.pageWidth - width - xOrigin;
                    this.y = AFPRenderer.this.pageHeight - height - yOrigin;
                    break;
                }
                case 270: {
                    this.x = AFPRenderer.this.pageHeight - height - yOrigin;
                    this.y = xOrigin;
                    break;
                }
            }
        }

        public String toString() {
            return "x:" + this.x + " y:" + this.y + " rot:" + this.rot;
        }
    }
}

