/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.supervisor;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.appserver.supervisor.SupervisedDirectory;
import org.codehaus.plexus.appserver.supervisor.Supervisor;
import org.codehaus.plexus.appserver.supervisor.SupervisorException;
import org.codehaus.plexus.appserver.supervisor.SupervisorListener;

public class DefaultSupervisor
implements Supervisor {
    private List directories = new ArrayList();
    private String name;
    private String extension;

    public void addDirectory(File directory, SupervisorListener listener) throws SupervisorException {
        if (!directory.isDirectory()) {
            throw new SupervisorException("The specified directory doesn't exists or isn't a directory: '" + directory.getAbsolutePath() + "'.");
        }
        this.directories.add(new SupervisedDirectory(directory, listener));
    }

    public void scan() throws SupervisorException {
        Iterator it = this.directories.iterator();
        while (it.hasNext()) {
            SupervisedDirectory directory = (SupervisedDirectory)it.next();
            File dir = directory.getDirectory();
            SupervisorListener listener = directory.getListener();
            this.scanDirectory(dir, listener);
        }
    }

    public String getName() {
        return this.name;
    }

    private void scanDirectory(File dir, SupervisorListener listener) {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(DefaultSupervisor.this.extension);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            listener.onJarDiscovered(file);
        }
    }
}

