/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.service.deploy;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.appserver.ApplicationServerException;
import org.codehaus.plexus.appserver.deploy.AbstractDeployer;
import org.codehaus.plexus.appserver.service.deploy.ServiceDeployer;
import org.codehaus.plexus.appserver.service.deploy.lifecycle.ServiceDeploymentContext;
import org.codehaus.plexus.appserver.service.deploy.lifecycle.ServiceDeploymentException;
import org.codehaus.plexus.appserver.service.deploy.lifecycle.phase.ServiceDeploymentPhase;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class DefaultServiceDeployer
extends AbstractDeployer
implements ServiceDeployer,
Initializable,
Contextualizable {
    private File servicesDirectory;
    private DefaultPlexusContainer container;
    private List phases;

    public void deploy(String serviceId, File location) throws ApplicationServerException {
        this.deploy(serviceId, location, true);
    }

    private void deploy(String id, File sar, boolean expandSar) throws ApplicationServerException {
        ServiceDeploymentContext context = new ServiceDeploymentContext(id, sar, this.servicesDirectory, this.container);
        Iterator i = this.phases.iterator();
        while (i.hasNext()) {
            String phaseId = (String)i.next();
            try {
                ServiceDeploymentPhase phase = (ServiceDeploymentPhase)this.container.lookup(ServiceDeploymentPhase.ROLE, phaseId);
                phase.execute(context);
            }
            catch (ComponentLookupException e) {
                throw new ApplicationServerException("The requested app server lifecycle phase cannot be found: " + phaseId, e);
            }
            catch (ServiceDeploymentException e) {
                throw new ApplicationServerException("Error executing service deployment id.", e);
            }
        }
    }

    public void redeploy(String id) throws ApplicationServerException {
    }

    public void undeploy(String id) throws ApplicationServerException {
    }

    public boolean isDeployed(String id) {
        return true;
    }

    public void initialize() throws InitializationException {
        this.getLogger().info("Services will be deployed in: '" + this.servicesDirectory + "'.");
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (DefaultPlexusContainer)context.get((Object)"plexus");
    }
}

