/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.management;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.codehaus.plexus.appserver.management.Agent;
import org.codehaus.plexus.appserver.management.MBean;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.FileUtils;
import org.livetribe.slp.Attributes;
import org.livetribe.slp.Scopes;
import org.livetribe.slp.ServiceInfo;
import org.livetribe.slp.ServiceURL;
import org.livetribe.slp.api.sa.StandardServiceAgent;

public class DefaultAgent
extends AbstractLogEnabled
implements Agent,
Initializable,
Contextualizable {
    private List mbeans;
    private String serviceUrl;
    private int slpPort;
    private MBeanServer mbeanServer;
    private JMXServiceURL jmxServiceURL;
    private String tempDirectory;

    public void initialize() throws InitializationException {
        try {
            this.mbeanServer = MBeanServerFactory.createMBeanServer();
            if (this.mbeans != null) {
                Iterator i = this.mbeans.iterator();
                while (i.hasNext()) {
                    MBean mbean = (MBean)i.next();
                    this.mbeanServer.registerMBean(mbean, new ObjectName(mbean.getDomain() + ":name=" + mbean.getName()));
                }
            }
            this.jmxServiceURL = new JMXServiceURL(this.serviceUrl);
            JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.jmxServiceURL, null, this.mbeanServer);
            connectorServer.start();
            this.jmxServiceURL = connectorServer.getAddress();
            ServiceURL serviceURL = new ServiceURL(this.jmxServiceURL.toString());
            Scopes scopes = Scopes.DEFAULT;
            Attributes attributes = null;
            String language = Locale.ENGLISH.getLanguage();
            ServiceInfo serviceInfo = new ServiceInfo(serviceURL, scopes, attributes, language);
            StandardServiceAgent serviceAgent = new StandardServiceAgent();
            serviceAgent.setPort(this.slpPort);
            serviceAgent.register(serviceInfo);
            serviceAgent.start();
            File serviceFile = new File(this.tempDirectory, "agent.properties");
            Properties props = new Properties();
            props.put("jmxServiceUrl", this.jmxServiceURL.toString());
            props.put("slpPort", String.valueOf(this.slpPort));
            props.store(new FileOutputStream(serviceFile), null);
            FileUtils.forceDeleteOnExit((File)serviceFile);
            this.getLogger().info("JMX manager agent is up and running (" + this.jmxServiceURL + ").");
            this.getLogger().info("JMX agent is registered in SLP service on port " + this.slpPort);
        }
        catch (Exception e) {
            throw new InitializationException("Can't load JMX agent.", (Throwable)e);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.tempDirectory = (String)context.get((Object)"plexus.temp");
    }
}

