/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.lifecycle.phase;

import java.io.File;
import org.codehaus.plexus.appserver.ApplicationServer;
import org.codehaus.plexus.appserver.ApplicationServerException;
import org.codehaus.plexus.appserver.lifecycle.AppServerLifecycleException;
import org.codehaus.plexus.appserver.lifecycle.phase.AbstractAppServerPhase;
import org.codehaus.plexus.appserver.service.deploy.ServiceDeployer;
import org.codehaus.plexus.appserver.supervisor.Supervisor;
import org.codehaus.plexus.appserver.supervisor.SupervisorException;
import org.codehaus.plexus.appserver.supervisor.SupervisorListener;

public class ServiceDeploymentPhase
extends AbstractAppServerPhase {
    private ServiceDeployer serviceDeployer;
    private Supervisor serviceSupervisor;

    public void execute(ApplicationServer appServer) throws AppServerLifecycleException {
        try {
            File servicesDirectory = new File(appServer.getAppServerHome(), "services");
            if (servicesDirectory.exists() && servicesDirectory.isDirectory()) {
                this.serviceSupervisor.addDirectory(servicesDirectory, new SupervisorListener(){

                    public void onJarDiscovered(File jar) {
                        String name = jar.getName();
                        try {
                            String serviceName = name.substring(0, name.length() - 4);
                            ServiceDeploymentPhase.this.getLogger().info(ServiceDeploymentPhase.this.serviceSupervisor.getName() + " is deploying " + serviceName + ".");
                            ServiceDeploymentPhase.this.serviceDeployer.deploy(serviceName, jar);
                        }
                        catch (ApplicationServerException e) {
                            ServiceDeploymentPhase.this.getLogger().error("Error while deploying service " + name + ".", (Throwable)e);
                        }
                    }
                });
            } else {
                this.getLogger().info("No services directory exists - not adding to scanner");
            }
            this.serviceSupervisor.scan();
        }
        catch (SupervisorException e) {
            throw new AppServerLifecycleException("Error deploying services in the app server.", e);
        }
    }
}

