/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.lifecycle.phase;

import java.io.File;
import org.codehaus.plexus.appserver.ApplicationServer;
import org.codehaus.plexus.appserver.ApplicationServerException;
import org.codehaus.plexus.appserver.application.deploy.ApplicationDeployer;
import org.codehaus.plexus.appserver.lifecycle.AppServerLifecycleException;
import org.codehaus.plexus.appserver.lifecycle.phase.AbstractAppServerPhase;
import org.codehaus.plexus.appserver.supervisor.Supervisor;
import org.codehaus.plexus.appserver.supervisor.SupervisorException;
import org.codehaus.plexus.appserver.supervisor.SupervisorListener;

public class ApplicationDeploymentPhase
extends AbstractAppServerPhase {
    private ApplicationDeployer applicationDeployer;
    private Supervisor applicationSupervisor;

    public void execute(ApplicationServer appServer) throws AppServerLifecycleException {
        try {
            File appsDirectory = new File(appServer.getAppServerHome(), "apps");
            if (appsDirectory.exists() && appsDirectory.isDirectory()) {
                this.applicationSupervisor.addDirectory(appsDirectory, new SupervisorListener(){

                    public void onJarDiscovered(File jar) {
                        String name = jar.getName();
                        try {
                            String appName = name.substring(0, name.length() - 4);
                            ApplicationDeploymentPhase.this.getLogger().info(ApplicationDeploymentPhase.this.applicationSupervisor.getName() + " is deploying " + appName + ".");
                            ApplicationDeploymentPhase.this.applicationDeployer.deploy(appName, jar);
                        }
                        catch (ApplicationServerException e) {
                            ApplicationDeploymentPhase.this.getLogger().error("Error while deploying appserver " + name + ".", (Throwable)e);
                        }
                    }
                });
            } else {
                this.getLogger().info("No apps directory exists - not scanning for applications");
            }
            this.applicationSupervisor.scan();
        }
        catch (SupervisorException e) {
            throw new AppServerLifecycleException("Error deploying applications in the app server.", e);
        }
    }
}

