/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.application.profile;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.appserver.service.PlexusService;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class AppRuntimeProfile {
    private String name;
    private File home;
    private File lib;
    private PlexusContainer applicationContainer;
    private ClassWorld applicationWorld;
    private PlexusContainer applicationServerContainer;
    private PlexusConfiguration applicationConfiguration;
    private Map serviceMap;
    private Map plexusConfigurationMap;
    private Map serviceConfigurationMap;

    public AppRuntimeProfile(String name, File home, File lib, PlexusContainer applicationServerContainer, PlexusConfiguration applicationConfiguration) {
        this.name = name;
        this.home = home;
        this.lib = lib;
        this.applicationWorld = new ClassWorld("plexus.application." + name, (ClassLoader)applicationServerContainer.getContainerRealm());
        this.applicationServerContainer = applicationServerContainer;
        this.applicationConfiguration = applicationConfiguration;
        this.serviceMap = new HashMap();
        this.plexusConfigurationMap = new HashMap();
        this.serviceConfigurationMap = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public File getHome() {
        return this.home;
    }

    public File getLib() {
        return this.lib;
    }

    public void setApplicationContainer(PlexusContainer applicationContainer) {
        this.applicationContainer = applicationContainer;
    }

    public PlexusContainer getApplicationContainer() {
        return this.applicationContainer;
    }

    public ClassWorld getApplicationWorld() {
        return this.applicationWorld;
    }

    public ClassRealm getApplicationRealm() {
        LinkedList realms = new LinkedList(this.applicationWorld.getRealms());
        if (realms.size() == 0) {
            return null;
        }
        return (ClassRealm)realms.get(0);
    }

    public PlexusContainer getApplicationServerContainer() {
        return this.applicationServerContainer;
    }

    public PlexusConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public List getServices() {
        return Collections.unmodifiableList(new ArrayList(this.plexusConfigurationMap.keySet()));
    }

    public List getServiceConfigurations() {
        return Collections.unmodifiableList(new ArrayList(this.plexusConfigurationMap.values()));
    }

    public PlexusService getService(String id) {
        return (PlexusService)this.serviceMap.get(id);
    }

    public PlexusConfiguration getPlexusConfiguration(PlexusService service) {
        return (PlexusConfiguration)this.plexusConfigurationMap.get(service);
    }

    public void addService(String id, PlexusService service, PlexusConfiguration configuration) {
        this.plexusConfigurationMap.put(service, configuration);
        this.serviceMap.put(id, service);
    }

    public Object getServiceConfiguration(PlexusService service) {
        return this.serviceConfigurationMap.get(service);
    }

    public void addServiceConfiguration(PlexusService service, Object configuration) {
        this.serviceConfigurationMap.put(service, configuration);
    }
}

