/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.application.deploy.lifecycle.phase;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentContext;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentException;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.phase.AbstractAppDeploymentPhase;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ProcessAppMetadataPhase
extends AbstractAppDeploymentPhase {
    public void execute(AppDeploymentContext context) throws AppDeploymentException {
        Xpp3Dom dom;
        InputStreamReader reader;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(context.getPar());
            ZipEntry entry = jarFile.getEntry("META-INF/plexus/application.xml");
            if (entry == null) {
                throw new AppDeploymentException("The Plexus appserver jar is missing it's metadata file 'META-INF/plexus/application.xml'.");
            }
            reader = new InputStreamReader(jarFile.getInputStream(entry));
        }
        catch (IOException e) {
            throw new AppDeploymentException("Error reading application JAR file: " + jarFile, e);
        }
        try {
            dom = Xpp3DomBuilder.build((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new AppDeploymentException("Error parsing application configurator file.", e);
        }
        catch (IOException e) {
            throw new AppDeploymentException("Error reading application configurator file.", e);
        }
        String appId = dom.getChild("name").getValue();
        if (StringUtils.isEmpty((String)appId)) {
            throw new AppDeploymentException("Missing 'name' element in the application metadata file.");
        }
        File appDir = new File(context.getApplicationsDirectory(), appId);
        context.setAppDir(appDir);
        context.setApplicationId(appId);
    }
}

