/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.application.deploy.lifecycle.phase;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentContext;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentException;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.phase.AbstractAppDeploymentPhase;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CreateAppConfigurationPhase
extends AbstractAppDeploymentPhase {
    public void execute(AppDeploymentContext context) throws AppDeploymentException {
        DefaultPlexusContainer serverContainer = context.getAppServerContainer();
        this.getLogger().info("Using appDir = " + context.getAppDir());
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Context containerContext = serverContainer.getContext();
        contextMap.putAll(containerContext.getContextData());
        Properties contextValues = context.getContext();
        if (contextValues != null) {
            Iterator<Object> i = contextValues.keySet().iterator();
            while (i.hasNext()) {
                String contextName = (String)i.next();
                contextMap.put(contextName, contextValues.getProperty(contextName));
            }
        }
        if (!contextMap.containsKey("appserver.home")) {
            contextMap.put("appserver.home", context.getAppServer().getAppServerHome().getAbsolutePath());
        }
        if (!contextMap.containsKey("appserver.base")) {
            contextMap.put("appserver.base", context.getAppServer().getAppServerBase().getAbsolutePath());
        }
        this.getLogger().debug("appserver.home = " + contextMap.get("appserver.home"));
        this.getLogger().debug("appserver.base = " + contextMap.get("appserver.base"));
        contextMap.put("plexus.home", context.getAppDir().getAbsolutePath());
        contextMap.put("app.home", context.getAppDir().getAbsolutePath());
        contextMap.put("user.home", System.getProperty("user.home"));
        Object appserver = null;
        try {
            appserver = serverContainer.getContext().get((Object)"plexus.appserver");
        }
        catch (ContextException e) {
            // empty catch block
        }
        contextMap.put("plexus.appserver", appserver);
        context.setContextValues(contextMap);
        Xpp3Dom dom = null;
        try {
            InterpolationFilterReader configurationReader = new InterpolationFilterReader((Reader)new FileReader(context.getAppConfigurationFile()), contextMap);
            dom = Xpp3DomBuilder.build((Reader)configurationReader);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new AppDeploymentException("Error processing application configurator.", e);
        }
        catch (XmlPullParserException e) {
            throw new AppDeploymentException("Error processing application configurator.", e);
        }
        if (dom != null) {
            XmlPlexusConfiguration applicationConfiguration = new XmlPlexusConfiguration(dom);
            context.setAppConfiguration((PlexusConfiguration)applicationConfiguration);
        }
    }
}

