/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.application.deploy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.appserver.ApplicationServer;
import org.codehaus.plexus.appserver.ApplicationServerException;
import org.codehaus.plexus.appserver.application.deploy.ApplicationDeployer;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentContext;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentException;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.phase.AppDeploymentPhase;
import org.codehaus.plexus.appserver.application.event.ApplicationListener;
import org.codehaus.plexus.appserver.application.event.DefaultDeployEvent;
import org.codehaus.plexus.appserver.application.event.DeployEvent;
import org.codehaus.plexus.appserver.application.profile.AppRuntimeProfile;
import org.codehaus.plexus.appserver.deploy.AbstractDeployer;
import org.codehaus.plexus.appserver.service.PlexusService;
import org.codehaus.plexus.appserver.service.PlexusServiceException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.FileUtils;

public class DefaultApplicationDeployer
extends AbstractDeployer
implements ApplicationDeployer,
Contextualizable,
Initializable,
Disposable {
    private Map deployments;
    private DefaultPlexusContainer appServerContainer;
    private List applicationListeners;
    private File applicationsDirectory;
    private List phases;

    public void deploy(String id, File location) throws ApplicationServerException {
        this.deployJar(location, true);
    }

    private void deployJar(File file, boolean expandPar) throws ApplicationServerException {
        AppDeploymentContext context = new AppDeploymentContext(file, this.applicationsDirectory, this.deployments, this.appServerContainer, this.getAppServer(), expandPar);
        Iterator i = this.phases.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            try {
                AppDeploymentPhase phase = (AppDeploymentPhase)this.appServerContainer.lookup(AppDeploymentPhase.ROLE, id, this.appServerContainer.getContainerRealm());
                phase.execute(context);
            }
            catch (ComponentLookupException e) {
                throw new ApplicationServerException("The requested app server lifecycle phase cannot be found: " + id, e);
            }
            catch (AppDeploymentException e) {
                throw new ApplicationServerException("Error in the app server lifecycle " + id + " phase.", e);
            }
        }
    }

    public void redeploy(String id) throws ApplicationServerException {
        AppRuntimeProfile profile = this.getApplicationRuntimeProfile(id);
        this.undeploy(id);
        File file = this.getAppServer().getAppDescriptor(id).getPar();
        this.deployJar(file, false);
        DeployEvent event = this.createDeployEvent(profile);
        Iterator itr = this.applicationListeners.iterator();
        while (itr.hasNext()) {
            ApplicationListener listener = (ApplicationListener)itr.next();
            listener.redeployedApplication(event);
        }
    }

    public void undeploy(String id) throws ApplicationServerException {
        this.getLogger().info("Undeploying '" + id + "'.");
        AppRuntimeProfile profile = this.getApplicationRuntimeProfile(id);
        this.deployments.remove(id);
        PlexusContainer app = profile.getApplicationContainer();
        try {
            this.stopApplicationServices(profile);
        }
        catch (PlexusServiceException e) {
            this.getLogger().info("Can not stop services attached to application ", (Throwable)e);
        }
        app.dispose();
        DeployEvent event = this.createDeployEvent(profile);
        Iterator itr = this.applicationListeners.iterator();
        while (itr.hasNext()) {
            ApplicationListener listener = (ApplicationListener)itr.next();
            listener.undeployedApplication(event);
        }
    }

    public boolean isDeployed(String id) {
        return this.deployments.containsKey(id);
    }

    private void stopApplicationServices(AppRuntimeProfile runtimeProfile) throws PlexusServiceException {
        if (runtimeProfile.getServices() != null) {
            Iterator serviceIterator = runtimeProfile.getServices().iterator();
            while (serviceIterator.hasNext()) {
                PlexusService service = (PlexusService)serviceIterator.next();
                service.applicationStop(runtimeProfile);
            }
        }
    }

    private DeployEvent createDeployEvent(AppRuntimeProfile runtimeProfile) {
        return new DefaultDeployEvent(runtimeProfile);
    }

    public AppRuntimeProfile getApplicationRuntimeProfile(String applicationName) throws ApplicationServerException {
        AppRuntimeProfile profile = (AppRuntimeProfile)this.deployments.get(applicationName);
        if (profile == null) {
            throw new ApplicationServerException("No such application: '" + applicationName + "'.");
        }
        return profile;
    }

    public void deleteApplication(String applicationName) throws ApplicationServerException {
        this.undeploy(applicationName);
        File file = this.getAppServer().getAppDescriptor(applicationName).getPar();
        File dir = new File(this.applicationsDirectory, applicationName);
        try {
            this.getLogger().info("deleting application directory " + dir.getPath());
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new ApplicationServerException("Failed to delete application: '" + applicationName + "'.", e);
        }
        file.delete();
        if (file.exists() || dir.exists()) {
            throw new ApplicationServerException("Failed to delete application: '" + applicationName + "'.");
        }
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.applicationListeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.applicationListeners.remove(listener);
    }

    public void contextualize(Context context) throws ContextException {
        this.appServerContainer = (DefaultPlexusContainer)context.get((Object)"plexus");
    }

    public void initialize() throws InitializationException {
        this.deployments = new HashMap();
        this.applicationListeners = new ArrayList();
        this.getLogger().info("Applications will be deployed in: '" + this.applicationsDirectory + "'.");
    }

    public void dispose() {
        ArrayList names = new ArrayList(this.deployments.keySet());
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            try {
                this.undeploy(name);
            }
            catch (ApplicationServerException e) {
                this.getLogger().warn("Error while undeploying appserver '" + name + "'.", (Throwable)e);
            }
        }
    }

    private ApplicationServer getAppServer() throws ApplicationServerException {
        try {
            return (ApplicationServer)this.appServerContainer.getContext().get((Object)"plexus.appserver");
        }
        catch (ContextException e) {
            throw new ApplicationServerException("Cannot retrieve app server from context.", e);
        }
    }

    public List getAppRuntimeProfiles() {
        return Collections.unmodifiableList(new ArrayList(this.deployments.values()));
    }
}

