/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver;

import java.io.File;
import java.util.HashMap;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.appserver.ApplicationServer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;

public class PlexusApplicationHost
implements Runnable {
    private DefaultPlexusContainer container;
    private boolean shouldStop;
    private boolean isStopped;
    private static final Object waitObj = new Object();
    private ApplicationServer applicationServer;
    private ClassWorld classWorld;
    private File configurationResource;

    public PlexusContainer getContainer() {
        return this.container;
    }

    public ApplicationServer getApplicationServer() {
        return this.applicationServer;
    }

    public void start(ClassWorld classWorld) throws Exception {
        this.start(classWorld, null);
    }

    public void start(ClassWorld classWorld, File configurationResource) throws Exception {
        this.classWorld = classWorld;
        String plexusHome = System.getProperty("plexus.home");
        plexusHome = new File(plexusHome).getAbsolutePath();
        File appserverHome = new File(System.getProperty("appserver.home", plexusHome));
        File appserverBase = new File(System.getProperty("appserver.base", appserverHome.getAbsolutePath()));
        if (configurationResource == null) {
            File conf = new File(new File(appserverBase, "conf"), "plexus.xml");
            if (!conf.exists() && !(conf = new File(new File(appserverHome, "conf"), "plexus.xml")).exists()) {
                throw new Exception("Unable to find a default configuration file");
            }
            configurationResource = conf;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("plexus.home", plexusHome);
        context.put("appserver.home", appserverHome.getAbsolutePath());
        context.put("appserver.base", appserverBase.getAbsolutePath());
        context.put("plexus.work", new File(appserverBase, "work").getAbsolutePath());
        File plexusTemp = new File(appserverBase, "temp");
        context.put("plexus.temp", plexusTemp.getAbsolutePath());
        File plexusLogs = new File(appserverBase, "logs");
        context.put("plexus.logs", plexusLogs.getAbsolutePath());
        if (!plexusLogs.exists()) {
            plexusLogs.mkdirs();
        }
        if (!plexusTemp.exists()) {
            plexusTemp.mkdirs();
        }
        this.container = new DefaultPlexusContainer("appserver", context, configurationResource, classWorld);
        this.configurationResource = configurationResource;
        LoggerManager loggerManager = (LoggerManager)this.container.lookup(LoggerManager.ROLE);
        loggerManager.setThreshold(0);
        final Logger logger = loggerManager.getLoggerForComponent(this.getClass().getName());
        this.applicationServer = (ApplicationServer)this.container.lookup(ApplicationServer.ROLE);
        logger.info("The appserver server has started.");
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    logger.info("Shutting down the appserver container.");
                    PlexusApplicationHost.this.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PlexusApplicationHost plexusApplicationHost = this;
        synchronized (plexusApplicationHost) {
            while (!this.shouldStop) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        plexusApplicationHost = this;
        synchronized (plexusApplicationHost) {
            this.isStopped = true;
            this.notifyAll();
        }
    }

    public void restart() throws Exception {
        this.shutdown();
        this.start(this.classWorld, this.configurationResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        PlexusApplicationHost plexusApplicationHost = this;
        synchronized (plexusApplicationHost) {
            this.shouldStop = true;
            this.container.release((Object)this.applicationServer);
            this.container.dispose();
            this.notifyAll();
        }
        plexusApplicationHost = this;
        synchronized (plexusApplicationHost) {
            while (!this.isStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Object object = waitObj;
            synchronized (object) {
                waitObj.notifyAll();
            }
        }
    }

    private boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args, ClassWorld classWorld) {
        try {
            PlexusApplicationHost host = new PlexusApplicationHost();
            if (args.length > 0) {
                host.start(classWorld, new File(args[0]));
            } else {
                host.start(classWorld);
            }
            while (!host.isStopped()) {
                try {
                    Object object = waitObj;
                    synchronized (object) {
                        waitObj.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public File getConfigurationResource() {
        return this.configurationResource;
    }
}

