/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.appserver.AppDescriptor;
import org.codehaus.plexus.appserver.ApplicationServer;
import org.codehaus.plexus.appserver.ApplicationServerException;
import org.codehaus.plexus.appserver.application.deploy.ApplicationDeployer;
import org.codehaus.plexus.appserver.application.profile.AppRuntimeProfile;
import org.codehaus.plexus.appserver.lifecycle.AppServerLifecycleException;
import org.codehaus.plexus.appserver.lifecycle.phase.AppServerPhase;
import org.codehaus.plexus.appserver.service.deploy.ServiceDeployer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;

public class DefaultApplicationServer
extends AbstractLogEnabled
implements ApplicationServer,
Initializable,
Contextualizable,
Startable {
    private PlexusContainer container;
    private ApplicationDeployer applicationDeployer;
    private ServiceDeployer serviceDeployer;
    private List phases;
    private Map appDescriptors;
    private File appServerHome;
    private File appServerBase;

    public AppRuntimeProfile getApplicationRuntimeProfile(String applicationId) throws ApplicationServerException {
        return this.applicationDeployer.getApplicationRuntimeProfile(applicationId);
    }

    public void deploy(String id, File location) throws ApplicationServerException {
        this.applicationDeployer.deploy(id, location);
    }

    public void redeploy(String id) throws ApplicationServerException {
        this.applicationDeployer.redeploy(id);
    }

    public void undeploy(String id) throws ApplicationServerException {
        this.applicationDeployer.undeploy(id);
    }

    public List getAppRuntimeProfiles() {
        return this.applicationDeployer.getAppRuntimeProfiles();
    }

    public void addAppDescriptor(AppDescriptor appDescriptor) {
        this.appDescriptors.put(appDescriptor.getId(), appDescriptor);
    }

    public AppDescriptor getAppDescriptor(String appName) {
        return (AppDescriptor)this.appDescriptors.get(appName);
    }

    public File getAppServerHome() {
        return this.appServerHome;
    }

    public File getAppServerBase() {
        return this.appServerBase;
    }

    public void setAppServerHome(File appServerHome) {
        this.appServerHome = appServerHome;
    }

    public void setAppServerBase(File appServerBase) {
        this.appServerBase = appServerBase;
    }

    public boolean isDeployed(String id) {
        return this.applicationDeployer.isDeployed(id);
    }

    public void deleteApplication(String id) throws ApplicationServerException {
        this.applicationDeployer.deleteApplication(id);
    }

    public Collection getAppDescriptors() {
        return this.appDescriptors.values();
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
        this.container.addContextValue((Object)"plexus.appserver", (Object)this);
        if (context.contains((Object)"appserver.home")) {
            this.appServerHome = new File((String)context.get((Object)"appserver.home"));
        } else if (context.contains((Object)"plexus.home")) {
            this.appServerHome = new File((String)context.get((Object)"plexus.home"));
        }
        this.appServerBase = context.contains((Object)"appserver.base") ? new File((String)context.get((Object)"appserver.base")) : this.appServerHome;
    }

    public void initialize() throws InitializationException {
        this.appDescriptors = new LinkedHashMap();
    }

    public void start() throws StartingException {
        Iterator i = this.phases.iterator();
        while (i.hasNext()) {
            String appServerPhaseId = (String)i.next();
            try {
                AppServerPhase appServerPhase = (AppServerPhase)this.container.lookup(AppServerPhase.ROLE, appServerPhaseId);
                appServerPhase.execute(this);
            }
            catch (ComponentLookupException e) {
                throw new StartingException("The requested app server lifecycle phase cannot be found: " + appServerPhaseId, (Throwable)e);
            }
            catch (AppServerLifecycleException e) {
                throw new StartingException("Error in the app server lifecycle " + appServerPhaseId + " phase.", (Throwable)e);
            }
        }
        this.getLogger().info("The appserver server has been initialized.");
    }

    public void stop() {
    }
}

