/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.naming;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.StringRefAddr;
import org.apache.naming.ResourceRef;
import org.codehaus.plexus.naming.Naming;
import org.codehaus.plexus.naming.Resource;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class DefaultNaming
implements Naming,
Initializable {
    private static final String COMP_CONTEXT_NAME = "java:comp";
    private static final String ENV_CONTEXT_NAME = "env";
    private Context envContext;
    private List resources;
    private boolean setSystemProperties = true;
    static /* synthetic */ Class class$org$apache$naming$java$javaURLContextFactory;

    public Context createInitialContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", (class$org$apache$naming$java$javaURLContextFactory == null ? (class$org$apache$naming$java$javaURLContextFactory = DefaultNaming.class$("org.apache.naming.java.javaURLContextFactory")) : class$org$apache$naming$java$javaURLContextFactory).getName());
        env.put("java.naming.factory.url.pkgs", "org.apache.naming");
        return new InitialContext(env);
    }

    public void initialize() throws InitializationException {
        if (this.setSystemProperties) {
            System.setProperty("java.naming.factory.initial", (class$org$apache$naming$java$javaURLContextFactory == null ? (class$org$apache$naming$java$javaURLContextFactory = DefaultNaming.class$("org.apache.naming.java.javaURLContextFactory")) : class$org$apache$naming$java$javaURLContextFactory).getName());
            System.setProperty("java.naming.factory.url.pkgs", "org.apache.naming");
        }
        try {
            Context initialContext = this.createInitialContext();
            Context subcontext = DefaultNaming.getOrCreate(initialContext, COMP_CONTEXT_NAME);
            this.envContext = DefaultNaming.getOrCreate(subcontext, ENV_CONTEXT_NAME);
            this.loadConfiguration();
        }
        catch (NamingException e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
    }

    private static Context getOrCreate(Context initialContext, String name) throws NamingException {
        Context subcontext;
        try {
            subcontext = initialContext.createSubcontext(name);
        }
        catch (NameAlreadyBoundException e) {
            subcontext = (Context)initialContext.lookup(name);
        }
        return subcontext;
    }

    public synchronized void destroyInitialContext() throws NamingException {
        InitialContext initialContext = new InitialContext();
        NamingEnumeration<NameClassPair> contexts = initialContext.list("");
        while (contexts.hasMore()) {
            initialContext.destroySubcontext(contexts.next().getName());
        }
        this.envContext = null;
    }

    public synchronized void loadConfiguration() throws NamingException {
        if (this.resources != null) {
            Iterator j = this.resources.iterator();
            while (j.hasNext()) {
                Resource r = (Resource)j.next();
                CompositeName name = new CompositeName(r.getName());
                try {
                    for (int i = 1; i <= name.size() - 1; ++i) {
                        this.envContext.createSubcontext(name.getPrefix(i));
                    }
                }
                catch (NameAlreadyBoundException e) {
                    // empty catch block
                }
                this.envContext.bind(r.getName(), (Object)this.createResource(r));
            }
        }
    }

    private ResourceRef createResource(Resource r) {
        ResourceRef ref = new ResourceRef(r.getType(), null, null, null);
        Properties parameters = r.getProperties();
        Iterator i = ((Hashtable)parameters).keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = parameters.getProperty(name);
            ref.add(new StringRefAddr(name, value));
        }
        return ref;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

