/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.jpox.util.Localiser;

public class TypeConversionHelper {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private static int NR_BIGINTEGER_BYTES = 40;
    private static int NR_SCALE_BYTES = 4;
    private static int NR_SIGNAL_BYTES = 1;
    private static int TOTAL_BYTES = NR_BIGINTEGER_BYTES + NR_SCALE_BYTES + NR_SIGNAL_BYTES;
    private static final String ZEROES = "000000000";
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean[] getBooleanArrayFromBitSet(BitSet value) {
        if (value == null) {
            return null;
        }
        boolean[] a = new boolean[value.length()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = value.get(i);
        }
        return a;
    }

    public static BitSet getBitSetFromBooleanArray(boolean[] buf) {
        BitSet set = new BitSet();
        for (int i = 0; i < buf.length; ++i) {
            if (!buf[i]) continue;
            set.set(i);
        }
        return set;
    }

    public static Object getBooleanArrayFromByteArray(byte[] buf) {
        int n = buf.length;
        boolean[] a = new boolean[n];
        for (int i = 0; i < n; ++i) {
            a[i] = buf[i] != 0;
        }
        return a;
    }

    public static byte[] getByteArrayFromBooleanArray(Object value) {
        if (value == null) {
            return null;
        }
        boolean[] a = (boolean[])value;
        int n = a.length;
        byte[] buf = new byte[n];
        for (int i = 0; i < n; ++i) {
            buf[i] = a[i] ? (byte)1 : 0;
        }
        return buf;
    }

    public static Object getCharArrayFromByteArray(byte[] buf) {
        int n = buf.length / 2;
        char[] a = new char[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = (char)(((buf[j++] & 0xFF) << 8) + (buf[j++] & 0xFF));
        }
        return a;
    }

    public static byte[] getByteArrayFromCharArray(Object value) {
        if (value == null) {
            return null;
        }
        char[] a = (char[])value;
        int n = a.length;
        byte[] buf = new byte[n * 2];
        int i = 0;
        int j = 0;
        while (i < n) {
            char x = a[i++];
            buf[j++] = (byte)(x >>> 8 & 0xFF);
            buf[j++] = (byte)(x & 0xFF);
        }
        return buf;
    }

    public static Object getDoubleArrayFromByteArray(byte[] buf) {
        int n = buf.length / 8;
        double[] a = new double[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = Double.longBitsToDouble(((long)(buf[j++] & 0xFF) << 56) + ((long)(buf[j++] & 0xFF) << 48) + ((long)(buf[j++] & 0xFF) << 40) + ((long)(buf[j++] & 0xFF) << 32) + ((long)(buf[j++] & 0xFF) << 24) + (long)((buf[j++] & 0xFF) << 16) + (long)((buf[j++] & 0xFF) << 8) + (long)(buf[j++] & 0xFF));
        }
        return a;
    }

    public static byte[] getByteArrayFromDoubleArray(Object value) {
        if (value == null) {
            return null;
        }
        double[] a = (double[])value;
        int n = a.length;
        byte[] buf = new byte[n * 8];
        int i = 0;
        int j = 0;
        while (i < n) {
            long x = Double.doubleToRawLongBits(a[i++]);
            buf[j++] = (byte)(x >>> 56 & 0xFFL);
            buf[j++] = (byte)(x >>> 48 & 0xFFL);
            buf[j++] = (byte)(x >>> 40 & 0xFFL);
            buf[j++] = (byte)(x >>> 32 & 0xFFL);
            buf[j++] = (byte)(x >>> 24 & 0xFFL);
            buf[j++] = (byte)(x >>> 16 & 0xFFL);
            buf[j++] = (byte)(x >>> 8 & 0xFFL);
            buf[j++] = (byte)(x & 0xFFL);
        }
        return buf;
    }

    public static Object getFloatArrayFromByteArray(byte[] buf) {
        int n = buf.length / 4;
        float[] a = new float[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = Float.intBitsToFloat(((buf[j++] & 0xFF) << 24) + ((buf[j++] & 0xFF) << 16) + ((buf[j++] & 0xFF) << 8) + (buf[j++] & 0xFF));
        }
        return a;
    }

    public static byte[] getByteArrayFromFloatArray(Object value) {
        if (value == null) {
            return null;
        }
        float[] a = (float[])value;
        int n = a.length;
        byte[] buf = new byte[n * 4];
        int i = 0;
        int j = 0;
        while (i < n) {
            int x = Float.floatToRawIntBits(a[i++]);
            buf[j++] = (byte)(x >>> 24 & 0xFF);
            buf[j++] = (byte)(x >>> 16 & 0xFF);
            buf[j++] = (byte)(x >>> 8 & 0xFF);
            buf[j++] = (byte)(x & 0xFF);
        }
        return buf;
    }

    public static Object getIntArrayFromByteArray(byte[] buf) {
        int n = buf.length / 4;
        int[] a = new int[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = ((buf[j++] & 0xFF) << 24) + ((buf[j++] & 0xFF) << 16) + ((buf[j++] & 0xFF) << 8) + (buf[j++] & 0xFF);
        }
        return a;
    }

    public static byte[] getByteArrayFromIntArray(Object value) {
        if (value == null) {
            return null;
        }
        int[] a = (int[])value;
        int n = a.length;
        byte[] buf = new byte[n * 4];
        int i = 0;
        int j = 0;
        while (i < n) {
            int x = a[i++];
            buf[j++] = (byte)(x >>> 24 & 0xFF);
            buf[j++] = (byte)(x >>> 16 & 0xFF);
            buf[j++] = (byte)(x >>> 8 & 0xFF);
            buf[j++] = (byte)(x & 0xFF);
        }
        return buf;
    }

    public static Object getLongArrayFromByteArray(byte[] buf) {
        int n = buf.length / 8;
        long[] a = new long[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = ((long)(buf[j++] & 0xFF) << 56) + ((long)(buf[j++] & 0xFF) << 48) + ((long)(buf[j++] & 0xFF) << 40) + ((long)(buf[j++] & 0xFF) << 32) + ((long)(buf[j++] & 0xFF) << 24) + (long)((buf[j++] & 0xFF) << 16) + (long)((buf[j++] & 0xFF) << 8) + (long)(buf[j++] & 0xFF);
        }
        return a;
    }

    public static byte[] getByteArrayFromLongArray(Object value) {
        if (value == null) {
            return null;
        }
        long[] a = (long[])value;
        int n = a.length;
        byte[] buf = new byte[n * 8];
        int i = 0;
        int j = 0;
        while (i < n) {
            long x = a[i++];
            buf[j++] = (byte)(x >>> 56 & 0xFFL);
            buf[j++] = (byte)(x >>> 48 & 0xFFL);
            buf[j++] = (byte)(x >>> 40 & 0xFFL);
            buf[j++] = (byte)(x >>> 32 & 0xFFL);
            buf[j++] = (byte)(x >>> 24 & 0xFFL);
            buf[j++] = (byte)(x >>> 16 & 0xFFL);
            buf[j++] = (byte)(x >>> 8 & 0xFFL);
            buf[j++] = (byte)(x & 0xFFL);
        }
        return buf;
    }

    public static Object getShortArrayFromByteArray(byte[] buf) {
        int n = buf.length / 2;
        short[] a = new short[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = (short)(((buf[j++] & 0xFF) << 8) + (buf[j++] & 0xFF));
        }
        return a;
    }

    public static byte[] getByteArrayFromShortArray(Object value) {
        if (value == null) {
            return null;
        }
        short[] a = (short[])value;
        int n = a.length;
        byte[] buf = new byte[n * 2];
        int i = 0;
        int j = 0;
        while (i < n) {
            short x = a[i++];
            buf[j++] = (byte)(x >>> 8 & 0xFF);
            buf[j++] = (byte)(x & 0xFF);
        }
        return buf;
    }

    public static byte[] getByteArrayFromBigDecimalArray(Object value) {
        if (value == null) {
            return null;
        }
        BigDecimal[] a = (BigDecimal[])value;
        byte[] total = new byte[a.length * TOTAL_BYTES];
        int index = 0;
        for (int i = 0; i < a.length; ++i) {
            System.arraycopy(new byte[]{(byte)a[i].signum()}, 0, total, index, NR_SIGNAL_BYTES);
            byte[] b = a[i].unscaledValue().abs().toByteArray();
            System.arraycopy(b, 0, total, (index += NR_SIGNAL_BYTES) + (NR_BIGINTEGER_BYTES - b.length), b.length);
            byte[] s = TypeConversionHelper.getByteArrayFromIntArray(new int[]{a[i].scale()});
            System.arraycopy(s, 0, total, index += NR_BIGINTEGER_BYTES, NR_SCALE_BYTES);
            index += NR_SCALE_BYTES;
        }
        return total;
    }

    public static Object getBigDecimalArrayFromByteArray(byte[] buf) {
        BigDecimal[] a = new BigDecimal[buf.length / TOTAL_BYTES];
        int index = 0;
        for (int i = 0; i < a.length; ++i) {
            byte[] signal = new byte[NR_SIGNAL_BYTES];
            System.arraycopy(buf, index, signal, 0, NR_SIGNAL_BYTES);
            byte[] b = new byte[NR_BIGINTEGER_BYTES];
            System.arraycopy(buf, index += NR_SIGNAL_BYTES, b, 0, NR_BIGINTEGER_BYTES);
            BigInteger integer = new BigInteger((int)signal[0], b);
            byte[] s = new byte[4];
            System.arraycopy(buf, index += NR_BIGINTEGER_BYTES, s, 0, NR_SCALE_BYTES);
            int[] scale = (int[])TypeConversionHelper.getIntArrayFromByteArray(s);
            a[i] = new BigDecimal(integer, scale[0]);
            index += NR_SCALE_BYTES;
        }
        return a;
    }

    public static byte[] getByteArrayFromBigIntegerArray(Object value) {
        if (value == null) {
            return null;
        }
        BigInteger[] a = (BigInteger[])value;
        long[] d = new long[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i].longValue();
        }
        return TypeConversionHelper.getByteArrayFromLongArray(d);
    }

    public static Object getBigIntegerArrayFromByteArray(byte[] buf) {
        long[] d = (long[])TypeConversionHelper.getLongArrayFromByteArray(buf);
        BigInteger[] a = new BigInteger[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new BigInteger("" + d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromBooleanObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        Boolean[] a = (Boolean[])value;
        boolean[] d = new boolean[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        return TypeConversionHelper.getByteArrayFromBooleanArray(d);
    }

    public static Object getBooleanObjectArrayFromByteArray(byte[] buf) {
        boolean[] d = (boolean[])TypeConversionHelper.getBooleanArrayFromByteArray(buf);
        Boolean[] a = new Boolean[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Boolean(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromByteObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        Byte[] a = (Byte[])value;
        byte[] d = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        return d;
    }

    public static Object getByteObjectArrayFromByteArray(byte[] buf) {
        if (buf == null) {
            return null;
        }
        Byte[] a = new Byte[buf.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Byte(buf[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromCharObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        Character[] a = (Character[])value;
        char[] d = new char[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i].charValue();
        }
        return TypeConversionHelper.getByteArrayFromCharArray(d);
    }

    public static Object getCharObjectArrayFromByteArray(byte[] buf) {
        char[] d = (char[])TypeConversionHelper.getCharArrayFromByteArray(buf);
        Character[] a = new Character[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Character(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromDoubleObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        Double[] a = (Double[])value;
        double[] d = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        return TypeConversionHelper.getByteArrayFromDoubleArray(d);
    }

    public static Object getDoubleObjectArrayFromByteArray(byte[] buf) {
        double[] d = (double[])TypeConversionHelper.getDoubleArrayFromByteArray(buf);
        Double[] a = new Double[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Double(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromFloatObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        Float[] a = (Float[])value;
        float[] d = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i].floatValue();
        }
        return TypeConversionHelper.getByteArrayFromFloatArray(d);
    }

    public static Object getFloatObjectArrayFromByteArray(byte[] buf) {
        float[] d = (float[])TypeConversionHelper.getFloatArrayFromByteArray(buf);
        Float[] a = new Float[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Float(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromIntObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        Integer[] a = (Integer[])value;
        int[] d = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        return TypeConversionHelper.getByteArrayFromIntArray(d);
    }

    public static Object getIntObjectArrayFromByteArray(byte[] buf) {
        int[] d = (int[])TypeConversionHelper.getIntArrayFromByteArray(buf);
        Integer[] a = new Integer[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Integer(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromLongObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        Long[] a = (Long[])value;
        long[] d = new long[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        return TypeConversionHelper.getByteArrayFromLongArray(d);
    }

    public static Object getLongObjectArrayFromByteArray(byte[] buf) {
        long[] d = (long[])TypeConversionHelper.getLongArrayFromByteArray(buf);
        Long[] a = new Long[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Long(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromShortObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        Short[] a = (Short[])value;
        short[] d = new short[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        return TypeConversionHelper.getByteArrayFromShortArray(d);
    }

    public static Object getShortObjectArrayFromByteArray(byte[] buf) {
        short[] d = (short[])TypeConversionHelper.getShortArrayFromByteArray(buf);
        Short[] a = new Short[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Short(d[i]);
        }
        return a;
    }

    public static Object convertTo(Object value, Class type) {
        if (!type.isAssignableFrom(value.getClass())) {
            if (type == Short.TYPE || type == (class$java$lang$Short == null ? (class$java$lang$Short = TypeConversionHelper.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short(value.toString());
            }
            if (type == Character.TYPE || type == (class$java$lang$Character == null ? (class$java$lang$Character = TypeConversionHelper.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Character(value.toString().charAt(0));
            }
            if (type == Integer.TYPE || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConversionHelper.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(value.toString());
            }
            if (type == Long.TYPE || type == (class$java$lang$Long == null ? (class$java$lang$Long = TypeConversionHelper.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long(value.toString());
            }
            if (type == Boolean.TYPE || type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConversionHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return new Boolean(value.toString());
            }
            if (type == Byte.TYPE || type == (class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConversionHelper.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte(value.toString());
            }
            if (type == Float.TYPE || type == (class$java$lang$Float == null ? (class$java$lang$Float = TypeConversionHelper.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(value.toString());
            }
            if (type == Double.TYPE || type == (class$java$lang$Double == null ? (class$java$lang$Double = TypeConversionHelper.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(value.toString());
            }
            if (type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeConversionHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                return new BigDecimal(value.toString());
            }
            if (type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = TypeConversionHelper.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                return new BigInteger(value.toString());
            }
            if (type == (class$java$lang$String == null ? (class$java$lang$String = TypeConversionHelper.class$("java.lang.String")) : class$java$lang$String)) {
                return value.toString();
            }
            return null;
        }
        return value;
    }

    public static String getStringFromInt(int val) {
        byte[] arr = new byte[4];
        for (int i = 3; i >= 0; --i) {
            arr[i] = (byte)((0xFFL & (long)val) + -128L);
            val >>>= 8;
        }
        return new String(arr);
    }

    public static String getStringFromShort(short val) {
        byte[] arr = new byte[2];
        for (int i = 1; i >= 0; --i) {
            arr[i] = (byte)((0xFFL & (long)val) + -128L);
            val = (short)(val >>> 8);
        }
        return new String(arr);
    }

    public static String getHexFromInt(int val) {
        StringBuffer str = new StringBuffer("00000000");
        String hexstr = Integer.toHexString(val);
        str.replace(8 - hexstr.length(), 8, hexstr);
        return str.toString();
    }

    public static String getHexFromShort(short val) {
        StringBuffer str = new StringBuffer("0000");
        String hexstr = Integer.toHexString(val);
        str.replace(4 - hexstr.length(), 4, hexstr);
        return str.toString();
    }

    public static int getIntFromByteArray(byte[] bytes) {
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val = (val << 8) - -128 + bytes[i];
        }
        return val;
    }

    public static Timestamp stringToTimestamp(String s, Calendar cal) {
        int[] numbers = TypeConversionHelper.convertStringToIntArray(s);
        if (numbers == null || numbers.length < 6) {
            throw new IllegalArgumentException(LOCALISER.msg("TypeConversion.BadTimestampFormat", s));
        }
        int year = numbers[0];
        int month = numbers[1];
        int day = numbers[2];
        int hour = numbers[3];
        int minute = numbers[4];
        int second = numbers[5];
        int nanos = 0;
        if (numbers.length > 6) {
            nanos = numbers[6];
        }
        Calendar thecal = cal;
        if (cal == null) {
            thecal = new GregorianCalendar();
        }
        thecal.set(0, 1);
        thecal.set(1, year);
        thecal.set(2, month - 1);
        thecal.set(5, day);
        thecal.set(11, hour);
        thecal.set(12, minute);
        thecal.set(13, second);
        Timestamp ts = new Timestamp(thecal.getTime().getTime());
        ts.setNanos(nanos);
        return ts;
    }

    private static int[] convertStringToIntArray(String str) {
        if (str == null) {
            return null;
        }
        int[] values = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int start = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (start == -1 && Character.isDigit(str.charAt(i))) {
                start = i;
            }
            if (start == i || start < 0 || Character.isDigit(str.charAt(i))) continue;
            list.add(new Integer(str.substring(start, i)));
            start = -1;
        }
        if (list.size() > 0) {
            values = new int[list.size()];
            Iterator iter = list.iterator();
            int n = 0;
            while (iter.hasNext()) {
                values[n++] = (Integer)iter.next();
            }
        }
        return values;
    }

    public static String timestampToString(Timestamp ts, Calendar cal) {
        cal.setTime(ts);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String yearString = Integer.toString(year);
        String monthString = month < 10 ? "0" + month : Integer.toString(month);
        String dayString = day < 10 ? "0" + day : Integer.toString(day);
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        String secondString = second < 10 ? "0" + second : Integer.toString(second);
        String nanosString = Integer.toString(ts.getNanos());
        if (ts.getNanos() != 0) {
            nanosString = ZEROES.substring(0, ZEROES.length() - nanosString.length()) + nanosString;
            int truncIndex = nanosString.length() - 1;
            while (nanosString.charAt(truncIndex) == '0') {
                --truncIndex;
            }
            nanosString = nanosString.substring(0, truncIndex + 1);
        }
        return yearString + "-" + monthString + "-" + dayString + " " + hourString + ":" + minuteString + ":" + secondString + "." + nanosString;
    }

    public static int intFromString(String str, int dflt) {
        try {
            Integer val = new Integer(str);
            return val;
        }
        catch (NumberFormatException nfe) {
            return dflt;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

