/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jpox.util.JPOXLogger;

public class Localiser {
    private static Hashtable helpers = new Hashtable();
    private static Locale locale = Locale.getDefault();
    private ResourceBundle bundle = null;
    private static Hashtable msgFormats = new Hashtable();
    static /* synthetic */ Class class$org$jpox$AbstractPersistenceManagerFactory;
    static /* synthetic */ Class class$java$lang$Throwable;

    private Localiser(String bundle_name, ClassLoader class_loader) {
        try {
            this.bundle = ResourceBundle.getBundle(bundle_name, locale, class_loader);
        }
        catch (MissingResourceException mre) {
            JPOXLogger.GENERAL.error("ResourceBundle " + bundle_name + " for locale " + locale + " was not found!");
        }
    }

    public static Localiser getInstance(String bundle_name) {
        return Localiser.getInstance(bundle_name, (class$org$jpox$AbstractPersistenceManagerFactory == null ? (class$org$jpox$AbstractPersistenceManagerFactory = Localiser.class$("org.jpox.AbstractPersistenceManagerFactory")) : class$org$jpox$AbstractPersistenceManagerFactory).getClassLoader());
    }

    public static Localiser getInstance(String bundle_name, ClassLoader class_loader) {
        Localiser localiser = (Localiser)helpers.get(bundle_name);
        if (localiser != null) {
            return localiser;
        }
        localiser = new Localiser(bundle_name, class_loader);
        helpers.put(bundle_name, localiser);
        return localiser;
    }

    public String msg(String message_key) {
        return this.bundle.getString(message_key);
    }

    public String msg(String message_key, Object arg1) {
        Object[] args = new Object[]{arg1};
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    public String msg(String message_key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    public String msg(String message_key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    public String msg(String message_key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    public String msg(String message_key, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5};
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    public String msg(String message_key, Object[] args) {
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    public String msg(String message_key, int arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    public String msg(String message_key, long arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    public String msg(String message_key, boolean arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return Localiser.getMessage(this.bundle, message_key, args);
    }

    private static String getStringFromException(Throwable exception) {
        StringBuffer msg = new StringBuffer();
        if (exception != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.close();
            try {
                stringWriter.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            msg.append(exception.getMessage());
            msg.append('\n');
            msg.append(stringWriter.toString());
            if (exception instanceof SQLException) {
                if (((SQLException)exception).getNextException() != null) {
                    msg.append('\n');
                    msg.append(Localiser.getStringFromException(((SQLException)exception).getNextException()));
                }
            } else if (exception instanceof InvocationTargetException && ((InvocationTargetException)exception).getTargetException() != null) {
                msg.append('\n');
                msg.append(Localiser.getStringFromException(((InvocationTargetException)exception).getTargetException()));
            }
        }
        return msg.toString();
    }

    private static final String getMessage(ResourceBundle the_bundle, String message_key, Object[] msg_args) {
        if (message_key == null) {
            JPOXLogger.GENERAL.error("Attempt to retrieve resource with NULL name !");
            return null;
        }
        for (int i = 0; i < msg_args.length; ++i) {
            if (msg_args[i] == null) {
                msg_args[i] = "";
            }
            if (!(class$java$lang$Throwable == null ? Localiser.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(msg_args[i].getClass())) continue;
            msg_args[i] = Localiser.getStringFromException((Throwable)msg_args[i]);
        }
        try {
            String stringForKey = the_bundle.getString(message_key);
            MessageFormat formatter = (MessageFormat)msgFormats.get(stringForKey);
            if (formatter == null) {
                formatter = new MessageFormat(stringForKey);
                msgFormats.put(stringForKey, formatter);
            }
            return formatter.format(msg_args);
        }
        catch (MissingResourceException mre) {
            JPOXLogger.GENERAL.error("Parameter " + message_key + " doesn't exist for bundle " + the_bundle);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

