/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jpox.util.JPOXLogger;

public class JDK14Logger
extends JPOXLogger {
    private Logger logger = null;

    public JDK14Logger(String logName) {
        this.logger = Logger.getLogger(logName);
    }

    public void debug(Object msg) {
        this.logger.fine(msg.toString());
    }

    public void debug(Object msg, Throwable thr) {
        this.logger.fine(msg.toString());
    }

    public void info(Object msg) {
        this.logger.info(msg.toString());
    }

    public void info(Object msg, Throwable thr) {
        this.logger.info(msg.toString() + " : " + thr.getMessage());
    }

    public void warn(Object msg) {
        this.logger.warning(msg.toString());
    }

    public void warn(Object msg, Throwable thr) {
        this.logger.warning(msg.toString() + " : " + thr.getMessage());
    }

    public void error(Object msg) {
        this.logger.severe(msg.toString());
    }

    public void error(Object msg, Throwable thr) {
        this.logger.severe(msg.toString() + " : " + thr.getMessage());
    }

    public void fatal(Object msg) {
        this.logger.severe(msg.toString());
    }

    public void fatal(Object msg, Throwable thr) {
        this.logger.severe(msg.toString() + " : " + thr.getMessage());
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }
}

