/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.typeinfo;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.JDOFatalDataStoreException;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class TypeInfo {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    public String typeName;
    public short dataType;
    public int precision;
    public String literalPrefix;
    public String literalSuffix;
    public String createParams;
    public int nullable;
    public boolean caseSensitive;
    public short searchable;
    public boolean unsignedAttribute;
    public boolean fixedPrecScale;
    public boolean autoIncrement;
    public String localTypeName;
    public short minimumScale;
    public short maximumScale;
    public int numPrecRadix;
    private int hash = 0;
    public boolean allowsPrecisionSpec = true;

    public TypeInfo(ResultSet rs) throws JDOFatalDataStoreException {
        try {
            this.typeName = rs.getString(1);
            this.dataType = rs.getShort(2);
            this.precision = (int)rs.getLong(3);
            this.literalPrefix = rs.getString(4);
            this.literalSuffix = rs.getString(5);
            this.createParams = rs.getString(6);
            this.nullable = rs.getInt(7);
            this.caseSensitive = rs.getBoolean(8);
            this.searchable = rs.getShort(9);
            this.unsignedAttribute = rs.getBoolean(10);
            this.fixedPrecScale = rs.getBoolean(11);
            this.autoIncrement = rs.getBoolean(12);
            this.localTypeName = rs.getString(13);
            this.minimumScale = rs.getShort(14);
            this.maximumScale = rs.getShort(15);
            this.numPrecRadix = rs.getInt(18);
        }
        catch (SQLException e) {
            throw new JDOFatalDataStoreException("Can't read JDBC metadata from result set", (Throwable)e);
        }
    }

    public TypeInfo(String typeName, short dataType, int precision, String literalPrefix, String literalSuffix, String createParams, int nullable, boolean caseSensitive, short searchable, boolean unsignedAttribute, boolean fixedPrecScale, boolean autoIncrement, String localTypeName, short minimumScale, short maximumScale, int numPrecRadix) {
        this.typeName = typeName;
        this.dataType = dataType;
        this.precision = precision;
        this.literalPrefix = literalPrefix;
        this.literalSuffix = literalSuffix;
        this.createParams = createParams;
        this.nullable = nullable;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.unsignedAttribute = unsignedAttribute;
        this.fixedPrecScale = fixedPrecScale;
        this.autoIncrement = autoIncrement;
        this.localTypeName = localTypeName;
        this.minimumScale = minimumScale;
        this.maximumScale = maximumScale;
        this.numPrecRadix = numPrecRadix;
    }

    public boolean isCompatibleWith(ColumnInfo ci) {
        return TypeInfo.areCompatibleTypes(this.dataType, ci.getDataType());
    }

    public boolean isToValidate(ColumnInfo ci) {
        return ci.getDataType() != 1111;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeInfo)) {
            return false;
        }
        TypeInfo ti = (TypeInfo)obj;
        return this.typeName.equals(ti.typeName) && this.dataType == ti.dataType;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.typeName.hashCode() ^ this.dataType;
        }
        return this.hash;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getClass().getName() + "\n");
        str.append("  typeName          = " + this.typeName + "\n");
        str.append("  jdbcTypeName      = " + JDBCUtils.getNameForJDBCType(this.dataType) + "\n");
        str.append("  dataType          = " + this.dataType + "\n");
        str.append("  precision         = " + this.precision + "\n");
        str.append("  literalPrefix     = " + this.literalPrefix + "\n");
        str.append("  literalSuffix     = " + this.literalSuffix + "\n");
        str.append("  createParams      = " + this.createParams + "\n");
        str.append("  nullable          = " + this.nullable + "\n");
        str.append("  caseSensitive     = " + this.caseSensitive + "\n");
        str.append("  searchable        = " + this.searchable + "\n");
        str.append("  unsignedAttribute = " + this.unsignedAttribute + "\n");
        str.append("  fixedPrecScale    = " + this.fixedPrecScale + "\n");
        str.append("  autoIncrement     = " + this.autoIncrement + "\n");
        str.append("  localTypeName     = " + this.localTypeName + "\n");
        str.append("  minimumScale      = " + this.minimumScale + "\n");
        str.append("  maximumScale      = " + this.maximumScale + "\n");
        str.append("  numPrecRadix      = " + this.numPrecRadix + "\n");
        return str.toString();
    }

    public static boolean areCompatibleTypes(int expected, int actual) {
        if (actual == 1111) {
            JPOXLogger.RDBMS.warn(LOCALISER.msg("TypeInfo.UnrecognizedDatatype", JDBCUtils.getNameForJDBCType(actual)));
            return true;
        }
        switch (expected) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return TypeInfo.isIntegerType(actual);
            }
            case 6: 
            case 7: 
            case 8: {
                return TypeInfo.isFloatingType(actual);
            }
            case 2: 
            case 3: {
                return TypeInfo.isNumericType(actual);
            }
            case -1: 
            case 12: {
                return TypeInfo.isCharacterType(actual);
            }
            case 91: 
            case 92: 
            case 93: {
                return TypeInfo.isDateType(actual);
            }
        }
        return expected == actual;
    }

    private static boolean isIntegerType(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return TypeInfo.isNumericType(type);
    }

    private static boolean isDateType(int type) {
        switch (type) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private static boolean isFloatingType(int type) {
        switch (type) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return TypeInfo.isNumericType(type);
    }

    private static boolean isNumericType(int type) {
        switch (type) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCharacterType(int type) {
        switch (type) {
            case -1: 
            case 12: {
                return true;
            }
        }
        return false;
    }
}

