/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.util.ArrayList;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ForeignKeyAction;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.JoinMetaData;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.table.AbstractClassTable;
import org.jpox.store.rdbms.table.ClassTable;

public class SecondaryTable
extends AbstractClassTable
implements DatastoreClass {
    private ClassTable primaryTable;
    private JoinMetaData joinMetaData;

    SecondaryTable(DatastoreIdentifier tableName, RDBMSManager storeMgr, ClassTable primaryTable, JoinMetaData jmd, ClassLoaderResolver clr) {
        super(tableName, storeMgr);
        if (primaryTable == null) {
            throw new JDOUnsupportedOptionException(LOCALISER.msg("RDBMS.Table.Secondary.PrimaryTableNotSpecified", tableName.getIdentifier()));
        }
        this.primaryTable = primaryTable;
        this.joinMetaData = jmd;
    }

    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        if (!this.isPKInitialized()) {
            this.initializePK(clr);
        }
    }

    public void postInitialize(ClassLoaderResolver clr) {
        this.assertIsInitialized();
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        this.state = 2;
    }

    protected void initializePK(ClassLoaderResolver clr) {
        this.assertIsPKUninitialized();
        if (this.primaryTable.getIdentityType() == IdentityType.APPLICATION) {
            this.addApplicationIdUsingClassTableId(this.joinMetaData, this.primaryTable, clr, this.primaryTable.getClassMetaData());
        } else if (this.primaryTable.getIdentityType() == IdentityType.DATASTORE) {
            this.addDatastoreId(this.joinMetaData, this.primaryTable, this.primaryTable.getClassMetaData());
        }
        this.state = 1;
    }

    public PrimaryKey getPrimaryKey() {
        PrimaryKey pk = super.getPrimaryKey();
        if (this.joinMetaData == null) {
            throw new JDOUserException("A relationship to a secondary table requires a <join> specification. The secondary table is " + this.getDatastoreIdentifierFullyQualified() + " and the primary table is " + this.getPrimaryDatastoreContainerObject() + ". The fields mapped to this secondary table are: " + this.fieldMappingsMap.keySet().toString());
        }
        PrimaryKeyMetaData pkmd = this.joinMetaData.getPrimaryKeyMetaData();
        if (pkmd != null && pkmd.getName() != null) {
            pk.setName(pkmd.getName());
        }
        return pk;
    }

    public DatastoreContainerObject getPrimaryDatastoreContainerObject() {
        return this.primaryTable;
    }

    public IdentityType getIdentityType() {
        return this.primaryTable.getIdentityType();
    }

    public String getType() {
        return this.primaryTable.getType();
    }

    public boolean isObjectIDDatastoreAttributed() {
        return false;
    }

    public boolean isBaseDatastoreClass() {
        return this.primaryTable.isBaseDatastoreClass();
    }

    public DatastoreClass getBaseDatastoreClassWithField(AbstractPropertyMetaData fmd) {
        return this.primaryTable.getBaseDatastoreClassWithField(fmd);
    }

    public DatastoreClass getSuperDatastoreClass() {
        return null;
    }

    public boolean managesClass(String className) {
        return false;
    }

    private void assertPCClass(StateManager sm) {
        this.primaryTable.assertPCClass(sm);
    }

    public void insert(StateManager sm) {
        this.assertIsInitialized();
        this.assertPCClass(sm);
        this.storeMgr.getInsertRequest(this, sm.getObject().getClass(), sm.getPersistenceManager().getClassLoaderResolver()).execute(sm);
    }

    public void fetch(StateManager sm, AbstractPropertyMetaData[] fieldMetaData) {
    }

    public void update(StateManager sm, AbstractPropertyMetaData[] fieldMetaData) {
        this.assertIsInitialized();
        this.assertPCClass(sm);
        this.storeMgr.getUpdateRequest(this, fieldMetaData, sm.getObject().getClass(), sm.getPersistenceManager().getClassLoaderResolver()).execute(sm);
    }

    public void delete(StateManager sm) {
        this.assertIsInitialized();
        this.assertPCClass(sm);
        this.storeMgr.getDeleteRequest(this, sm.getObject().getClass(), sm.getPersistenceManager().getClassLoaderResolver()).execute(sm);
    }

    public void locate(StateManager sm) {
    }

    public void deleteDependent(StateManager sm, AbstractPropertyMetaData[] fields) {
    }

    protected List getExpectedForeignKeys() {
        ForeignKeyMetaData fkmd;
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getPMFContext().getPmfConfiguration().getForeignKeyCreateMode() == "AUTO") {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        ForeignKeyMetaData foreignKeyMetaData = fkmd = this.joinMetaData != null ? this.joinMetaData.getForeignKeyMetaData() : null;
        if (autoMode || fkmd != null && fkmd.getDeleteAction() != ForeignKeyAction.NONE) {
            ForeignKey fk = new ForeignKey(this.getIDMapping(), this.dba, this.primaryTable, fkmd != null && fkmd.isDeferred());
            if (fkmd != null && fkmd.getName() != null) {
                fk.setName(fkmd.getName());
            }
            foreignKeys.add(0, fk);
        }
        return foreignKeys;
    }

    public JavaTypeMapping getFieldMapping(AbstractPropertyMetaData fmd) {
        this.assertIsInitialized();
        JavaTypeMapping m = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
        if (m != null) {
            return m;
        }
        return null;
    }

    public JavaTypeMapping getFieldMapping(String fieldName) {
        return this.getFieldMapping(this.primaryTable.getFieldMetaData(fieldName));
    }

    public JavaTypeMapping getIDMapping() {
        if (this.idMapping != null) {
            return this.idMapping;
        }
        PersistenceCapableMapping mapping = new PersistenceCapableMapping();
        mapping.initialize(this.getStoreManager().getDatastoreAdapter(), this.primaryTable.getClassMetaData().getFullClassName());
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            mapping.addJavaTypeMapping(this.datastoreIDMapping);
        } else if (this.getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < this.pkMappings.length; ++i) {
                mapping.addJavaTypeMapping(this.pkMappings[i]);
            }
        }
        this.idMapping = mapping;
        return mapping;
    }

    public void providePrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        ClassMetaData cmd = this.primaryTable.getClassMetaData();
        if (this.pkMappings != null) {
            int[] primaryKeyFieldNumbers = cmd.getPrimaryKeyFieldNumbers();
            for (int i = 0; i < this.pkMappings.length; ++i) {
                AbstractPropertyMetaData fmd = cmd.getManagedFieldAbsolute(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.pkMappings[i], fmd);
            }
        } else {
            int[] primaryKeyFieldNumbers = cmd.getPrimaryKeyFieldNumbers();
            int countPkFields = cmd.getNoOfPrimaryKeyFields();
            for (int i = 0; i < countPkFields; ++i) {
                AbstractPropertyMetaData pkfmd = cmd.getManagedFieldAbsolute(primaryKeyFieldNumbers[i]);
                consumer.consumeMapping(this.getFieldMapping(pkfmd), pkfmd);
            }
        }
    }

    public void provideExternalMappings(MappingConsumer consumer, int mappingType) {
    }

    public Object newOID(PersistenceManager sm, PersistenceCapable pcClass) {
        throw new UnsupportedOperationException("Currently, there is no support for creating ids for secondary tables");
    }

    public JavaTypeMapping getExternalMapping(AbstractPropertyMetaData fmd, int mappingType) {
        throw new JDOFatalInternalException("N/A");
    }

    public AbstractPropertyMetaData getMetaDataForExternalMapping(JavaTypeMapping mapping, int mappingType) {
        throw new JDOFatalInternalException("N/A");
    }
}

