/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.StoreData;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.exceptions.MissingTableException;
import org.jpox.store.rdbms.table.TableImpl;

public class SchemaTable
extends TableImpl {
    private JavaTypeMapping classMapping = null;
    private JavaTypeMapping tableMapping = null;
    private JavaTypeMapping typeMapping = null;
    private JavaTypeMapping ownerMapping = null;
    private JavaTypeMapping versionMapping = null;
    private JavaTypeMapping interfaceNameMapping = null;
    private String insertStmt = null;
    private String deleteStmt = null;
    private String deleteAllStmt = null;
    private String fetchAllStmt = null;
    private String fetchStmt = null;
    static /* synthetic */ Class class$java$lang$String;

    public SchemaTable(RDBMSManager storeMgr) {
        super(storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier("JPOX_TABLES"), storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        MappingManager mgr = this.getStoreManager().getMappingManager();
        this.classMapping = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        Column class_column = (Column)this.addDatastoreField((class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName(), idFactory.newDatastoreFieldIdentifier("CLASS_NAME"), this.classMapping, null);
        mgr.createDatastoreMapping(this.classMapping, this.storeMgr, class_column, (class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName());
        class_column.getColumnMetaData().setLength(128);
        class_column.getColumnMetaData().setJdbcType("VARCHAR");
        class_column.setUnique();
        this.tableMapping = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        Column table_column = (Column)this.addDatastoreField((class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName(), idFactory.newDatastoreFieldIdentifier("TABLE_NAME"), this.tableMapping, null);
        mgr.createDatastoreMapping(this.tableMapping, this.storeMgr, table_column, (class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName());
        table_column.getColumnMetaData().setLength(128);
        table_column.getColumnMetaData().setJdbcType("VARCHAR");
        this.typeMapping = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        Column type_column = (Column)this.addDatastoreField((class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName(), idFactory.newDatastoreFieldIdentifier("TYPE"), this.typeMapping, null);
        mgr.createDatastoreMapping(this.typeMapping, this.storeMgr, type_column, (class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName());
        type_column.getColumnMetaData().setLength(4);
        type_column.getColumnMetaData().setJdbcType("VARCHAR");
        this.ownerMapping = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        Column owner_column = (Column)this.addDatastoreField((class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName(), idFactory.newDatastoreFieldIdentifier("OWNER"), this.ownerMapping, null);
        mgr.createDatastoreMapping(this.ownerMapping, this.storeMgr, owner_column, (class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName());
        owner_column.getColumnMetaData().setLength(2);
        owner_column.getColumnMetaData().setJdbcType("VARCHAR");
        this.versionMapping = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        Column version_column = (Column)this.addDatastoreField((class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName(), idFactory.newDatastoreFieldIdentifier("VERSION"), this.versionMapping, null);
        mgr.createDatastoreMapping(this.versionMapping, this.storeMgr, version_column, (class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName());
        version_column.getColumnMetaData().setLength(20);
        version_column.getColumnMetaData().setJdbcType("VARCHAR");
        this.interfaceNameMapping = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        Column interfaceName_column = (Column)this.addDatastoreField((class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName(), idFactory.newDatastoreFieldIdentifier("INTERFACE_NAME"), this.interfaceNameMapping, null);
        mgr.createDatastoreMapping(this.interfaceNameMapping, this.storeMgr, interfaceName_column, (class$java$lang$String == null ? (class$java$lang$String = SchemaTable.class$("java.lang.String")) : class$java$lang$String).getName());
        interfaceName_column.getColumnMetaData().setLength(255);
        interfaceName_column.getColumnMetaData().setJdbcType("VARCHAR");
        interfaceName_column.setNullable();
        this.insertStmt = "INSERT INTO " + this.toString() + " (" + class_column.getIdentifier() + "," + table_column.getIdentifier() + "," + type_column.getIdentifier() + "," + owner_column.getIdentifier() + "," + version_column.getIdentifier() + "," + interfaceName_column.getIdentifier() + ") VALUES (?,?,?,?,?,?)";
        this.deleteStmt = "DELETE FROM " + this.toString() + " WHERE " + idFactory.getIdentifierInAdapterCase("CLASS_NAME") + "=?";
        this.deleteAllStmt = "DELETE FROM " + this.toString();
        this.fetchAllStmt = "SELECT " + class_column.getIdentifier() + "," + table_column.getIdentifier() + "," + type_column.getIdentifier() + "," + owner_column.getIdentifier() + "," + version_column.getIdentifier() + "," + interfaceName_column.getIdentifier() + " FROM " + this.toString() + " ORDER BY " + table_column.getIdentifier();
        this.fetchStmt = "SELECT 1 FROM " + this.toString() + " WHERE " + idFactory.getIdentifierInAdapterCase("CLASS_NAME") + " = ? ";
        this.state = 2;
    }

    public JavaTypeMapping getIDMapping() {
        throw new JDOFatalInternalException("Attempt to get ID mapping of SchemaTable!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getAllClasses(Connection conn) throws SQLException {
        HashSet<StoreData> schema_data = new HashSet<StoreData>();
        if (SchemaTable.isDumpingDdl() && !this.tableExists(conn)) {
            return schema_data;
        }
        PreparedStatement ps = this.storeMgr.getStatement(conn, this.fetchAllStmt, true);
        try {
            ResultSet rs = this.storeMgr.executeStatementQuery(this.fetchAllStmt, ps);
            try {
                while (rs.next()) {
                    StoreData data = new StoreData(rs.getString(1), rs.getString(2), rs.getString(4).equals("1"), rs.getString(3).equals("FCO") ? 1 : 2, rs.getString(6));
                    schema_data.add(data);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        return schema_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(StoreData data, Connection conn) throws SQLException {
        if (SchemaTable.isDumpingDdl()) {
            return;
        }
        if (this.hasClass(data, conn)) {
            return;
        }
        PreparedStatement ps = this.storeMgr.getStatement(conn, this.insertStmt, false);
        try {
            int jdbc_id = 1;
            this.classMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id, this.classMapping), data.getName());
            this.tableMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.classMapping.getNumberOfDatastoreFields(), this.tableMapping), data.hasTable() ? data.getTableName() : "");
            this.typeMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.tableMapping.getNumberOfDatastoreFields(), this.typeMapping), data.isFCO() ? "FCO" : "SCO");
            this.ownerMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.typeMapping.getNumberOfDatastoreFields(), this.ownerMapping), data.isTableOwner() ? "1" : "0");
            this.versionMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.ownerMapping.getNumberOfDatastoreFields(), this.versionMapping), "JPOX");
            this.interfaceNameMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.versionMapping.getNumberOfDatastoreFields(), this.interfaceNameMapping), data.getInterfaceName());
            jdbc_id += this.interfaceNameMapping.getNumberOfDatastoreFields();
            this.storeMgr.executeStatementUpdate(this.insertStmt, ps);
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasClass(StoreData data, Connection conn) throws SQLException {
        if (!this.tableExists(conn)) {
            return false;
        }
        PreparedStatement ps = this.storeMgr.getStatement(conn, this.fetchStmt, true);
        try {
            int jdbc_id = 1;
            this.tableMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id, this.tableMapping), data.getName());
            ResultSet rs = this.storeMgr.executeStatementQuery(this.fetchStmt, ps);
            try {
                if (rs.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClass(String class_name, Connection conn) throws SQLException {
        PreparedStatement ps = this.storeMgr.getStatement(conn, this.deleteStmt, false);
        try {
            ps.setString(1, class_name);
            this.storeMgr.executeStatementUpdate(this.deleteStmt, ps);
        }
        finally {
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllClasses(Connection conn) throws SQLException {
        PreparedStatement ps = this.storeMgr.getStatement(conn, this.deleteAllStmt, false);
        try {
            this.storeMgr.executeStatementUpdate(this.deleteAllStmt, ps);
        }
        finally {
            ps.close();
        }
    }

    private boolean tableExists(Connection conn) throws SQLException {
        try {
            return this.exists(conn, false);
        }
        catch (MissingTableException mte) {
            return false;
        }
    }

    public JavaTypeMapping getFieldMapping(AbstractPropertyMetaData fmd) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

