/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.jdo.JDOUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.exceptions.NoTableManagedException;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.key.CandidateKey;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.Index;
import org.jpox.store.rdbms.table.ColumnCreator;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.rdbms.table.SCOTable;
import org.jpox.store.rdbms.table.TableUtils;

public abstract class ElementContainerTable
extends JoinTable
implements SCOTable {
    protected JavaTypeMapping elementMapping;
    protected JavaTypeMapping orderMapping;
    protected JavaTypeMapping relationDiscriminatorMapping;
    protected String relationDiscriminatorValue;
    static /* synthetic */ Class class$java$lang$String;

    public ElementContainerTable(DatastoreIdentifier tableName, AbstractPropertyMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, fmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        AbstractPropertyMetaData relatedFmd = this.fmd.getRelatedFieldMetaData(clr);
        ColumnMetaData[] columnMetaData = null;
        if (this.fmd.getJoinMetaData() != null && this.fmd.getJoinMetaData().getColumnMetaData() != null && this.fmd.getJoinMetaData().getColumnMetaData().length > 0) {
            columnMetaData = this.fmd.getJoinMetaData().getColumnMetaData();
        } else if (relatedFmd != null && relatedFmd.getElementMetaData() != null && relatedFmd.getElementMetaData().getColumnMetaData() != null && relatedFmd.getElementMetaData().getColumnMetaData().length > 0) {
            columnMetaData = relatedFmd.getElementMetaData().getColumnMetaData();
        }
        boolean pkRequired = this.requiresPrimaryKey();
        this.ownerMapping = ColumnCreator.createColumnsForJoinTables(clr.classForName(this.ownerType), this.fmd, columnMetaData, this.storeMgr, this, pkRequired, false, false, false, 1, clr, null, false);
        if (this.fmd.hasExtension("relation-discriminator-column") || this.fmd.hasExtension("relation-discriminator-value")) {
            String colName = this.fmd.getValueForExtension("relation-discriminator-column");
            if (colName == null) {
                colName = "RELATION_DISCRIM";
            }
            ColumnMetaData colmd = new ColumnMetaData(null, colName);
            boolean relationDiscriminatorPk = false;
            if (this.fmd.hasExtension("relation-discriminator-pk") && this.fmd.getValueForExtension("relation-discriminator-pk").equalsIgnoreCase("true")) {
                relationDiscriminatorPk = true;
            }
            if (!relationDiscriminatorPk) {
                colmd.setAllowsNull(Boolean.TRUE);
            }
            this.relationDiscriminatorMapping = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = ElementContainerTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
            ColumnCreator.createAdapterColumn(this.relationDiscriminatorMapping, this.storeMgr, clr, this, colmd, relationDiscriminatorPk);
            this.relationDiscriminatorValue = this.fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = this.fmd.getFullFieldName();
            }
        }
    }

    public abstract String getElementType();

    protected void applyUserPrimaryKeySpecification(PrimaryKeyMetaData pkmd) {
        ColumnMetaData[] pkCols = pkmd.getColumnMetaData();
        for (int i = 0; i < pkCols.length; ++i) {
            int j;
            String colName = pkCols[i].getName();
            boolean found = false;
            for (j = 0; j < this.ownerMapping.getNumberOfDatastoreFields(); ++j) {
                if (!this.ownerMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().getIdentifier().equals(colName)) continue;
                this.ownerMapping.getDataStoreMapping(j).getDatastoreField().setAsPrimaryKey();
                found = true;
            }
            if (!found) {
                for (j = 0; j < this.elementMapping.getNumberOfDatastoreFields(); ++j) {
                    if (!this.elementMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier().getIdentifier().equals(colName)) continue;
                    this.elementMapping.getDataStoreMapping(j).getDatastoreField().setAsPrimaryKey();
                    found = true;
                }
            }
            if (found) continue;
            throw new JDOUserException(LOCALISER.msg("RDBMS.Table.PrimaryKeyColumnNotFound", this.toString(), colName));
        }
    }

    public JavaTypeMapping getFieldMapping(AbstractPropertyMetaData fmd) {
        return null;
    }

    public JavaTypeMapping getElementMapping() {
        this.assertIsInitialized();
        return this.elementMapping;
    }

    public JavaTypeMapping getOrderMapping() {
        this.assertIsInitialized();
        return this.orderMapping;
    }

    public JavaTypeMapping getRelationDiscriminatorMapping() {
        this.assertIsInitialized();
        return this.relationDiscriminatorMapping;
    }

    public String getRelationDiscriminatorValue() {
        this.assertIsInitialized();
        return this.relationDiscriminatorValue;
    }

    protected ForeignKey getForeignKeyToOwner(DatastoreClass ownerTable, boolean autoMode) {
        ForeignKey fk = null;
        if (ownerTable != null) {
            ForeignKeyMetaData fkmd = null;
            if (this.fmd.getJoinMetaData() != null) {
                fkmd = this.fmd.getJoinMetaData().getForeignKeyMetaData();
            }
            if (fkmd != null || autoMode) {
                fk = new ForeignKey(this.ownerMapping, this.dba, ownerTable, true);
                fk.setForMetaData(fkmd);
            }
        }
        return fk;
    }

    protected ForeignKey getForeignKeyToElement(DatastoreClass elementTable, boolean autoMode, JavaTypeMapping m) {
        ForeignKey fk = null;
        if (elementTable != null) {
            ForeignKeyMetaData fkmd = this.fmd.getForeignKeyMetaData();
            if (fkmd == null && this.fmd.getElementMetaData() != null) {
                fkmd = this.fmd.getElementMetaData().getForeignKeyMetaData();
            }
            if (fkmd != null || autoMode) {
                fk = new ForeignKey(m, this.dba, elementTable, true);
                fk.setForMetaData(fkmd);
            }
        }
        return fk;
    }

    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        boolean autoMode = false;
        if (this.storeMgr.getPMFContext().getPmfConfiguration().getForeignKeyCreateMode() == "AUTO") {
            autoMode = true;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        try {
            ForeignKey fk;
            DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(this.ownerType, clr);
            if (referencedTable != null && (fk = this.getForeignKeyToOwner(referencedTable, autoMode)) != null) {
                foreignKeys.add(fk);
            }
            if (!(this.elementMapping instanceof SerialisedPCMapping)) {
                if (this.elementMapping instanceof EmbeddedElementPCMapping) {
                    EmbeddedElementPCMapping embMapping = (EmbeddedElementPCMapping)this.elementMapping;
                    for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                        ForeignKey fk2;
                        JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                        AbstractPropertyMetaData embFmd = embFieldMapping.getFieldMetaData();
                        if (this.storeMgr.getPMFContext().getTypeManager().isReferenceType(embFmd.getType()) && embFieldMapping instanceof ReferenceMapping) {
                            Collection fks = TableUtils.getForeignKeysForReferenceField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr);
                            foreignKeys.addAll(fks);
                            continue;
                        }
                        if (this.storeMgr.getMetaDataManager().getMetaDataForClass(embFmd.getType(), clr) == null || embFieldMapping.getNumberOfDatastoreFields() <= 0 || !(embFieldMapping instanceof PersistenceCapableMapping) || (fk2 = TableUtils.getForeignKeyForPCField(embFieldMapping, embFmd, autoMode, this.storeMgr, clr)) == null) continue;
                        foreignKeys.add(fk2);
                    }
                } else if (this.elementMapping instanceof ReferenceMapping) {
                    JavaTypeMapping[] implJavaTypeMappings = ((ReferenceMapping)this.elementMapping).getJavaTypeMapping();
                    for (int i = 0; i < implJavaTypeMappings.length; ++i) {
                        ForeignKey fk3;
                        JavaTypeMapping implMapping = implJavaTypeMappings[i];
                        if (this.storeMgr.getMetaDataManager().getMetaDataForClass(implMapping.getType(), clr) == null || implMapping.getNumberOfDatastoreFields() <= 0 || (referencedTable = this.storeMgr.getDatastoreClass(implMapping.getType(), clr)) == null || (fk3 = this.getForeignKeyToElement(referencedTable, autoMode, implMapping)) == null) continue;
                        foreignKeys.add(fk3);
                    }
                } else {
                    referencedTable = this.storeMgr.getDatastoreClass(this.getElementType(), clr);
                    if (referencedTable != null && (fk = this.getForeignKeyToElement(referencedTable, autoMode, this.elementMapping)) != null) {
                        foreignKeys.add(fk);
                    }
                }
            }
        }
        catch (NoTableManagedException e) {
            // empty catch block
        }
        return foreignKeys;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        Set indices = super.getExpectedIndices(clr);
        if (this.elementMapping instanceof EmbeddedElementPCMapping) {
            EmbeddedElementPCMapping embMapping = (EmbeddedElementPCMapping)this.elementMapping;
            for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                Index index;
                JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                IndexMetaData imd = embFieldMapping.getFieldMetaData().getIndexMetaData();
                if (imd == null || (index = TableUtils.getIndexForField(this, imd, embFieldMapping)) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    protected List getExpectedCandidateKeys() {
        List candidateKeys = super.getExpectedCandidateKeys();
        if (this.elementMapping instanceof EmbeddedElementPCMapping) {
            EmbeddedElementPCMapping embMapping = (EmbeddedElementPCMapping)this.elementMapping;
            for (int i = 0; i < embMapping.getNumberOfJavaTypeMappings(); ++i) {
                CandidateKey ck;
                JavaTypeMapping embFieldMapping = embMapping.getJavaTypeMapping(i);
                UniqueMetaData umd = embFieldMapping.getFieldMetaData().getUniqueMetaData();
                if (umd == null || (ck = TableUtils.getCandidateKeyForField(this, umd, embFieldMapping)) == null) continue;
                candidateKeys.add(ck);
            }
        }
        return candidateKeys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

