/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.sqlidentifier;

import java.util.Map;
import java.util.WeakHashMap;
import javax.jdo.JDOFatalInternalException;
import org.jpox.store.AbstractIdentifierFactory;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.exceptions.TooManyForeignKeysException;
import org.jpox.store.rdbms.exceptions.TooManyIndicesException;
import org.jpox.store.rdbms.sqlidentifier.CandidateKeyIdentifier;
import org.jpox.store.rdbms.sqlidentifier.ColumnIdentifier;
import org.jpox.store.rdbms.sqlidentifier.ForeignKeyIdentifier;
import org.jpox.store.rdbms.sqlidentifier.IndexIdentifier;
import org.jpox.store.rdbms.sqlidentifier.PrimaryKeyIdentifier;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.store.rdbms.sqlidentifier.SequenceIdentifier;
import org.jpox.store.rdbms.sqlidentifier.TableIdentifier;
import org.jpox.util.StringUtils;

public abstract class AbstractRDBMSIdentifierFactory
extends AbstractIdentifierFactory
implements RDBMSIdentifierFactory {
    protected Map tables = new WeakHashMap();
    protected Map columns = new WeakHashMap();
    protected Map foreignkeys = new WeakHashMap();
    protected Map indexes = new WeakHashMap();
    protected Map candidates = new WeakHashMap();
    protected Map primarykeys = new WeakHashMap();
    protected Map sequences = new WeakHashMap();
    protected Map references = new WeakHashMap();
    protected String wordSeparator = "_";
    protected RDBMSAdapter rdba = null;
    protected String defaultCatalogName = null;
    protected String defaultSchemaName = null;

    public AbstractRDBMSIdentifierFactory(DatastoreAdapter dba, String requiredCase, String defaultCatalog, String defaultSchema) {
        super(dba, requiredCase);
        this.rdba = (RDBMSAdapter)dba;
        this.defaultCatalogName = defaultCatalog;
        this.defaultSchemaName = defaultSchema;
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public String getIdentifierInAdapterCase(String identifier) {
        if (identifier == null) {
            return null;
        }
        StringBuffer id = new StringBuffer();
        if (!(this.identifierCase != 3 && this.identifierCase != 5 && this.identifierCase != 1 || identifier.startsWith(this.dba.getIdentifierQuoteString()))) {
            id.append(this.dba.getIdentifierQuoteString());
        }
        if (this.identifierCase == 2 || this.identifierCase == 3) {
            id.append(identifier.toLowerCase());
        } else if (this.identifierCase == 0 || this.identifierCase == 1) {
            id.append(identifier.toUpperCase());
        } else {
            id.append(identifier);
        }
        if (!(this.identifierCase != 3 && this.identifierCase != 5 && this.identifierCase != 1 || identifier.endsWith(this.dba.getIdentifierQuoteString()))) {
            id.append(this.dba.getIdentifierQuoteString());
        }
        return id.toString();
    }

    public DatastoreIdentifier newIdentifier(int identifierType, String name) {
        DatastoreIdentifier identifier = null;
        String key = JDBCUtils.getIdentifierNameStripped(name, this.rdba);
        if (identifierType == 0) {
            identifier = (DatastoreIdentifier)this.tables.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new TableIdentifier(this, sqlIdentifier);
                this.setCatalogSchemaForTable((TableIdentifier)identifier);
                this.tables.put(key, identifier);
            }
        } else if (identifierType == 1) {
            identifier = (DatastoreIdentifier)this.columns.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new ColumnIdentifier(this, sqlIdentifier);
                this.columns.put(key, identifier);
            }
        } else if (identifierType == 2) {
            identifier = (DatastoreIdentifier)this.foreignkeys.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new ForeignKeyIdentifier(this, sqlIdentifier);
                this.foreignkeys.put(key, identifier);
            }
        } else if (identifierType == 3) {
            identifier = (DatastoreIdentifier)this.indexes.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new IndexIdentifier(this, sqlIdentifier);
                this.indexes.put(key, identifier);
            }
        } else if (identifierType == 4) {
            identifier = (DatastoreIdentifier)this.candidates.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new CandidateKeyIdentifier(this, sqlIdentifier);
                this.candidates.put(key, identifier);
            }
        } else if (identifierType == 5) {
            identifier = (DatastoreIdentifier)this.primarykeys.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new PrimaryKeyIdentifier(this, sqlIdentifier);
                this.primarykeys.put(key, identifier);
            }
        } else if (identifierType == 6) {
            identifier = (DatastoreIdentifier)this.sequences.get(key);
            if (identifier == null) {
                String sqlIdentifier = this.generateIdentifierNameForJavaName(key);
                sqlIdentifier = AbstractRDBMSIdentifierFactory.truncate(sqlIdentifier, this.getMaxLengthForIdentifierType(identifierType));
                identifier = new SequenceIdentifier(this, sqlIdentifier);
                this.sequences.put(key, identifier);
            }
        } else {
            throw new JDOFatalInternalException("identifier type " + identifierType + " not supported by this factory method");
        }
        return identifier;
    }

    public DatastoreIdentifier newIdentifier(DatastoreIdentifier identifier, String suffix) {
        String newId = identifier.getIdentifier() + this.getWordSeparator() + suffix;
        if (identifier instanceof TableIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(0));
            TableIdentifier tableIdentifier = new TableIdentifier(this, newId);
            this.setCatalogSchemaForTable(tableIdentifier);
            return tableIdentifier;
        }
        if (identifier instanceof ColumnIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(1));
            return new ColumnIdentifier(this, newId);
        }
        if (identifier instanceof ForeignKeyIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(2));
            return new ForeignKeyIdentifier(this, newId);
        }
        if (identifier instanceof IndexIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(3));
            return new IndexIdentifier(this, newId);
        }
        if (identifier instanceof CandidateKeyIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(4));
            return new CandidateKeyIdentifier(this, newId);
        }
        if (identifier instanceof PrimaryKeyIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(5));
            return new PrimaryKeyIdentifier(this, newId);
        }
        if (identifier instanceof SequenceIdentifier) {
            newId = AbstractRDBMSIdentifierFactory.truncate(newId, this.getMaxLengthForIdentifierType(6));
            return new SequenceIdentifier(this, newId);
        }
        return null;
    }

    public DatastoreIdentifier newDatastoreContainerIdentifier(String identifierName) {
        String key = JDBCUtils.getIdentifierNameStripped(identifierName, this.dba);
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.tables.get(key);
        if (identifier == null) {
            String baseID = AbstractRDBMSIdentifierFactory.truncate(key, this.getMaxLengthForIdentifierType(0));
            identifier = new TableIdentifier(this, baseID);
            this.setCatalogSchemaForTable((TableIdentifier)identifier);
            this.tables.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newDatastoreFieldIdentifier(String identifierName) {
        String key = JDBCUtils.getIdentifierNameStripped(identifierName, this.dba);
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(key);
        if (identifier == null) {
            String baseID = AbstractRDBMSIdentifierFactory.truncate(key, this.getMaxLengthForIdentifierType(1));
            identifier = new ColumnIdentifier(this, baseID);
            this.columns.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newDatastoreFieldIdentifier(String javaName, boolean embedded, int fieldRole) {
        DatastoreIdentifier identifier = null;
        String key = "[" + (javaName == null ? "" : javaName) + "][" + embedded + "][" + fieldRole;
        identifier = (DatastoreIdentifier)this.columns.get(key);
        if (identifier == null) {
            if (fieldRole == -1) {
                String baseID = AbstractRDBMSIdentifierFactory.truncate(javaName, this.getMaxLengthForIdentifierType(1));
                identifier = new ColumnIdentifier(this, baseID);
            } else {
                String suffix = this.getColumnIdentifierSuffix(fieldRole, embedded);
                String datastoreID = this.generateIdentifierNameForJavaName(javaName);
                String baseID = AbstractRDBMSIdentifierFactory.truncate(datastoreID, this.getMaxLengthForIdentifierType(1) - suffix.length());
                identifier = new ColumnIdentifier(this, baseID + suffix);
            }
            this.columns.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newSequenceIdentifier(String sequenceName) {
        String key = sequenceName;
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.sequences.get(key);
        if (identifier == null) {
            String baseID = AbstractRDBMSIdentifierFactory.truncate(sequenceName, this.getMaxLengthForIdentifierType(6));
            identifier = new ColumnIdentifier(this, baseID);
            this.sequences.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newPrimaryKeyIdentifier(DatastoreContainerObject table) {
        DatastoreIdentifier identifier = null;
        String key = ((Object)table.getIdentifier()).toString();
        identifier = (DatastoreIdentifier)this.primarykeys.get(key);
        if (identifier == null) {
            String suffix = this.getWordSeparator() + "PK";
            int maxLength = this.getMaxLengthForIdentifierType(5);
            String baseID = AbstractRDBMSIdentifierFactory.truncate(((SQLIdentifier)table.getIdentifier()).getIdentifier(), maxLength - suffix.length());
            identifier = new PrimaryKeyIdentifier(this, baseID + suffix);
            this.primarykeys.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newCandidateKeyIdentifier(DatastoreContainerObject table, int seq) {
        DatastoreIdentifier identifier = null;
        String key = "[" + ((Object)table.getIdentifier()).toString() + "][" + seq + "]";
        identifier = (DatastoreIdentifier)this.candidates.get(key);
        if (identifier == null) {
            String suffix = this.getWordSeparator() + "U" + seq;
            int maxLength = this.getMaxLengthForIdentifierType(4);
            String baseID = AbstractRDBMSIdentifierFactory.truncate(((SQLIdentifier)table.getIdentifier()).getIdentifier(), maxLength - suffix.length());
            identifier = new CandidateKeyIdentifier(this, baseID + suffix);
            this.candidates.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newForeignKeyIdentifier(DatastoreContainerObject table, int seq) {
        DatastoreIdentifier identifier = null;
        String key = "[" + ((Object)table.getIdentifier()).toString() + "][" + seq + "]";
        identifier = (DatastoreIdentifier)this.foreignkeys.get(key);
        if (identifier == null) {
            String suffix = this.getWordSeparator() + "FK";
            if (seq < 10) {
                suffix = suffix + "" + (char)(48 + seq);
            } else if (seq < this.rdba.getMaxForeignKeys()) {
                suffix = suffix + Integer.toHexString(65 + seq);
            } else {
                throw new TooManyForeignKeysException(this.rdba, table.toString());
            }
            int maxLength = this.getMaxLengthForIdentifierType(2);
            String baseID = AbstractRDBMSIdentifierFactory.truncate(((SQLIdentifier)table.getIdentifier()).getIdentifier(), maxLength - suffix.length());
            identifier = new ForeignKeyIdentifier(this, baseID + suffix);
            this.foreignkeys.put(key, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newIndexIdentifier(DatastoreContainerObject table, boolean isUnique, int seq) {
        DatastoreIdentifier identifier = null;
        String key = "[" + ((Object)table.getIdentifier()).toString() + "][" + isUnique + "][" + seq + "]";
        identifier = (DatastoreIdentifier)this.indexes.get(key);
        if (identifier == null) {
            String suffix = this.getWordSeparator() + (isUnique ? "U" : "N");
            if (seq >= this.rdba.getMaxIndexes()) {
                throw new TooManyIndicesException(this.rdba, table.toString());
            }
            suffix = suffix + String.valueOf(48 + seq);
            int maxLength = this.getMaxLengthForIdentifierType(3);
            String baseID = AbstractRDBMSIdentifierFactory.truncate(((SQLIdentifier)table.getIdentifier()).getIdentifier(), maxLength - suffix.length());
            identifier = new IndexIdentifier(this, baseID + suffix);
            this.indexes.put(key, identifier);
        }
        return identifier;
    }

    protected abstract String getColumnIdentifierSuffix(int var1, boolean var2);

    protected abstract String generateIdentifierNameForJavaName(String var1);

    protected void setCatalogSchemaForTable(TableIdentifier identifier) {
        String catalogName = identifier.getCatalogName();
        String schemaName = identifier.getSchemaName();
        if (schemaName == null && catalogName == null) {
            if (this.rdba.supportsCatalogsInTableDefinitions()) {
                identifier.setCatalogName(this.defaultCatalogName);
            }
            if (this.rdba.supportsSchemasInTableDefinitions()) {
                identifier.setSchemaName(this.defaultSchemaName);
            }
        }
    }

    protected String[] getIdentifierNamePartsFromName(String name) {
        if (name != null) {
            String[] names = new String[3];
            if (name.indexOf(46) < 0) {
                names[0] = null;
                names[1] = null;
                names[2] = name;
            } else {
                String[] specifiedNameParts = StringUtils.split(name, ".");
                int currentPartIndex = specifiedNameParts.length - 1;
                names[2] = specifiedNameParts[currentPartIndex--];
                if (this.rdba.supportsSchemasInTableDefinitions() && currentPartIndex >= 0) {
                    names[1] = specifiedNameParts[currentPartIndex--];
                }
                if (this.rdba.supportsCatalogsInTableDefinitions() && currentPartIndex >= 0) {
                    names[0] = specifiedNameParts[currentPartIndex--];
                }
            }
            return names;
        }
        return null;
    }

    protected int getMaxLengthForIdentifierType(int identifierType) {
        if (identifierType == 0) {
            return this.rdba.getMaxTableNameLength();
        }
        if (identifierType == 1) {
            return this.rdba.getMaxColumnNameLength();
        }
        if (identifierType == 2) {
            return this.rdba.getMaxConstraintNameLength();
        }
        if (identifierType == 3) {
            return this.rdba.getMaxConstraintNameLength();
        }
        if (identifierType == 4) {
            return this.rdba.getMaxConstraintNameLength();
        }
        if (identifierType == 5) {
            return this.rdba.getMaxConstraintNameLength();
        }
        if (identifierType == 6) {
            return this.rdba.getMaxTableNameLength();
        }
        return -1;
    }
}

