/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUnsupportedOptionException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractSetStore;
import org.jpox.store.rdbms.table.MapTable;
import org.jpox.store.scostore.MapStore;
import org.jpox.util.SQLWarnings;

public class MapValueSetStore
extends AbstractSetStore {
    private final MapStore mapStore;
    private final JavaTypeMapping keyMapping;
    private final String findKeyStmt;
    private DatastoreIdentifier valueIdentifier;

    public MapValueSetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager(), clr);
        this.containerTable = mapTable;
        this.mapStore = mapStore;
        this.setName = "values";
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.elementMapping = mapTable.getValueMapping();
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        this.initialize(clr);
        this.findKeyStmt = this.getFindKeyStmt();
    }

    public MapValueSetStore(DatastoreClass valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr, AbstractPropertyMetaData fmd) {
        super(valueTable.getStoreManager(), clr);
        this.containerTable = valueTable;
        this.setName = "values";
        this.ownerFieldMetaData = fmd;
        this.ownerMapping = ownerMapping;
        this.keyMapping = null;
        this.elementMapping = valueMapping;
        this.mapStore = mapStore;
        this.initialize(clr);
        this.clearStmt = null;
        this.findKeyStmt = null;
    }

    private void initialize(ClassLoaderResolver clr) {
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        this.initialiseStatements();
        Class element_class = clr.classForName(this.elementType);
        this.emd = this.storeMgr.getPMFContext().getTypeManager().isReferenceType(element_class) ? this.storeMgr.getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr) : this.storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
        if (this.emd != null) {
            this.elementType = this.emd.getFullClassName();
            this.elementInfo = this.getElementInformationForClass();
        }
        this.valueIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "VALUE");
    }

    private String getFindKeyStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM) {
        ClassLoaderResolver clr = ownerSM.getPersistenceManager().getClassLoaderResolver();
        final Class elementCls = clr.classForName(this.elementType);
        QueryExpression stmt = null;
        if (this.emd != null && this.emd.getDiscriminatorStrategy() != null && this.emd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && this.containerTable instanceof DatastoreClass) {
            if (this.storeMgr.getPMFContext().getTypeManager().isReferenceType(clr.classForName(this.elementType))) {
                String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int j = 0; j < clsNames.length; ++j) {
                    cls[j] = clr.classForName(clsNames[j]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true).getQueryStatement();
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{elementCls}, true, this.storeMgr, true).getQueryStatement();
            }
            this.iterateUsingDiscriminator = true;
            DatastoreClass sourceTable = this.storeMgr.getDatastoreClass(this.elementType, clr);
            ScalarExpression sourceExpr = sourceTable.getIDMapping().newScalarExpression(stmt, stmt.getDefaultTableExpression());
            LogicSetExpression teTargetElement = stmt.newTableExpression(this.containerTable, this.valueIdentifier);
            ScalarExpression targetExpr = this.elementMapping.newScalarExpression(stmt, teTargetElement);
            stmt.innerJoin(sourceExpr, targetExpr, teTargetElement, true);
        } else {
            stmt = new UnionIteratorStatement(clr, elementCls, true, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                public JavaTypeMapping getMapping() {
                    return MapValueSetStore.this.elementMapping;
                }

                public Class getType() {
                    return elementCls;
                }

                public DatastoreContainerObject getDatastoreContainerObject() {
                    return MapValueSetStore.this.containerTable;
                }

                public boolean useJoin() {
                    return false;
                }
            }).getQueryStatement();
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        return stmt;
    }

    public boolean add(StateManager sm, Object element) {
        throw new UnsupportedOperationException("Cannot add to a map through its value set");
    }

    public boolean addAll(StateManager sm, Collection elements) {
        throw new UnsupportedOperationException("Cannot add to a map through its value set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(StateManager sm, Object element) {
        if (this.findKeyStmt == null) {
            throw new UnsupportedOperationException("Cannot remove from an inverse map through its value set");
        }
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        Object key = null;
        boolean keyExists = false;
        PersistenceManager pm = sm.getPersistenceManager();
        try {
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.findKeyStmt, true);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(pm, ps, element, jdbcPosition);
                    ResultSet rs = this.storeMgr.executeStatementQuery(this.findKeyStmt, ps);
                    try {
                        if (rs.next()) {
                            key = this.keyMapping.getObject(pm, rs, Mappings.getParametersIndex(1, this.keyMapping));
                            keyExists = true;
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException("Request failed to check if set contains an element: " + this.findKeyStmt, (Throwable)e);
        }
        if (keyExists) {
            this.mapStore.remove(sm, key);
            return true;
        }
        return false;
    }

    public boolean removeAll(StateManager sm, Collection elements) {
        throw new UnsupportedOperationException("Cannot remove elements from a map through its value set");
    }

    public void clear(StateManager sm) {
        if (this.clearStmt == null) {
            throw new UnsupportedOperationException("Cannot clear an inverse map through its value set");
        }
        super.clear(sm);
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        throw new JDOUnsupportedOptionException("Cannot query sets obtained by Map.values()");
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier setRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        throw new JDOUnsupportedOptionException("Cannot query sets obtained by Map.values()");
    }
}

