/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.RDBMSTransaction;
import org.jpox.store.rdbms.scostore.ElementContainerStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.scostore.ArrayStore;
import org.jpox.util.JPOXLogger;

public abstract class AbstractArrayStore
extends ElementContainerStore
implements ArrayStore {
    protected String addStmt;
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractArrayStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public List getArray(StateManager ownerSM) {
        Iterator iter = this.iterator(ownerSM);
        ArrayList elements = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            elements.add(obj);
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        HashSet dependentElements = null;
        if (this.ownerFieldMetaData.getArray().isDependentElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerSM);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        try {
            PersistenceManager pm = ownerSM.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(ownerSM, pm, ps, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
                    }
                    this.storeMgr.executeStatementUpdate(this.clearStmt, ps);
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.ClearRequestFailed", this.clearStmt), (Throwable)e);
        }
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getPersistenceManager().deletePersistentAll(dependentElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(StateManager ownerSM, Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return true;
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.validateElementForWriting(ownerSM, obj);
        }
        boolean modified = false;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        boolean batched = this.allowsBatching() && length > 1;
        try {
            PersistenceManager pm = ownerSM.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            PreparedStatement ps = this.storeMgr.getStatement(conn, this.addStmt, false);
            try {
                Object element = null;
                for (int i = 0; i < length; ++i) {
                    element = Array.get(array, i);
                    try {
                        modified = this.internalAdd(ownerSM, element, ps, batched, i);
                        continue;
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                        exceptions.add(sqle);
                        JPOXLogger.RDBMS.error(sqle);
                    }
                }
                if (batched && exceptions.size() == 0) {
                    int[] num = this.storeMgr.executeStatementBatch(this.addStmt, ps);
                    if (num == null) {
                        modified = false;
                    } else {
                        for (int i = 0; i < num.length; ++i) {
                            if (num[i] <= 0) continue;
                            modified = true;
                        }
                    }
                }
            }
            finally {
                ps.close();
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            exceptions.add(e);
            JPOXLogger.RDBMS.error(e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.addStmt);
            JPOXLogger.RDBMS.error(msg);
            throw new JDODataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), (Object)ownerSM.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int position) {
        this.validateElementForWriting(sm, element);
        boolean modified = false;
        try {
            PersistenceManager pm = sm.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            PreparedStatement ps = this.storeMgr.getStatement(conn, this.addStmt, false);
            try {
                modified = this.internalAdd(sm, element, ps, false, position);
            }
            finally {
                ps.close();
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.addStmt), (Throwable)e);
        }
        return modified;
    }

    protected boolean internalAdd(StateManager sm, Object element, PreparedStatement ps, boolean batched, int orderId) throws SQLException {
        boolean modified = false;
        PersistenceManager pm = sm.getPersistenceManager();
        int jdbcPosition = 1;
        jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
        jdbcPosition = this.populateElementInStatement(pm, ps, element, jdbcPosition);
        jdbcPosition = this.populateOrderInStatement(pm, ps, orderId, jdbcPosition);
        if (this.relationDiscriminatorMapping != null) {
            jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
        }
        if (batched) {
            ps.addBatch();
        } else {
            int num = this.storeMgr.executeStatementUpdate(this.addStmt, ps);
            if (num > 0) {
                modified = true;
            }
        }
        return modified;
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager ownerSM) {
        ArrayStoreIterator iter;
        QueryExpression stmt = this.getIteratorStatement(ownerSM);
        if (stmt == null) {
            throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.SCO.IteratorStatementIsNull"));
        }
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        PersistenceManager pm = ownerSM.getPersistenceManager();
        RDBMSTransaction tx = (RDBMSTransaction)pm.currentTransaction();
        String statement = stmt.toStatementText(tx.useUpdateLockOnFetch()).toString();
        if (statement == null) {
            throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.SCO.IteratorStatementIsNull"));
        }
        try {
            Connection conn = this.storeMgr.getConnection(pm, false, false);
            try {
                PreparedStatement ps = stmt.toStatementText(tx.useUpdateLockOnFetch()).prepareStatement(pm, conn);
                try {
                    ResultSet rs = this.storeMgr.executeStatementQuery(statement, ps);
                    try {
                        iter = new ArrayStoreIterator(ownerSM, rs, rof);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.IteratorRequestFailed", statement), (Throwable)e);
        }
        return iter;
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionRangeVar) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, collectionRangeVar, qs.getClassLoaderResolver());
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(collectionRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        stmt.select(collectionRangeVar, this.elementMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionRangeVar) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, collectionRangeVar, qs.getClassLoaderResolver());
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(collectionRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = AbstractArrayStore.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ArrayStoreIterator
    implements Iterator {
        private final PersistenceManager pm;
        private final Iterator delegate;
        private Object lastElement = null;

        public ArrayStoreIterator(StateManager sm, ResultSet rs, ResultObjectFactory rof) throws SQLException {
            this.pm = sm.getPersistenceManager();
            ArrayList<Object> results = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    Object nextElement;
                    int i;
                    int[] param;
                    if (AbstractArrayStore.this.elementsAreEmbedded || AbstractArrayStore.this.elementsAreSerialised) {
                        param = new int[AbstractArrayStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (AbstractArrayStore.this.elementMapping instanceof SerialisedPCMapping || AbstractArrayStore.this.elementMapping instanceof SerialisedReferenceMapping || AbstractArrayStore.this.elementMapping instanceof EmbeddedElementPCMapping) {
                            int ownerFieldNumber = -1;
                            if (AbstractArrayStore.this.containerTable != null) {
                                ownerFieldNumber = ((JoinTable)AbstractArrayStore.this.containerTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                            }
                            nextElement = AbstractArrayStore.this.elementMapping.getObject(this.pm, rs, param, sm, ownerFieldNumber);
                        } else {
                            nextElement = AbstractArrayStore.this.elementMapping.getObject(this.pm, rs, param);
                        }
                    } else if (AbstractArrayStore.this.elementMapping instanceof ReferenceMapping) {
                        param = new int[AbstractArrayStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        nextElement = AbstractArrayStore.this.elementMapping.getObject(this.pm, rs, param);
                    } else {
                        nextElement = rof.getObject(this.pm, rs, this.pm.getClassLoaderResolver().classForName(AbstractArrayStore.this.elementType));
                    }
                    results.add(nextElement);
                }
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
        }
    }
}

