/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOOptimisticVerificationException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.VersionStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.FetchStatement;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.VersionMapping;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.request.MappingStatementIndex;
import org.jpox.store.rdbms.request.Request;
import org.jpox.store.rdbms.table.AbstractClassTable;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class UpdateRequest
extends Request {
    private final String updateStmt;
    private final MappingCallbacks[] callbacks;
    private MappingStatementIndex mappingStatementIndex;
    private final int[] fieldsToBeProvided;
    private final int[] pkFieldsToBeProvided;
    private final AbstractPropertyMetaData[] fieldsWithRelatedObjects;
    private final int highestFieldNumber;
    private MappingStatementIndex versionMappingStatementIndex;
    private final String versionStmt;
    private final boolean versionChecks;
    private final int[] versionPkFieldsToBeProvided;

    public UpdateRequest(DatastoreClass table, AbstractPropertyMetaData[] reqFieldMetaData, Class cls, ClassLoaderResolver clr) {
        super(table);
        AbstractClassMetaData cmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(cls, clr);
        this.mappingStatementIndex = new MappingStatementIndex();
        UpdateMappingConsumer consumer = new UpdateMappingConsumer(clr, cmd);
        table.provideMappingsForFields(consumer, reqFieldMetaData, false);
        table.provideVersionMappings(consumer);
        table.providePrimaryKeyMappings(consumer);
        table.provideDatastoreIdMappings(consumer);
        this.updateStmt = consumer.getStatement();
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.pkFieldsToBeProvided = consumer.getPrimaryKeyFieldsToBeProvided();
        this.fieldsToBeProvided = consumer.getFieldsToBeProvided();
        this.fieldsWithRelatedObjects = consumer.getFieldsWithRelatedObjects();
        this.highestFieldNumber = consumer.getHighestFieldNumber();
        this.versionMappingStatementIndex = new MappingStatementIndex();
        VersionMappingConsumer consumerVersion = new VersionMappingConsumer(cmd);
        table.provideVersionMappings(consumerVersion);
        table.providePrimaryKeyMappings(consumerVersion);
        table.provideDatastoreIdMappings(consumerVersion);
        this.versionStmt = consumerVersion.getStatement();
        this.versionPkFieldsToBeProvided = consumerVersion.getPrimaryKeyFieldsToBeProvided();
        this.versionChecks = cmd.getVersionMetaData() != null && cmd.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (JPOXLogger.JDO.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Updating object " + StringUtils.toJVMIDString(sm.getObject()) + " of type " + sm.getObject().getClass().getName() + " in table " + this.table);
            JPOXLogger.JDO.debug(str);
        }
        if (this.updateStmt != null) {
            PersistenceManager pm = sm.getPersistenceManager();
            RDBMSManager storeMgr = (RDBMSManager)pm.getStoreManager();
            try {
                Connection conn = storeMgr.getConnection(pm, true, false);
                try {
                    PreparedStatement ps;
                    block33: {
                        if (pm.currentTransaction().getOptimistic() && this.versionStmt != null) {
                            ps = storeMgr.getStatement(conn, this.versionStmt, false);
                            try {
                                if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                                    this.table.getDataStoreObjectIdMapping().setObject(pm, ps, this.versionMappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                                } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                                    sm.provideFields(this.versionPkFieldsToBeProvided, new ParameterSetter(sm, ps, this.versionMappingStatementIndex.getPrimaryKeys(), true));
                                }
                                ResultSet rs = storeMgr.executeStatementQuery(this.versionStmt, ps);
                                try {
                                    if (rs.next()) {
                                        Object datastoreVersion = this.table.getVersionMapping().getObject(pm, rs, this.versionMappingStatementIndex.getVersion().getExpressionIndex());
                                        boolean passedVerification = true;
                                        if (this.versionChecks) {
                                            passedVerification = ((VersionMapping)this.table.getVersionMapping()).compareVersion(datastoreVersion, sm.getTransactionalVersion(sm.getObject()));
                                        }
                                        if (this.versionChecks && !passedVerification) {
                                            String msg = LOCALISER.msg("RDBMS.Request.OptimisticVersionMismatch", sm.getInternalObjectId(), ((Object)this.table).toString(), datastoreVersion, sm.getTransactionalVersion(sm.getObject()));
                                            JPOXLogger.RDBMS.error(msg);
                                            throw new JDOOptimisticVerificationException(msg, (Object)sm.getObject());
                                        }
                                        break block33;
                                    }
                                    String msg = LOCALISER.msg("RDBMS.Request.OptimisticVersionMissing", sm.getInternalObjectId(), ((Object)this.table).toString());
                                    JPOXLogger.RDBMS.error(msg);
                                    throw new JDOOptimisticVerificationException(msg, (Object)sm.getObject());
                                }
                                finally {
                                    rs.close();
                                }
                            }
                            finally {
                                ps.close();
                            }
                        }
                    }
                    ps = storeMgr.getStatement(conn, this.updateStmt, false);
                    try {
                        if (this.fieldsToBeProvided != null) {
                            sm.provideFields(this.fieldsToBeProvided, new ParameterSetter(sm, ps, this.mappingStatementIndex.getFields(), true));
                        }
                        if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                            this.table.getDataStoreObjectIdMapping().setObject(pm, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                        } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                            sm.provideFields(this.pkFieldsToBeProvided, new ParameterSetter(sm, ps, this.mappingStatementIndex.getPrimaryKeys(), true));
                        }
                        if (this.versionStmt != null) {
                            Object nextOptimisticVersion = ((VersionMapping)this.table.getVersionMapping()).getNextVersion(sm.getTransactionalVersion(sm.getObject()));
                            this.table.getVersionMapping().setObject(pm, ps, this.mappingStatementIndex.getVersion().getParameterIndex(), nextOptimisticVersion);
                            sm.setTransactionalVersion(nextOptimisticVersion);
                        }
                        storeMgr.executeStatementUpdate(this.updateStmt, ps);
                    }
                    finally {
                        ps.close();
                    }
                }
                finally {
                    storeMgr.releaseConnection(pm, conn);
                }
            }
            catch (SQLException e) {
                throw new JDODataStoreException("Update request failed: " + this.updateStmt, (Throwable)e);
            }
        }
        if (this.fieldsWithRelatedObjects != null && this.fieldsWithRelatedObjects.length > 0) {
            for (int i = 0; i < this.fieldsWithRelatedObjects.length; ++i) {
                this.updateRelatedObjectsForField(sm, this.fieldsWithRelatedObjects[i]);
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                this.callbacks[i].postUpdate(sm);
                continue;
            }
            catch (NotYetFlushedException e) {
                sm.updateFieldAfterInsert(e.getPersistenceCapable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRelatedObjectsForField(StateManager sm, AbstractPropertyMetaData fmd) {
        block28: {
            ClassLoaderResolver clr = sm.getPersistenceManager().getClassLoaderResolver();
            DatastoreClass refTable = sm.getStoreManager().getDatastoreClass(fmd.getTypeName(), clr);
            if (refTable == null) {
                throw new JDOException("Could not find table for for type " + fmd.getTypeName() + ". You should verify if the inheritance strategy is valid.");
            }
            AbstractPropertyMetaData refFmd = fmd.getRelatedFieldMetaData(clr);
            JavaTypeMapping refMapping = refTable.getFieldMapping(fmd.getMappedBy());
            PersistenceManager pm = sm.getPersistenceManager();
            RDBMSManager storeMgr = (RDBMSManager)pm.getStoreManager();
            try {
                Connection conn = storeMgr.getConnection(pm, true, false);
                try {
                    int j;
                    JavaTypeMapping refIdMapping = refFmd.getAbstractClassMetaData().getIdentityType() == IdentityType.DATASTORE ? refTable.getDataStoreObjectIdMapping() : refTable.getIDMapping();
                    StringBuffer clearLinkStmt = new StringBuffer("UPDATE " + ((Object)refTable).toString() + " SET ");
                    for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                        if (j > 0) {
                            clearLinkStmt.append(",");
                        }
                        clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                        clearLinkStmt.append(" =NULL ");
                    }
                    clearLinkStmt.append(" WHERE ");
                    for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                        if (j > 0) {
                            clearLinkStmt.append(" AND ");
                        }
                        clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().toString());
                        clearLinkStmt.append(" =? ");
                    }
                    if (sm.provideField(fmd.getAbsoluteFieldNumber()) != null) {
                        for (j = 0; j < refIdMapping.getNumberOfDatastoreFields(); ++j) {
                            clearLinkStmt.append(" AND ");
                            clearLinkStmt.append(refIdMapping.getDataStoreMapping(j).getDatastoreField().toString());
                            clearLinkStmt.append(" <>? ");
                        }
                    }
                    Statement ps = null;
                    try {
                        ps = storeMgr.getStatement(conn, clearLinkStmt.toString(), false);
                        refMapping.setObject(pm, ps, Mappings.getParametersIndex(1, refMapping), sm.getObject());
                        if (sm.provideField(fmd.getAbsoluteFieldNumber()) != null) {
                            StatementExpressionIndex[] indexes = new StatementExpressionIndex[this.highestFieldNumber];
                            StatementExpressionIndex index = new StatementExpressionIndex();
                            index.setMapping(refIdMapping);
                            int[] paramIndexes = new int[refIdMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < paramIndexes.length; ++i) {
                                paramIndexes[i] = refMapping.getNumberOfDatastoreFields() + 1 + i;
                            }
                            index.setParameterIndex(paramIndexes);
                            indexes[fmd.getAbsoluteFieldNumber()] = index;
                            sm.provideFields(new int[]{fmd.getAbsoluteFieldNumber()}, new ParameterSetter(sm, (PreparedStatement)ps, indexes, false));
                        }
                        storeMgr.executeStatementUpdate(clearLinkStmt.toString(), (PreparedStatement)ps);
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    if (sm.provideField(fmd.getAbsoluteFieldNumber()) == null) break block28;
                    ps = null;
                    try {
                        int j2;
                        StringBuffer newLinkStmt = new StringBuffer("UPDATE " + ((Object)refTable).toString() + " SET ");
                        for (j2 = 0; j2 < refMapping.getNumberOfDatastoreFields(); ++j2) {
                            if (j2 > 0) {
                                newLinkStmt.append(",");
                            }
                            newLinkStmt.append(refMapping.getDataStoreMapping(j2).getDatastoreField().getIdentifier());
                            newLinkStmt.append("=?");
                        }
                        newLinkStmt.append(" WHERE ");
                        for (j2 = 0; j2 < refIdMapping.getNumberOfDatastoreFields(); ++j2) {
                            if (j2 > 0) {
                                newLinkStmt.append(" AND ");
                            }
                            newLinkStmt.append(refIdMapping.getDataStoreMapping(j2).getDatastoreField().toString());
                            newLinkStmt.append("=?");
                        }
                        ps = storeMgr.getStatement(conn, newLinkStmt.toString(), false);
                        refMapping.setObject(pm, ps, Mappings.getParametersIndex(1, refMapping), sm.getObject());
                        StatementExpressionIndex[] indexes = new StatementExpressionIndex[this.highestFieldNumber];
                        StatementExpressionIndex index = new StatementExpressionIndex();
                        index.setMapping(refIdMapping);
                        int[] paramIndexes = new int[refIdMapping.getNumberOfDatastoreFields()];
                        for (int i = 0; i < paramIndexes.length; ++i) {
                            paramIndexes[i] = refMapping.getNumberOfDatastoreFields() + 1 + i;
                        }
                        index.setParameterIndex(paramIndexes);
                        indexes[fmd.getAbsoluteFieldNumber()] = index;
                        sm.provideFields(new int[]{fmd.getAbsoluteFieldNumber()}, new ParameterSetter(sm, (PreparedStatement)ps, indexes, false));
                        storeMgr.executeStatementUpdate(newLinkStmt.toString(), (PreparedStatement)ps);
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                finally {
                    storeMgr.releaseConnection(pm, conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JDODataStoreException("Update request failed", (Throwable)e);
            }
        }
    }

    private class VersionMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        boolean hasVersionMapping = false;
        int paramIndex = 1;
        int exprIndex = 1;
        List pkbp = new ArrayList();
        FetchStatement fetchStmt;
        private final AbstractClassMetaData cmd;

        public VersionMappingConsumer(AbstractClassMetaData cmd) {
            this.fetchStmt = new RDBMSFetchStatement(((AbstractClassTable)((Object)UpdateRequest.this.table)).getPrimaryDatastoreContainerObject());
            this.cmd = cmd;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                UpdateRequest.this.versionMappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highestFieldNumber]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractPropertyMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                StatementExpressionIndex sei = new StatementExpressionIndex();
                sei.setMapping(m);
                sei.setParameterIndex(parametersIndex);
                if (fmd.isPrimaryKey()) {
                    ((UpdateRequest)UpdateRequest.this).versionMappingStatementIndex.getPrimaryKeys()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        String condition = m.getDataStoreMapping(j).getDatastoreField().getIdentifier() + "=" + ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                        this.fetchStmt.andCondition(condition);
                        this.pkbp.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        ++this.paramIndex;
                    }
                }
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                this.hasVersionMapping = true;
                this.fetchStmt.select(m.getDataStoreMapping(0).getDatastoreField());
                UpdateRequest.this.versionMappingStatementIndex.getVersion().setMapping(m);
                UpdateRequest.this.versionMappingStatementIndex.getVersion().setExpressionIndex(new int[]{this.exprIndex++});
            } else if (mappingType == 2) {
                String condition = ((DatastoreField)UpdateRequest.this.key.getColumns().get(0)).getIdentifier() + "=? ";
                this.fetchStmt.andCondition(condition);
                int[] param = new int[]{this.paramIndex++};
                UpdateRequest.this.versionMappingStatementIndex.getDatastoreId().setParameterIndex(param);
            }
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }

        public String getStatement() {
            if (!this.hasVersionMapping) {
                return null;
            }
            return ((Object)this.fetchStmt).toString();
        }
    }

    private class UpdateMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        int paramIndex = 1;
        int highestFieldNumber = 0;
        List ftbp = new ArrayList();
        List mc = new ArrayList();
        List pkbp = new ArrayList();
        List fwro = new ArrayList();
        StringBuffer columnAssignments = new StringBuffer();
        Map assignedColumns = new HashMap();
        StringBuffer where = new StringBuffer();
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public UpdateMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd) {
            this.clr = clr;
            this.cmd = cmd;
        }

        public int getHighestFieldNumber() {
            return this.highestFieldNumber;
        }

        public void preConsumeMapping(int highest) {
            if (!this.initialized) {
                this.highestFieldNumber = highest;
                UpdateRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highest]);
                UpdateRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highest]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractPropertyMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                if (m.getNumberOfDatastoreFields() == 0 && m instanceof PersistenceCapableMapping) {
                    int relationType = fmd.getRelationType(this.clr);
                    if (relationType == 2) {
                        if (fmd.getMappedBy() != null) {
                            this.fwro.add(fmd);
                        }
                    } else if (relationType == 6) {
                        AbstractPropertyMetaData relatedFmd = fmd.getRelatedFieldMetaData(this.clr);
                        if (fmd.getJoinMetaData() != null || relatedFmd.getJoinMetaData() != null) {
                            // empty if block
                        }
                    }
                }
                StatementExpressionIndex sei = new StatementExpressionIndex();
                sei.setMapping(m);
                sei.setParameterIndex(parametersIndex);
                if (fmd.isPrimaryKey()) {
                    ((UpdateRequest)UpdateRequest.this).mappingStatementIndex.getPrimaryKeys()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (this.where.length() > 0) {
                            this.where.append(" AND ");
                        }
                        String condition = m.getDataStoreMapping(j).getDatastoreField().getIdentifier() + "=" + ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                        this.where.append(condition);
                        if (!this.pkbp.contains(abs_field_num)) {
                            this.pkbp.add(abs_field_num);
                        }
                        ++this.paramIndex;
                    }
                } else {
                    ((UpdateRequest)UpdateRequest.this).mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (!this.assignedColumns.containsKey(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString())) {
                            if (this.columnAssignments.length() > 0) {
                                this.columnAssignments.append(", ");
                            }
                            String param = ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                            this.columnAssignments.append(m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).append("=").append(param);
                            if (param.indexOf("?") > -1) {
                                if (!this.ftbp.contains(abs_field_num)) {
                                    this.ftbp.add(abs_field_num);
                                }
                                ++this.paramIndex;
                            }
                            this.assignedColumns.put(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString(), new Integer(fmd.getAbsoluteFieldNumber()));
                            continue;
                        }
                        parametersIndex[j] = (Integer)this.assignedColumns.get(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                String val = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                if (this.columnAssignments.length() > 0) {
                    this.columnAssignments.append(", ");
                }
                String condition = m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + val;
                this.columnAssignments.append(condition);
                UpdateRequest.this.mappingStatementIndex.getVersion().setMapping(m);
                int[] param = new int[]{this.paramIndex++};
                UpdateRequest.this.mappingStatementIndex.getVersion().setParameterIndex(param);
            } else if (mappingType == 2) {
                String condition = ((DatastoreField)UpdateRequest.this.key.getColumns().get(0)).getIdentifier() + "=? ";
                this.where.append(condition);
                int[] param = new int[]{this.paramIndex++};
                UpdateRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(param);
            }
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getFieldsToBeProvided() {
            int[] fieldsToBeProvided = new int[this.ftbp.size()];
            for (int i = 0; i < this.ftbp.size(); ++i) {
                fieldsToBeProvided[i] = (Integer)this.ftbp.get(i);
            }
            return fieldsToBeProvided;
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }

        public AbstractPropertyMetaData[] getFieldsWithRelatedObjects() {
            AbstractPropertyMetaData[] fieldsWithRelatedObjects = new AbstractPropertyMetaData[this.fwro.size()];
            for (int i = 0; i < this.fwro.size(); ++i) {
                fieldsWithRelatedObjects[i] = (AbstractPropertyMetaData)this.fwro.get(i);
            }
            return fieldsWithRelatedObjects;
        }

        public String getStatement() {
            if (this.columnAssignments.length() < 1) {
                return null;
            }
            return "UPDATE " + ((Object)UpdateRequest.this.table).toString() + " SET " + this.columnAssignments + " WHERE " + this.where;
        }
    }
}

