/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.state.ActivityState;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.mapping.InterfaceMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.VersionMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.request.Request;
import org.jpox.store.rdbms.table.SecondaryTable;
import org.jpox.store.rdbms.table.Table;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.StringUtils;

public class InsertRequest
extends Request {
    private static final int IDPARAMNUMBER = 1;
    private final MappingCallbacks[] callbacks;
    private final int[] fieldsToBeProvided;
    private final int[] pkfieldsToBeProvided;
    private final int[] fieldsToBeRetrieved;
    private final String insertStmt;
    private boolean hasAutoIncrementColumn = false;
    private StatementExpressionIndex[] statementExpressionIndex;
    private StatementExpressionIndex[] retrievedStatementExpressionIndex;
    private StatementExpressionIndex versionStatementExpressionIndex;
    private StatementExpressionIndex discriminatorStatementExpressionIndex;
    private StatementExpressionIndex[] externalFKStatementExpressionIndex;
    private StatementExpressionIndex[] externalFKDiscrimStatementExpressionIndex;
    private StatementExpressionIndex[] externalOrderStatementExpressionIndex;

    public InsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        super(table);
        AbstractClassMetaData cmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(cls, clr);
        InsertMappingConsumer consumer = new InsertMappingConsumer(clr, cmd, 1);
        table.provideDatastoreIdMappings(consumer);
        table.provideNonPrimaryKeyMappings(consumer);
        table.providePrimaryKeyMappings(consumer);
        table.provideVersionMappings(consumer);
        table.provideDiscriminatorMappings(consumer);
        table.provideExternalMappings(consumer, 5);
        table.provideExternalMappings(consumer, 6);
        table.provideExternalMappings(consumer, 4);
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.statementExpressionIndex = consumer.getStatementExpressionIndex();
        this.versionStatementExpressionIndex = consumer.getVersionStatementExpressionIndex();
        this.discriminatorStatementExpressionIndex = consumer.getDiscriminatorStatementExpressionIndex();
        this.externalFKStatementExpressionIndex = consumer.getExternalFKStatementExpressionIndex();
        this.externalFKDiscrimStatementExpressionIndex = consumer.getExternalFKDiscrimStatementExpressionIndex();
        this.externalOrderStatementExpressionIndex = consumer.getExternalOrderStatementExpressionIndex();
        this.pkfieldsToBeProvided = consumer.getPrimaryKeyFieldsToBeProvided();
        if (table.getIdentityType() == IdentityType.APPLICATION && this.pkfieldsToBeProvided.length < 1 && !this.hasAutoIncrementColumn) {
            throw new JDOFatalException(LOCALISER.msg("RDBMS.Request.InsertWithNoPrimaryKeyError", cmd.getFullClassName()));
        }
        this.fieldsToBeProvided = consumer.getFieldsToBeProvided();
        this.retrievedStatementExpressionIndex = consumer.getRetrievedStatementExpressionIndex();
        this.fieldsToBeRetrieved = consumer.getFieldsToBeRetrieved();
        this.insertStmt = consumer.getInsertStmt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (JPOXLogger.JDO.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Inserting object " + StringUtils.toJVMIDString(sm.getObject()) + " of type " + sm.getObject().getClass().getName() + " into table " + this.table);
            JPOXLogger.JDO.debug(str);
        }
        try {
            sm.changeActivityState(ActivityState.INSERTING, this.table);
            PersistenceManager pm = sm.getPersistenceManager();
            RDBMSManager storeMgr = (RDBMSManager)pm.getStoreManager();
            Connection conn = storeMgr.getConnection(pm, true, false);
            try {
                PreparedStatement ps = storeMgr.getStatement(conn, this.insertStmt, false);
                try {
                    int i;
                    int i2;
                    if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                        if (!this.table.isObjectIDDatastoreAttributed() || !this.table.isBaseDatastoreClass()) {
                            int[] paramNumber = new int[]{1};
                            this.table.getDataStoreObjectIdMapping().setObject(pm, ps, paramNumber, sm.getInternalObjectId());
                        }
                    } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                        sm.provideFields(this.pkfieldsToBeProvided, new ParameterSetter(sm, ps, this.statementExpressionIndex, true));
                    }
                    int numberOfFieldsToProvide = 0;
                    for (int i3 = 0; i3 < this.fieldsToBeProvided.length; ++i3) {
                        if (this.fieldsToBeProvided[i3] >= sm.getHighestFieldNumber()) continue;
                        ++numberOfFieldsToProvide;
                    }
                    int j = 0;
                    int[] classFieldNumbers = new int[numberOfFieldsToProvide];
                    for (i2 = 0; i2 < this.fieldsToBeProvided.length; ++i2) {
                        if (this.fieldsToBeProvided[i2] < sm.getHighestFieldNumber()) {
                            classFieldNumbers[j++] = this.fieldsToBeProvided[i2];
                            continue;
                        }
                        StatementExpressionIndex stmtExprIndex = this.statementExpressionIndex[this.fieldsToBeProvided[i2]];
                        stmtExprIndex.getMapping().setDefault(pm, ps, stmtExprIndex.getParameterIndex());
                    }
                    sm.provideFields(classFieldNumbers, new ParameterSetter(sm, ps, this.statementExpressionIndex, true));
                    if (this.table.getVersionMapping() != null) {
                        Object nextOptimisticVersion = ((VersionMapping)this.table.getVersionMapping()).getNextVersion(sm.getVersion(sm.getObject()));
                        this.table.getVersionMapping().setObject(pm, ps, this.versionStatementExpressionIndex.getParameterIndex(), nextOptimisticVersion);
                        sm.setTransactionalVersion(nextOptimisticVersion);
                    }
                    if (this.table.getDiscriminatorMapping() != null) {
                        DiscriminatorMetaData dismd = this.table.getDiscriminatorMetaData();
                        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                            this.table.getDiscriminatorMapping().setObject(pm, ps, this.discriminatorStatementExpressionIndex.getParameterIndex(), sm.getObject().getClass().getName());
                        } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                            dismd = sm.getClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData();
                            this.table.getDiscriminatorMapping().setObject(pm, ps, this.discriminatorStatementExpressionIndex.getParameterIndex(), dismd.getValue());
                        }
                    }
                    if (this.externalFKStatementExpressionIndex != null) {
                        for (i2 = 0; i2 < this.externalFKStatementExpressionIndex.length; ++i2) {
                            Object fkValue = sm.getValueForExternalField(this.externalFKStatementExpressionIndex[i2].getMapping());
                            if (fkValue != null) {
                                AbstractPropertyMetaData ownerFmd = this.table.getMetaDataForExternalMapping(this.externalFKStatementExpressionIndex[i2].getMapping(), 5);
                                this.externalFKStatementExpressionIndex[i2].getMapping().setObject(pm, ps, this.externalFKStatementExpressionIndex[i2].getParameterIndex(), fkValue, null, ownerFmd.getAbsoluteFieldNumber());
                                continue;
                            }
                            this.externalFKStatementExpressionIndex[i2].getMapping().setObject(pm, ps, this.externalFKStatementExpressionIndex[i2].getParameterIndex(), null);
                        }
                    }
                    if (this.externalFKDiscrimStatementExpressionIndex != null) {
                        for (i2 = 0; i2 < this.externalFKDiscrimStatementExpressionIndex.length; ++i2) {
                            Object discrimValue = sm.getValueForExternalField(this.externalFKDiscrimStatementExpressionIndex[i2].getMapping());
                            this.externalFKDiscrimStatementExpressionIndex[i2].getMapping().setObject(pm, ps, this.externalFKDiscrimStatementExpressionIndex[i2].getParameterIndex(), discrimValue);
                        }
                    }
                    if (this.externalOrderStatementExpressionIndex != null) {
                        for (i2 = 0; i2 < this.externalOrderStatementExpressionIndex.length; ++i2) {
                            Object orderValue = sm.getValueForExternalField(this.externalOrderStatementExpressionIndex[i2].getMapping());
                            if (orderValue == null) {
                                orderValue = new Integer(-1);
                            }
                            this.externalOrderStatementExpressionIndex[i2].getMapping().setObject(pm, ps, this.externalOrderStatementExpressionIndex[i2].getParameterIndex(), orderValue);
                        }
                    }
                    storeMgr.executeStatementUpdate(this.insertStmt, ps);
                    if (this.hasAutoIncrementColumn) {
                        Object newId = null;
                        if (((RDBMSAdapter)pm.getStoreManager().getDatastoreAdapter()).supportsStatementGetGeneratedKeys() && JavaUtils.isJRE1_4OrAbove()) {
                            ResultSet rs = null;
                            try {
                                rs = ps.getGeneratedKeys();
                                if (rs != null && rs.next()) {
                                    newId = rs.getObject(1);
                                }
                            }
                            catch (Throwable e) {
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        if (newId == null) {
                            String tableName = ((Object)this.table.getIdentifier()).toString();
                            String columnName = null;
                            JavaTypeMapping idMapping = this.table.getIDMapping();
                            if (idMapping != null) {
                                for (int i4 = 0; i4 < idMapping.getNumberOfDatastoreFields(); ++i4) {
                                    Column col = (Column)idMapping.getDataStoreMapping(i4).getDatastoreField();
                                    if (!col.isAutoIncrement()) continue;
                                    columnName = ((Object)col.getIdentifier()).toString();
                                    break;
                                }
                            }
                            String autoIncStmt = ((RDBMSAdapter)pm.getStoreManager().getDatastoreAdapter()).getAutoIncrementStmt(tableName, columnName);
                            PreparedStatement psAutoIncrement = storeMgr.getStatement(conn, autoIncStmt, false);
                            ResultSet rs = null;
                            try {
                                rs = storeMgr.executeStatementQuery(autoIncStmt, psAutoIncrement);
                                if (rs.next()) {
                                    newId = rs.getObject(1);
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                                if (psAutoIncrement != null) {
                                    psAutoIncrement.close();
                                }
                            }
                        }
                        if (newId == null) {
                            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Request.InsertOfAutoincrementReturnedNullIdentity", this.table));
                        }
                        sm.setPostStoreNewObjectId(newId);
                    }
                    sm.changeActivityState(ActivityState.INSERTING_CALLBACKS, this.table);
                    int numberOfFieldsToRetrieve = 0;
                    for (i = 0; i < this.fieldsToBeRetrieved.length; ++i) {
                        if (this.fieldsToBeRetrieved[i] >= sm.getHighestFieldNumber()) continue;
                        ++numberOfFieldsToRetrieve;
                    }
                    classFieldNumbers = new int[numberOfFieldsToRetrieve];
                    j = 0;
                    for (i = 0; i < this.fieldsToBeRetrieved.length; ++i) {
                        if (this.fieldsToBeRetrieved[i] < sm.getHighestFieldNumber()) {
                            classFieldNumbers[j++] = this.fieldsToBeRetrieved[i];
                            continue;
                        }
                        StatementExpressionIndex stmtExprIndex = this.retrievedStatementExpressionIndex[this.fieldsToBeRetrieved[i]];
                        stmtExprIndex.getMapping().setDefault(pm, ps, stmtExprIndex.getParameterIndex());
                    }
                    sm.provideFields(classFieldNumbers, new ParameterSetter(sm, ps, this.retrievedStatementExpressionIndex, true));
                }
                finally {
                    ps.close();
                }
            }
            finally {
                storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException("Insert request failed: " + this.insertStmt, (Throwable)e);
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                this.callbacks[i].postInsert(sm);
                continue;
            }
            catch (NotYetFlushedException e) {
                sm.updateFieldAfterInsert(e.getPersistenceCapable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    private class InsertMappingConsumer
    implements MappingConsumer {
        List ftbp = new ArrayList();
        List pkbp = new ArrayList();
        List ftbr = new ArrayList();
        StringBuffer columnNames = new StringBuffer();
        StringBuffer columnValues = new StringBuffer();
        Map assignedColumns = new HashMap();
        List mc = new ArrayList();
        boolean initialized = false;
        int paramIndex;
        private StatementExpressionIndex[] statementExpressionIndex;
        private StatementExpressionIndex[] retrievedStatementExpressionIndex;
        private StatementExpressionIndex versionStatementExpressionIndex;
        private StatementExpressionIndex discriminatorStatementExpressionIndex;
        private StatementExpressionIndex[] externalFKStmtExprIndex;
        private StatementExpressionIndex[] externalFKDiscrimStmtExprIndex;
        private StatementExpressionIndex[] externalOrderStmtExprIndex;
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public InsertMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd, int initialParamIndex) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = initialParamIndex;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                this.statementExpressionIndex = new StatementExpressionIndex[highestFieldNumber];
                this.retrievedStatementExpressionIndex = new StatementExpressionIndex[highestFieldNumber];
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractPropertyMetaData fmd) {
            block14: {
                block15: {
                    int relationType;
                    block16: {
                        if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                            return;
                        }
                        if (!m.includeInInsertStatement()) break block14;
                        if (m.getNumberOfDatastoreFields() != 0 || !(m instanceof PersistenceCapableMapping) && !(m instanceof InterfaceMapping)) break block15;
                        this.retrievedStatementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                        this.retrievedStatementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
                        relationType = fmd.getRelationType(this.clr);
                        if (relationType != 2) break block16;
                        if (fmd.getMappedBy() != null) {
                            this.ftbr.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        }
                        break block14;
                    }
                    if (relationType != 6) break block14;
                    AbstractPropertyMetaData relatedFmd = fmd.getRelatedFieldMetaData(this.clr);
                    if (fmd.getJoinMetaData() == null && relatedFmd.getJoinMetaData() == null) break block14;
                    this.ftbr.add(new Integer(fmd.getAbsoluteFieldNumber()));
                    break block14;
                }
                this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                for (int j = 0; j < parametersIndex.length; ++j) {
                    Column c = (Column)m.getDataStoreMapping(j).getDatastoreField();
                    DatastoreIdentifier columnId = c.getIdentifier();
                    if (!this.assignedColumns.containsKey(((Object)columnId).toString())) {
                        if (InsertRequest.this.table instanceof SecondaryTable || !InsertRequest.this.table.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy()) && !c.isAutoIncrement() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                            if (this.columnNames.length() > 0) {
                                this.columnNames.append(',');
                                this.columnValues.append(',');
                            }
                            String param = ((RDBMSMapping)m.getDataStoreMapping(j)).getInsertionInputParameter();
                            this.columnNames.append(columnId);
                            this.columnValues.append(param);
                            if (param.indexOf("?") > -1) {
                                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                                if (fmd.isPrimaryKey()) {
                                    if (!this.pkbp.contains(abs_field_num)) {
                                        this.pkbp.add(abs_field_num);
                                    }
                                } else if (!this.ftbp.contains(abs_field_num)) {
                                    this.ftbp.add(abs_field_num);
                                }
                                ++this.paramIndex;
                            }
                            this.assignedColumns.put(((Object)c.getIdentifier()).toString(), new Integer(fmd.getAbsoluteFieldNumber()));
                        } else {
                            InsertRequest.this.hasAutoIncrementColumn = true;
                        }
                    } else {
                        parametersIndex[j] = (Integer)this.assignedColumns.get(((Object)c.getIdentifier()).toString());
                    }
                    this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                if (InsertRequest.this.table.getVersionMapping() != null) {
                    String val = ((RDBMSMapping)InsertRequest.this.table.getVersionMapping().getDataStoreMapping(0)).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(((Column)InsertRequest.this.table.getVersionMapping().getDataStoreMapping(0).getDatastoreField()).getIdentifier());
                    this.columnValues.append(val);
                    this.versionStatementExpressionIndex = new StatementExpressionIndex();
                    this.versionStatementExpressionIndex.setMapping(InsertRequest.this.table.getVersionMapping());
                    int[] param = new int[]{this.paramIndex++};
                    this.versionStatementExpressionIndex.setParameterIndex(param);
                } else {
                    this.versionStatementExpressionIndex = null;
                }
            } else if (mappingType == 3) {
                if (InsertRequest.this.table.getDiscriminatorMapping() != null) {
                    String val = ((RDBMSMapping)InsertRequest.this.table.getDiscriminatorMapping().getDataStoreMapping(0)).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(((Column)InsertRequest.this.table.getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField()).getIdentifier());
                    this.columnValues.append(val);
                    this.discriminatorStatementExpressionIndex = new StatementExpressionIndex();
                    this.discriminatorStatementExpressionIndex.setMapping(InsertRequest.this.table.getDiscriminatorMapping());
                    int[] param = new int[]{this.paramIndex++};
                    this.discriminatorStatementExpressionIndex.setParameterIndex(param);
                } else {
                    this.discriminatorStatementExpressionIndex = null;
                }
            } else if (mappingType == 2) {
                if (InsertRequest.this.table.getIdentityType() == IdentityType.DATASTORE) {
                    if (!InsertRequest.this.table.isObjectIDDatastoreAttributed() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                        Iterator iterator = InsertRequest.this.key.getColumns().iterator();
                        if (this.columnNames.length() > 0) {
                            this.columnNames.append(',');
                            this.columnValues.append(',');
                        }
                        this.columnNames.append(((Object)((Column)iterator.next()).getIdentifier()).toString());
                        this.columnValues.append("?");
                        ++this.paramIndex;
                    } else {
                        InsertRequest.this.hasAutoIncrementColumn = true;
                    }
                }
            } else if (mappingType == 5) {
                this.externalFKStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalFKStmtExprIndex);
            } else if (mappingType == 6) {
                this.externalFKDiscrimStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalFKDiscrimStmtExprIndex);
            } else if (mappingType == 4) {
                this.externalOrderStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalOrderStmtExprIndex);
            }
        }

        private StatementExpressionIndex[] processExternalMapping(JavaTypeMapping mapping, StatementExpressionIndex[] fieldStmtExprIndex, StatementExpressionIndex[] stmtExprIndex) {
            int i;
            for (int i2 = 0; i2 < fieldStmtExprIndex.length; ++i2) {
                if (fieldStmtExprIndex[i2] == null || fieldStmtExprIndex[i2].getMapping() != mapping) continue;
                return stmtExprIndex;
            }
            int pos = 0;
            if (stmtExprIndex == null) {
                stmtExprIndex = new StatementExpressionIndex[1];
                pos = 0;
            } else {
                for (int i3 = 0; i3 < stmtExprIndex.length; ++i3) {
                    if (stmtExprIndex[i3].getMapping() != mapping) continue;
                    return stmtExprIndex;
                }
                StatementExpressionIndex[] tmpStmtExprIndex = stmtExprIndex;
                stmtExprIndex = new StatementExpressionIndex[tmpStmtExprIndex.length + 1];
                for (i = 0; i < tmpStmtExprIndex.length; ++i) {
                    stmtExprIndex[i] = tmpStmtExprIndex[i];
                }
                pos = tmpStmtExprIndex.length;
            }
            stmtExprIndex[pos] = new StatementExpressionIndex();
            stmtExprIndex[pos].setMapping(mapping);
            int[] param = new int[mapping.getNumberOfDatastoreFields()];
            for (i = 0; i < mapping.getNumberOfDatastoreFields(); ++i) {
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(((Column)mapping.getDataStoreMapping(i).getDatastoreField()).getIdentifier());
                this.columnValues.append(((RDBMSMapping)mapping.getDataStoreMapping(i)).getUpdateInputParameter());
                ++this.paramIndex;
            }
            stmtExprIndex[pos].setParameterIndex(param);
            return stmtExprIndex;
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getFieldsToBeProvided() {
            int[] fieldsToBeProvided = new int[this.ftbp.size()];
            for (int i = 0; i < this.ftbp.size(); ++i) {
                fieldsToBeProvided[i] = (Integer)this.ftbp.get(i);
            }
            return fieldsToBeProvided;
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }

        public int[] getFieldsToBeRetrieved() {
            int[] fieldsToBeRetrieved = new int[this.ftbr.size()];
            for (int i = 0; i < this.ftbr.size(); ++i) {
                fieldsToBeRetrieved[i] = (Integer)this.ftbr.get(i);
            }
            return fieldsToBeRetrieved;
        }

        public StatementExpressionIndex[] getStatementExpressionIndex() {
            return this.statementExpressionIndex;
        }

        public StatementExpressionIndex[] getRetrievedStatementExpressionIndex() {
            return this.retrievedStatementExpressionIndex;
        }

        public StatementExpressionIndex getVersionStatementExpressionIndex() {
            return this.versionStatementExpressionIndex;
        }

        public StatementExpressionIndex getDiscriminatorStatementExpressionIndex() {
            return this.discriminatorStatementExpressionIndex;
        }

        public StatementExpressionIndex[] getExternalFKStatementExpressionIndex() {
            return this.externalFKStmtExprIndex;
        }

        public StatementExpressionIndex[] getExternalFKDiscrimStatementExpressionIndex() {
            return this.externalFKDiscrimStmtExprIndex;
        }

        public StatementExpressionIndex[] getExternalOrderStatementExpressionIndex() {
            return this.externalOrderStmtExprIndex;
        }

        public String getInsertStmt() {
            if (this.columnNames.length() > 0 && this.columnValues.length() > 0) {
                return "INSERT INTO " + ((Object)InsertRequest.this.table).toString() + " (" + this.columnNames + ") VALUES (" + this.columnValues + ")";
            }
            return ((RDBMSAdapter)InsertRequest.this.table.getStoreManager().getDatastoreAdapter()).getInsertStatementForNoColumns((Table)((Object)InsertRequest.this.table));
        }
    }
}

