/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import org.jpox.FetchPlanImpl;
import org.jpox.PersistenceManager;
import org.jpox.exceptions.ClassNotPersistenceCapableException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.IdentityType;
import org.jpox.store.DatastoreClass;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.query.QueryResult;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.query.BaseSQLQuery;
import org.jpox.store.rdbms.query.ForwardQueryResult;
import org.jpox.store.rdbms.query.InsensitiveQueryResult;
import org.jpox.store.rdbms.query.PersistentIDROF;
import org.jpox.util.StringUtils;

public final class SQLQuery
extends BaseSQLQuery {
    public SQLQuery(PersistenceManager pm, SQLQuery query) {
        super(pm, query);
    }

    public SQLQuery(PersistenceManager pm) {
        super(pm, (String)null);
    }

    public SQLQuery(PersistenceManager pm, String sql_text) {
        super(pm, sql_text);
        if (!(pm.getPMFContext().getPmfConfiguration().isQueryAllowAllSQLStatements() || this.sqlText.startsWith("SELECT") || this.sqlText.startsWith("select"))) {
            throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.StatementNotSelectError", this.sqlText));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SQLQuery) || !super.equals(obj)) {
            return false;
        }
        return this.sqlText.equals(((SQLQuery)obj).sqlText);
    }

    public void declareParameters(String parameters) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.ParametersInapplicableError"));
    }

    public void declareImports(String imports) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.ImportInapplicableError"));
    }

    protected void generateQueryStatement() {
        this.jdbcSqlText = this.sqlText;
        if (this.candidateClass != null) {
            AbstractClassMetaData cmd = this.pm.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.pm.getClassLoaderResolver());
            if (cmd == null) {
                throw new ClassNotPersistenceCapableException(this.candidateClass.getName());
            }
            if (cmd.getPersistenceCapableSuperclass() != null) {
                // empty if block
            }
            if (this.resultClass == null) {
                int i;
                String[] selectedColumns;
                String selections = this.sqlText.trim().substring(7);
                int fromStart = selections.indexOf("FROM");
                if (fromStart == -1) {
                    fromStart = selections.indexOf("from");
                }
                if ((selectedColumns = StringUtils.split(selections = selections.substring(0, fromStart).trim(), ",")) == null || selectedColumns.length == 0) {
                    throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.NoSelectionsError", this.sqlText));
                }
                if (selectedColumns.length == 1 && selectedColumns[0].trim().equals("*")) {
                    return;
                }
                DatastoreClass table = this.pm.getStoreManager().getDatastoreClass(this.candidateClass.getName(), this.pm.getClassLoaderResolver());
                PersistenceCapableMapping idMapping = (PersistenceCapableMapping)table.getIDMapping();
                String[] idColNames = new String[idMapping.getNumberOfDatastoreFields()];
                boolean[] idColMissing = new boolean[idMapping.getNumberOfDatastoreFields()];
                for (int i2 = 0; i2 < idMapping.getNumberOfDatastoreFields(); ++i2) {
                    DatastoreMapping m = idMapping.getDataStoreMapping(i2);
                    idColNames[i2] = ((Object)m.getDatastoreField().getIdentifier()).toString();
                    idColMissing[i2] = true;
                }
                String discriminatorColName = table.getDiscriminatorMapping() != null ? ((Object)table.getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
                String versionColName = table.getVersionMapping() != null ? ((Object)table.getVersionMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
                boolean discrimMissing = discriminatorColName != null;
                boolean versionMissing = true;
                if (versionColName == null) {
                    versionMissing = false;
                }
                AbstractClassMetaData candidateCmd = this.pm.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.pm.getClassLoaderResolver());
                for (i = 0; i < selectedColumns.length; ++i) {
                    String colName = selectedColumns[i].trim();
                    if (colName.indexOf(" AS ") > 0) {
                        colName = colName.substring(colName.indexOf(" AS ") + 4).trim();
                    } else if (colName.indexOf(" as ") > 0) {
                        colName = colName.substring(colName.indexOf(" as ") + 4).trim();
                    }
                    if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
                        if (this.columnNamesAreTheSame(idColNames[0], colName)) {
                            idColMissing[0] = false;
                        }
                    } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
                        for (int j = 0; j < idColNames.length; ++j) {
                            if (!this.columnNamesAreTheSame(idColNames[j], colName)) continue;
                            idColMissing[j] = false;
                        }
                    }
                    if (discrimMissing && this.columnNamesAreTheSame(discriminatorColName, colName)) {
                        discrimMissing = false;
                        continue;
                    }
                    if (!versionMissing || !this.columnNamesAreTheSame(versionColName, colName)) continue;
                    versionMissing = false;
                }
                if (discrimMissing) {
                    throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.Candidate.DiscriminatorColumnNotSelected", this.sqlText, this.candidateClass.getName(), discriminatorColName));
                }
                if (versionMissing) {
                    throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.Candidate.VersionColumnNotSelected", this.sqlText, this.candidateClass.getName(), versionColName));
                }
                for (i = 0; i < idColMissing.length; ++i) {
                    if (!idColMissing[i]) continue;
                    throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.Candidate.IdColumnNotSelected", this.sqlText, this.candidateClass.getName(), idColNames[i]));
                }
            }
        }
    }

    private boolean columnNamesAreTheSame(String name1, String name2) {
        return name1.equalsIgnoreCase(name2) || name1.equalsIgnoreCase(this.dba.getIdentifierQuoteString() + name2 + this.dba.getIdentifierQuoteString());
    }

    public Object executeWithArray(Object[] parameters) {
        this.isPreCompile = false;
        this.compile();
        this.parameterNames.clear();
        HashMap<Integer, Object> parameterMap = new HashMap<Integer, Object>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                String name = "" + (i + 1);
                this.parameterNames.add(name);
                parameterMap.put(new Integer(i + 1), parameters[i]);
            }
        }
        Object theReturn = super.executeWithMap(parameterMap);
        this.isPreCompile = true;
        return theReturn;
    }

    public Object executeWithMap(Map parameterMap) {
        this.isPreCompile = false;
        this.compile();
        this.parameterNames.clear();
        int numParamsExpected = 0;
        boolean complete = false;
        int position = 0;
        while (!complete) {
            int paramPos = this.jdbcSqlText.indexOf(63, position);
            if (paramPos < 0) {
                complete = true;
                continue;
            }
            position = paramPos + 1;
            ++numParamsExpected;
        }
        if (numParamsExpected > 0 && parameterMap == null) {
            throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.ParametersRequiredButNoneSupplied", this.jdbcSqlText, "" + numParamsExpected));
        }
        HashMap executeMap = new HashMap();
        if (parameterMap != null) {
            for (int i = 1; i < numParamsExpected + 1; ++i) {
                Integer key = new Integer(i);
                if (!parameterMap.containsKey(key)) {
                    throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.ParameterAtPositionNotSupplied", this.jdbcSqlText, "" + i));
                }
                executeMap.put(key, parameterMap.get(key));
                this.parameterNames.add("" + i);
            }
        }
        Object theReturn = super.executeWithMap(executeMap);
        this.isPreCompile = true;
        return theReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection performExecute(Map parameters) {
        QueryResult qr;
        block40: {
            this.compile();
            if (parameters.size() != this.parameterNames.size()) {
                throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.IncorrectNumberOfParametersError", "" + this.parameterNames.size(), "" + parameters.size()));
            }
            qr = null;
            try {
                RDBMSManager storeMgr = (RDBMSManager)this.pm.getStoreManager();
                Connection conn = storeMgr.getConnection(this.pm, false, true);
                try {
                    PreparedStatement ps = this.getStatement(conn, this.jdbcSqlText);
                    try {
                        if (parameters != null) {
                            for (int i = 0; i < parameters.size(); ++i) {
                                Object obj = parameters.get(new Integer(i + 1));
                                ps.setObject(i + 1, obj);
                            }
                        }
                        this.prepareStatementForExecution(ps);
                        ResultSet rs = storeMgr.executeStatementQuery(this.jdbcSqlText, ps);
                        try {
                            int i;
                            if (this.resultClass != null || this.candidateClass == null) {
                                qr = this.getQueryResultForNoCandidateClass(rs);
                                break block40;
                            }
                            AbstractClassMetaData candidateCmd = this.pm.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.pm.getClassLoaderResolver());
                            int fieldCount = candidateCmd.getNoOfManagedFields() + candidateCmd.getNoOfInheritedManagedFields();
                            HashMap<String, Integer> columnFieldNumberMap = new HashMap<String, Integer>();
                            this.statementExpressionIndex = new StatementExpressionIndex[fieldCount];
                            for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                                JavaTypeMapping m;
                                this.statementExpressionIndex[fieldNumber] = new StatementExpressionIndex();
                                AbstractPropertyMetaData fmd = candidateCmd.getManagedFieldAbsolute(fieldNumber);
                                String fieldName = fmd.getName();
                                Class fieldType = fmd.getType();
                                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.NONE || !(m = this.dba.getMapping(fieldType, this.getStoreManager(), this.pm.getClassLoaderResolver())).includeInFetchStatement()) continue;
                                this.statementExpressionIndex[fieldNumber].setMapping(m);
                                String columnName = null;
                                if (fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0) {
                                    for (int colNum = 0; colNum < fmd.getColumnMetaData().length; ++colNum) {
                                        columnName = fmd.getColumnMetaData()[colNum].getName();
                                        columnFieldNumberMap.put(columnName, new Integer(fieldNumber));
                                    }
                                    continue;
                                }
                                columnName = this.pm.getStoreManager().getIdentifierFactory().newDatastoreFieldIdentifier(fieldName, this.pm.getPMFContext().getTypeManager().isDefaultEmbeddedType(fieldType), 0).getIdentifier();
                                columnFieldNumberMap.put(columnName, new Integer(fieldNumber));
                            }
                            if (columnFieldNumberMap.size() == 0) {
                                throw new JDOFatalUserException("SQL query class has no persistent fields to SELECT : " + this.candidateClass.getName());
                            }
                            DatastoreClass table = this.pm.getStoreManager().getDatastoreClass(this.candidateClass.getName(), this.pm.getClassLoaderResolver());
                            PersistenceCapableMapping idMapping = (PersistenceCapableMapping)table.getIDMapping();
                            String[] idColNames = new String[idMapping.getNumberOfDatastoreFields()];
                            boolean[] idColMissing = new boolean[idMapping.getNumberOfDatastoreFields()];
                            for (int i2 = 0; i2 < idMapping.getNumberOfDatastoreFields(); ++i2) {
                                DatastoreMapping m = idMapping.getDataStoreMapping(i2);
                                idColNames[i2] = ((Object)m.getDatastoreField().getIdentifier()).toString();
                                idColMissing[i2] = true;
                            }
                            String discriminatorColName = table.getDiscriminatorMapping() != null ? ((Object)table.getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
                            String versionColName = table.getVersionMapping() != null ? ((Object)table.getVersionMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
                            boolean discrimMissing = discriminatorColName != null;
                            boolean versionMissing = true;
                            if (versionColName == null) {
                                versionMissing = false;
                            }
                            ResultSetMetaData rsmd = rs.getMetaData();
                            HashSet remainingColumnNames = new HashSet(columnFieldNumberMap.size());
                            int colCount = rsmd.getColumnCount();
                            int[] datastoreIndex = null;
                            int[] versionIndex = null;
                            int[] matchedFieldNumbers = new int[colCount];
                            int fieldNumberPosition = 0;
                            for (int colNum = 1; colNum <= colCount; ++colNum) {
                                String colName = rsmd.getColumnName(colNum);
                                int fieldNumber = -1;
                                Integer fieldNum = (Integer)columnFieldNumberMap.get(colName);
                                if (fieldNum != null) {
                                    fieldNumber = fieldNum;
                                }
                                if (fieldNumber >= 0) {
                                    int[] exprIndices = null;
                                    if (this.statementExpressionIndex[fieldNumber].getExpressionIndex() != null) {
                                        exprIndices = new int[this.statementExpressionIndex[fieldNumber].getExpressionIndex().length + 1];
                                        for (int i3 = 0; i3 < this.statementExpressionIndex[fieldNumber].getExpressionIndex().length; ++i3) {
                                            exprIndices[i3] = this.statementExpressionIndex[fieldNumber].getExpressionIndex()[i3];
                                        }
                                        exprIndices[exprIndices.length - 1] = colNum;
                                    } else {
                                        exprIndices = new int[]{colNum};
                                    }
                                    this.statementExpressionIndex[fieldNumber].setExpressionIndex(exprIndices);
                                    remainingColumnNames.remove(colName);
                                    matchedFieldNumbers[fieldNumberPosition++] = fieldNumber;
                                }
                                if (versionColName != null && colName.equals(versionColName)) {
                                    versionIndex = new int[]{colNum};
                                    versionMissing = false;
                                }
                                if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
                                    if (this.columnNamesAreTheSame(idColNames[0], colName)) {
                                        datastoreIndex = new int[]{colNum};
                                        idColMissing[0] = false;
                                    }
                                } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
                                    for (int j = 0; j < idColNames.length; ++j) {
                                        if (!this.columnNamesAreTheSame(idColNames[j], colName)) continue;
                                        idColMissing[j] = false;
                                    }
                                }
                                if (discrimMissing && this.columnNamesAreTheSame(discriminatorColName, colName)) {
                                    discrimMissing = false;
                                    continue;
                                }
                                if (!versionMissing || !this.columnNamesAreTheSame(versionColName, colName)) continue;
                                versionMissing = false;
                            }
                            int[] fieldNumbers = new int[fieldNumberPosition];
                            for (i = 0; i < fieldNumberPosition; ++i) {
                                fieldNumbers[i] = matchedFieldNumbers[i];
                            }
                            if (discrimMissing) {
                                throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.Candidate.DiscriminatorColumnNotSelected", this.sqlText, this.candidateClass.getName(), discriminatorColName));
                            }
                            if (versionMissing) {
                                throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.Candidate.VersionColumnNotSelected", this.sqlText, this.candidateClass.getName(), versionColName));
                            }
                            for (i = 0; i < idColMissing.length; ++i) {
                                if (!idColMissing[i]) continue;
                                throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.Candidate.IdColumnNotSelected", this.sqlText, this.candidateClass.getName(), idColNames[i]));
                            }
                            PersistentIDROF rof = new PersistentIDROF(table, fieldNumbers, candidateCmd, this.statementExpressionIndex, datastoreIndex, versionIndex, this.ignoreCache, false, false, (FetchPlanImpl)this.fetchPlan);
                            qr = this.getResultSetType().equals("scroll-insensitive") ? new InsensitiveQueryResult(null, this, rof, rs, null) : new ForwardQueryResult(null, this, rof, rs, null);
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (qr == null) {
                            ps.close();
                        }
                    }
                }
                finally {
                    storeMgr.releaseConnection(this.pm, conn);
                }
            }
            catch (SQLException e) {
                throw new JDODataStoreException(LOCALISER_RDBMS.msg("SQL.ExecutionError", this.jdbcSqlText), (Throwable)e);
            }
        }
        this.queryResults.add(qr);
        return qr;
    }
}

