/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.jdo.JDOUserException;
import org.jpox.PersistenceManager;
import org.jpox.store.query.Query;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.query.StatementText;
import org.jpox.util.TypeConversionHelper;

public abstract class RDBMSQuery
extends Query {
    public RDBMSQuery(PersistenceManager pm) {
        super(pm);
    }

    protected String getResultSetType() {
        String rsTypeString = this.pm.getPMFContext().getPmfConfiguration().getQueryResultSetType();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.query.resultSetType")) {
            rsTypeString = (String)this.extensions.get("org.jpox.query.resultSetType");
        }
        return rsTypeString;
    }

    protected String getResultSetConcurrency() {
        String rsConcurrencyString = this.pm.getPMFContext().getPmfConfiguration().getQueryResultSetConcurrency();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.query.resultSetConcurrency")) {
            rsConcurrencyString = (String)this.extensions.get("org.jpox.query.resultSetConcurrency");
        }
        return rsConcurrencyString;
    }

    protected PreparedStatement getStatement(Connection conn, String queryStmt) throws SQLException {
        String rsTypeString = this.getResultSetType();
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new JDOUserException("JDOQL extension for JPOX org.jpox.query.resultSetType has valid values of scroll-sensitive,scroll-insensitive,forward-only only.");
        }
        String rsConcurrencyString = this.getResultSetConcurrency();
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new JDOUserException("JDOQL extension for JPOX org.jpox.query.resultSetConcurrency has valid values of read-only,updateable only.");
        }
        RDBMSManager storeMgr = (RDBMSManager)this.pm.getStoreManager();
        PreparedStatement ps = storeMgr.getStatement(conn, queryStmt, true, rsTypeString, rsConcurrencyString);
        return ps;
    }

    protected PreparedStatement getStatement(Connection conn, StatementText stmtText) throws SQLException {
        String rsTypeString = this.getResultSetType();
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new JDOUserException("JDOQL extension for JPOX org.jpox.query.resultSetType has valid values of scroll-sensitive,scroll-insensitive,forward-only only.");
        }
        String rsConcurrencyString = this.getResultSetConcurrency();
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new JDOUserException("JDOQL extension for JPOX org.jpox.query.resultSetConcurrency has valid values of read-only,updateable only.");
        }
        PreparedStatement ps = stmtText.prepareStatement(this.pm, conn, rsTypeString, rsConcurrencyString);
        return ps;
    }

    protected void prepareStatementForExecution(PreparedStatement ps) throws SQLException {
        int timeout = this.pm.getPMFContext().getPmfConfiguration().getQueryTimeout();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.query.timeout")) {
            Object val = this.extensions.get("org.jpox.query.timeout");
            if (val instanceof Integer) {
                timeout = (Integer)val;
            } else if (val instanceof String) {
                timeout = TypeConversionHelper.intFromString((String)val, 0);
            }
        }
        if (timeout > 0) {
            ps.setQueryTimeout(timeout);
        }
        int fetchSize = this.pm.getPMFContext().getPmfConfiguration().getQueryFetchSize();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.query.fetchSize")) {
            Object val = this.extensions.get("org.jpox.query.fetchSize");
            if (val instanceof Integer) {
                fetchSize = (Integer)val;
            } else if (val instanceof String) {
                fetchSize = TypeConversionHelper.intFromString((String)val, 0);
            }
        }
        if (this.dba.supportsQueryFetchSizeLowerThanOne() && fetchSize < 1 || fetchSize > 0) {
            ps.setFetchSize(fetchSize);
        }
        String fetchDir = this.pm.getPMFContext().getPmfConfiguration().getQueryFetchDirection();
        if (this.extensions != null && this.extensions.containsKey("org.jpox.query.fetchDirection") && !(fetchDir = (String)this.extensions.get("org.jpox.query.fetchDirection")).equals("forward") && !fetchDir.equals("reverse") && !fetchDir.equals("unknown")) {
            throw new JDOUserException("Query extension for JPOX org.jpox.query.fetchDirection has valid values of forward,reverse,unknown only");
        }
        if (fetchDir.equals("reverse")) {
            ps.setFetchDirection(1001);
        } else if (fetchDir.equals("unknown")) {
            ps.setFetchDirection(1002);
        }
    }
}

