/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.AggregateExpression;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.BooleanLiteral;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.query.StatementText;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class QueryStatement
implements QueryExpression {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected final StoreManager storeMgr;
    protected final DatastoreAdapter dba;
    protected final DatastoreIdentifier defaultRangeVar;
    protected final LogicSetExpression initialTableExpr;
    protected Map tableExprsByRangeVar = new HashMap();
    protected boolean distinctResults = false;
    protected List selected = new ArrayList();
    protected List joins = new ArrayList();
    protected List union = new ArrayList();
    protected BooleanExpression whereExpr = null;
    protected List groupingExpressions = null;
    protected BooleanExpression havingExpr = null;
    protected ScalarExpression[] orderingExpressions = null;
    protected boolean[] orderingDirections = null;
    protected StatementText stmtText = null;
    private final ClassLoaderResolver clr;
    private QueryExpression parentQueryExpr;
    protected char stmtJoinsSeparator = (char)32;
    protected boolean hasAggregateExpression = false;
    protected List joinsTo = new ArrayList();
    protected List crossJoins = new ArrayList();
    protected boolean isExistsSubQuery = false;
    protected long rangeOffset = -1L;
    protected long rangeCount = -1L;
    protected boolean useInnerJoinsOnly = false;
    static /* synthetic */ Class class$java$lang$Integer;

    public QueryStatement(DatastoreContainerObject initialTable, ClassLoaderResolver clr) {
        this(initialTable, null, clr);
    }

    public QueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier initialRangeVar, ClassLoaderResolver clr) {
        this.storeMgr = initialTable.getStoreManager();
        this.dba = this.storeMgr.getDatastoreAdapter();
        this.clr = clr;
        this.defaultRangeVar = this.storeMgr.getIdentifierFactory().newIdentifier(0, "this");
        if (initialRangeVar != null) {
            this.initialTableExpr = this.newTableExpression(initialTable, initialRangeVar);
            this.tableExprsByRangeVar.put(initialRangeVar, this.initialTableExpr);
        } else {
            this.initialTableExpr = this.newTableExpression(initialTable, this.defaultRangeVar);
            this.tableExprsByRangeVar.put(this.defaultRangeVar, this.initialTableExpr);
        }
    }

    protected void assertNotFrozen() {
        if (this.stmtText != null) {
            throw new JDOFatalInternalException("A query statement cannot be modified after being output");
        }
    }

    public void reset() {
        if (this.stmtText == null) {
            return;
        }
        this.stmtText = null;
        for (int i = 0; i < this.union.size(); ++i) {
            ((QueryExpression)this.union.get(i)).reset();
        }
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    public LogicSetExpression getInitialTableExpr() {
        return this.initialTableExpr;
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    public LogicSetExpression getTableExpression(DatastoreIdentifier rangeVar) {
        return (LogicSetExpression)this.tableExprsByRangeVar.get(rangeVar);
    }

    public LogicSetExpression getDefaultTableExpression() {
        return this.getTableExpression(this.defaultRangeVar);
    }

    public LogicSetExpression newTableExpression(DatastoreContainerObject mainTable, DatastoreIdentifier rangeVar) {
        this.assertNotFrozen();
        LogicSetExpression te = (LogicSetExpression)this.tableExprsByRangeVar.get(rangeVar);
        if (te == null) {
            te = ((RDBMSAdapter)this.dba).newTableExpression(this, mainTable, rangeVar);
            this.tableExprsByRangeVar.put(rangeVar, te);
        } else if (!te.getMainTable().equals(mainTable)) {
            throw new JDOFatalInternalException(LOCALISER.msg("QueryStatement.RangeVariableInUse", rangeVar, this.toStatementText(false)));
        }
        return te;
    }

    public LogicSetExpression[] newTableExpression(DatastoreContainerObject mainTable, DatastoreIdentifier rangeVar, boolean unionQueries) {
        LogicSetExpression[] expr = unionQueries ? new LogicSetExpression[this.union.size() + 1] : new LogicSetExpression[1];
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = (QueryStatement)this.union.get(i);
                expr[i + 1] = qs.newTableExpression(mainTable, rangeVar);
            }
        }
        expr[0] = this.newTableExpression(mainTable, rangeVar);
        return expr;
    }

    public boolean getDistinctResults() {
        return this.distinctResults;
    }

    public void setDistinctResults(boolean distinctResults) {
        this.assertNotFrozen();
        this.distinctResults = distinctResults;
    }

    public void setExistsSubQuery(boolean isExistsSubQuery) {
        this.isExistsSubQuery = isExistsSubQuery;
        if (isExistsSubQuery && !((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsExistsSyntax()) {
            throw new JDOFatalInternalException(LOCALISER.msg("QueryStatement.SyntaxNotSupportedByDatastore", "EXISTS"));
        }
    }

    public void union(QueryExpression expr) {
        this.assertNotFrozen();
        this.union.add(expr);
    }

    public boolean getUseInnerJoinsOnly() {
        return this.useInnerJoinsOnly;
    }

    public void setUseInnerJoinsOnly(boolean innerJoins) {
        this.assertNotFrozen();
        this.useInnerJoinsOnly = innerJoins;
    }

    public synchronized int[] selectDatastoreIdentity(String alias, boolean unionQueries) {
        int[] index = this.selectDatastoreIdentity(alias);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = (QueryStatement)this.union.get(i);
                qs.selectDatastoreIdentity(alias);
            }
        }
        return index;
    }

    private synchronized int[] selectDatastoreIdentity(String alias) {
        if (!(this.initialTableExpr.getMainTable() instanceof DatastoreClass)) {
            return null;
        }
        DatastoreClass mainTable = (DatastoreClass)this.initialTableExpr.getMainTable();
        if (mainTable.getDataStoreObjectIdMapping() == null) {
            return null;
        }
        return this.select(this.defaultRangeVar, mainTable.getDataStoreObjectIdMapping(), alias);
    }

    public synchronized int[] selectVersion(String alias, boolean unionQueries) {
        int[] index = this.selectVersion(alias);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = (QueryStatement)this.union.get(i);
                qs.selectVersion(alias);
            }
        }
        return index;
    }

    private synchronized int[] selectField(String fieldName, String alias) {
        if (!(this.initialTableExpr.getMainTable() instanceof DatastoreClass)) {
            return null;
        }
        DatastoreClass mainTable = (DatastoreClass)this.initialTableExpr.getMainTable();
        JavaTypeMapping fieldMapping = mainTable.getFieldMapping(fieldName);
        if (fieldMapping == null) {
            return null;
        }
        return this.select(this.defaultRangeVar, fieldMapping, alias);
    }

    public synchronized int[] selectField(String fieldName, String alias, boolean unionQueries) {
        int[] index = this.selectField(fieldName, alias);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = (QueryStatement)this.union.get(i);
                qs.selectField(fieldName, alias);
            }
        }
        return index;
    }

    public synchronized int[] selectVersion(String alias) {
        if (!(this.initialTableExpr.getMainTable() instanceof DatastoreClass)) {
            return null;
        }
        DatastoreClass mainTable = (DatastoreClass)this.initialTableExpr.getMainTable();
        if (mainTable.getVersionMapping() == null) {
            return null;
        }
        return this.select(this.defaultRangeVar, mainTable.getVersionMapping(), alias);
    }

    public synchronized int[] select(JavaTypeMapping mapping) {
        int[] index = new int[mapping.getNumberOfDatastoreFields()];
        for (int i = 0; i < index.length; ++i) {
            FieldQueryExpression qe = this.getQueryExpression(this.defaultRangeVar, mapping.getDataStoreMapping(i).getDatastoreField(), null);
            index[i] = this.selectQueryExpression(qe);
        }
        return index;
    }

    public synchronized int[] select(JavaTypeMapping mapping, boolean unionQueries) {
        int[] index = this.select(mapping);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = (QueryStatement)this.union.get(i);
                qs.select(mapping);
            }
        }
        return index;
    }

    public synchronized int[] select(DatastoreIdentifier rangeVar, JavaTypeMapping mapping) {
        return this.select(rangeVar, mapping, null);
    }

    private synchronized int[] select(DatastoreIdentifier rangeVar, JavaTypeMapping mapping, String alias) {
        this.assertNotFrozen();
        int[] index = new int[mapping.getNumberOfDatastoreFields()];
        for (int i = 0; i < index.length; ++i) {
            String colAlias = alias;
            if (index.length > 1) {
                colAlias = colAlias + "_" + i;
            }
            index[i] = this.selectQueryExpression(this.getQueryExpression(rangeVar, mapping.getDataStoreMapping(i).getDatastoreField(), colAlias));
        }
        return index;
    }

    public synchronized int[] select(DatastoreIdentifier rangeVar, JavaTypeMapping mapping, boolean unionQueries) {
        int[] index = this.select(rangeVar, mapping);
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = (QueryStatement)this.union.get(i);
                qs.select(rangeVar, mapping, null);
            }
        }
        return index;
    }

    public int selectScalarExpression(ScalarExpression expr) {
        this.assertNotFrozen();
        if (expr instanceof AggregateExpression) {
            this.hasAggregateExpression = true;
        }
        String exprStr = expr.toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION);
        return this.selectItem(exprStr);
    }

    public int selectScalarExpression(ScalarExpression expr, boolean unionQueries) {
        this.assertNotFrozen();
        if (unionQueries) {
            for (int i = 0; i < this.union.size(); ++i) {
                QueryStatement qs = (QueryStatement)this.union.get(i);
                qs.selectScalarExpression(expr);
            }
        }
        return this.selectScalarExpression(expr);
    }

    private synchronized int selectQueryExpression(FieldQueryExpression queryExpr) {
        this.assertNotFrozen();
        String exprStr = queryExpr.toString();
        return this.selectItem(exprStr);
    }

    private int selectItem(String item) {
        if (this.selected.contains(item)) {
            return this.selected.indexOf(item) + 1;
        }
        int numberSelected = this.selected.size();
        for (int i = 0; i < numberSelected; ++i) {
            String selectedItem = (String)this.selected.get(i);
            if (selectedItem.startsWith(item + " ")) {
                return i + 1;
            }
            if (!item.startsWith(selectedItem + " ")) continue;
            this.selected.set(i, item);
            return i + 1;
        }
        this.selected.add(this.selected.size(), item);
        return this.selected.indexOf(item) + 1;
    }

    public int getNumberOfScalarExpressions() {
        return this.selected.size();
    }

    public boolean hasMetaDataExpression() {
        for (int i = 0; i < this.selected.size(); ++i) {
            if (!this.selected.get(i).toString().endsWith("JPOXMETADATA")) continue;
            return true;
        }
        return false;
    }

    private FieldQueryExpression getQueryExpression(DatastoreIdentifier rangeVar, DatastoreField col, String alias) {
        LogicSetExpression te = (LogicSetExpression)this.tableExprsByRangeVar.get(rangeVar);
        if (te == null) {
            throw new JDOFatalInternalException(LOCALISER.msg("QueryStatement.RangeVariableError", rangeVar));
        }
        return this.getQueryExpression(te, col, alias);
    }

    private FieldQueryExpression getQueryExpression(LogicSetExpression te, DatastoreField field, String alias) {
        return new FieldQueryExpression(te, field, alias);
    }

    private void crossJoin(LogicSetExpression tableExpr) {
        this.assertNotFrozen();
        if (this.hasCrossJoin(tableExpr) || this.initialTableExpr.equals(tableExpr)) {
            return;
        }
        this.crossJoins.add(tableExpr);
    }

    public boolean hasCrossJoin(LogicSetExpression tableExpr) {
        if (this.crossJoins.contains(tableExpr)) {
            return true;
        }
        for (int i = 0; i < this.joins.size(); ++i) {
            if (!((Join)this.joins.get(i)).tblExpr.equals(tableExpr)) continue;
            return true;
        }
        if (this.parentQueryExpr != null) {
            return this.parentQueryExpr.hasCrossJoin(tableExpr);
        }
        return false;
    }

    public void crossJoin(LogicSetExpression tableExpr, boolean unionQueries) {
        if (unionQueries) {
            Iterator i = this.union.iterator();
            while (i.hasNext()) {
                QueryStatement qs = (QueryStatement)i.next();
                qs.crossJoin(tableExpr);
            }
        }
        this.crossJoin(tableExpr);
    }

    public synchronized void join(ScalarExpression expr1, ScalarExpression expr2, LogicSetExpression tblExpr, int joinType, boolean equals, boolean unionQueries) {
        if (unionQueries) {
            Iterator i = this.union.iterator();
            while (i.hasNext()) {
                QueryStatement qs = (QueryStatement)i.next();
                qs.join(expr1, expr2, tblExpr, joinType, equals, unionQueries);
            }
        }
        this.join(expr1, expr2, tblExpr, joinType, equals);
    }

    public void join(ScalarExpression expr1, ScalarExpression expr2, LogicSetExpression tblExpr, int joinType, boolean equals) {
        this.assertNotFrozen();
        if (this.useInnerJoinsOnly) {
            joinType = 1;
        }
        Join join = new Join(joinType, expr1, expr2, tblExpr);
        if (joinType == 1) {
            if (tblExpr.equals(this.getInitialTableExpr())) {
                if (equals) {
                    this.andCondition(expr1.eq(expr2));
                } else {
                    this.andCondition(expr1.noteq(expr2));
                }
                return;
            }
            if (this.crossJoins.contains(tblExpr)) {
                if (equals) {
                    this.andCondition(expr1.eq(expr2));
                } else {
                    this.andCondition(expr1.noteq(expr2));
                }
                return;
            }
        }
        if (this.crossJoins.contains(tblExpr)) {
            if (equals) {
                this.andCondition(expr1.eq(expr2));
            } else {
                this.andCondition(expr1.noteq(expr2));
            }
            return;
        }
        if (this.initialTableExpr.equals(tblExpr)) {
            if (equals) {
                this.andCondition(expr1.eq(expr2));
            } else {
                this.andCondition(expr1.noteq(expr2));
            }
            return;
        }
        if (this.joinsTo.contains(tblExpr.getRangeVariable())) {
            return;
        }
        this.joinsTo.add(tblExpr.getRangeVariable());
        this.joins.add(join);
    }

    public synchronized void innerJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        this.join(expr, expr2, tblExpr, 1, equals, unionQueries);
    }

    public void innerJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        this.join(expr, expr2, tblExpr, 1, equals);
    }

    public synchronized void leftOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        this.join(expr, expr2, tblExpr, 2, equals, unionQueries);
    }

    public void leftOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        this.join(expr, expr2, tblExpr, 2, equals);
    }

    public synchronized void rightOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals, boolean unionQueries) {
        this.join(expr, expr2, tblExpr, 3, equals, unionQueries);
    }

    public void rightOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr, boolean equals) {
        this.join(expr, expr2, tblExpr, 3, equals);
    }

    private List sortJoins(List toSort) {
        List temp = this.internalSortJoins(toSort);
        return this.internalSortJoins(temp);
    }

    private List internalSortJoins(List toSort) {
        List temp = toSort;
        for (int i = 0; i < temp.size(); ++i) {
            Join join1;
            int j;
            Join join0 = (Join)temp.get(i);
            int index = i;
            boolean changed = false;
            if (!this.getInitialTableExpr().getRangeVariable().equals(join0.expr1.getLogicSetExpression().getRangeVariable())) {
                for (j = 0; j < temp.size(); ++j) {
                    join1 = (Join)temp.get(j);
                    if (join1 == join0 || !join1.tblExpr.getRangeVariable().equals(join0.expr1.getLogicSetExpression().getRangeVariable()) || changed) continue;
                    index = j;
                    changed = true;
                }
            }
            if (!this.getInitialTableExpr().getRangeVariable().equals(join0.expr2.getLogicSetExpression().getRangeVariable())) {
                for (j = 0; j < temp.size(); ++j) {
                    join1 = (Join)temp.get(j);
                    if (join1 == join0 || !join1.tblExpr.getRangeVariable().equals(join0.expr2.getLogicSetExpression().getRangeVariable()) || changed && index >= j) continue;
                    index = j;
                    changed = true;
                }
            }
            if (index == i) continue;
            temp.remove(i);
            temp.add(i < index ? index : index + 1, join0);
        }
        return temp;
    }

    public void andCondition(BooleanExpression condition, boolean unionQueries) {
        this.assertNotFrozen();
        this.andCondition(condition);
        if (!unionQueries) {
            return;
        }
        Iterator i = this.union.iterator();
        while (i.hasNext()) {
            QueryStatement qs = (QueryStatement)i.next();
            qs.andCondition(condition);
        }
    }

    public void andCondition(BooleanExpression condition) {
        this.assertNotFrozen();
        if (condition instanceof BooleanLiteral) {
            if (((Boolean)((BooleanLiteral)condition).getValue()).booleanValue()) {
                return;
            }
            JavaTypeMapping m = this.dba.getMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = QueryStatement.class$("java.lang.Integer")) : class$java$lang$Integer, this.storeMgr);
            condition = m.newLiteral(this, new Integer("1")).eq(m.newLiteral(this, new Integer("0")));
        }
        this.whereExpr = this.whereExpr == null ? condition : this.whereExpr.and(condition);
    }

    public void iorCondition(BooleanExpression condition, boolean unionQueries) {
        this.assertNotFrozen();
        this.iorCondition(condition);
        if (!unionQueries) {
            return;
        }
        Iterator i = this.union.iterator();
        while (i.hasNext()) {
            QueryStatement qs = (QueryStatement)i.next();
            qs.iorCondition(condition);
        }
    }

    public void iorCondition(BooleanExpression condition) {
        this.assertNotFrozen();
        if (condition instanceof BooleanLiteral) {
            if (condition.toStatementText(ScalarExpression.FILTER).equals("TRUE")) {
                return;
            }
            JavaTypeMapping m = this.dba.getMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = QueryStatement.class$("java.lang.Integer")) : class$java$lang$Integer, this.storeMgr);
            condition = m.newLiteral(this, new Integer("1")).eq(m.newLiteral(this, new Integer("0")));
        }
        this.whereExpr = this.whereExpr == null ? condition : this.whereExpr.ior(condition);
    }

    public void addGroupingExpression(ScalarExpression expr) {
        if (this.groupingExpressions == null) {
            this.groupingExpressions = new ArrayList();
        }
        this.groupingExpressions.add(expr);
        this.hasAggregateExpression = true;
    }

    public ScalarExpression[] getGroupingExpressions() {
        if (this.groupingExpressions == null) {
            return null;
        }
        return this.groupingExpressions.toArray(new ScalarExpression[this.groupingExpressions.size()]);
    }

    public void setHaving(BooleanExpression expr) {
        this.havingExpr = expr;
        this.hasAggregateExpression = true;
    }

    public BooleanExpression getHavingExpression() {
        return this.havingExpr;
    }

    public void setOrdering(ScalarExpression[] exprs, boolean[] descending) {
        this.assertNotFrozen();
        if (exprs.length != descending.length) {
            throw new JDOFatalInternalException(LOCALISER.msg("QueryStatement.OrderByExpressionInconsistency", "" + exprs.length, "" + descending.length));
        }
        this.orderingExpressions = exprs;
        this.orderingDirections = descending;
    }

    public ScalarExpression[] getOrderingExpressions() {
        return this.orderingExpressions;
    }

    public void setRangeConstraint(long offset, long count) {
        this.rangeOffset = offset;
        this.rangeCount = count;
    }

    public StatementText toDeleteStatementText() {
        if (this.stmtText == null) {
            this.stmtText = new StatementText("DELETE FROM ");
            this.stmtText.append(this.initialTableExpr.toString());
            Iterator iterator = this.crossJoins.iterator();
            while (iterator.hasNext()) {
                this.stmtText.append(this.dba.cartersianProduct((LogicSetExpression)iterator.next()));
            }
            iterator = this.joins.iterator();
            while (iterator.hasNext()) {
                this.stmtText.append(this.stmtJoinsSeparator).append(iterator.next().toString());
            }
            if (this.whereExpr != null) {
                this.stmtText.append(" WHERE ").append(this.whereExpr.toStatementText(ScalarExpression.FILTER), ScalarExpression.FILTER);
            }
            if (this.rangeOffset > -1L || this.rangeCount > -1L) {
                this.stmtText.append(((RDBMSAdapter)this.dba).getRangeByLimitWhereClause(this.rangeOffset, this.rangeCount));
            }
        }
        return this.stmtText;
    }

    protected void addOrderingColumnsToSelect() {
        boolean needsSelect;
        if (this.orderingExpressions != null && (needsSelect = ((RDBMSAdapter)this.dba).includeOrderByColumnsInSelect())) {
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExpr = "JPOXORDER" + i;
                Iterator iterator = this.union.iterator();
                while (iterator.hasNext()) {
                    QueryStatement qs = (QueryStatement)iterator.next();
                    if (this.hasAggregateExpression) {
                        qs.selectScalarExpression(this.orderingExpressions[i]);
                        continue;
                    }
                    qs.selectScalarExpression(this.orderingExpressions[i].as(orderExpr));
                }
                if (this.hasAggregateExpression) {
                    this.selectScalarExpression(this.orderingExpressions[i]);
                    continue;
                }
                this.selectScalarExpression(this.orderingExpressions[i].as(orderExpr));
            }
        }
    }

    protected StatementText generateOrderingStatement() {
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            orderByStmt = new StatementText();
            boolean needsSelect = ((RDBMSAdapter)this.dba).includeOrderByColumnsInSelect();
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExpr = "JPOXORDER" + i;
                if (i > 0) {
                    orderByStmt.append(',');
                }
                if (needsSelect && !this.hasAggregateExpression) {
                    orderByStmt.append(orderExpr);
                } else {
                    orderByStmt.append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION));
                }
                if (!this.orderingDirections[i]) continue;
                orderByStmt.append(" DESC");
            }
        }
        return orderByStmt;
    }

    public void setParent(QueryExpression parentQueryExpr) {
        this.parentQueryExpr = parentQueryExpr;
    }

    public StatementText toStatementText(boolean lock) {
        if (this.stmtText == null) {
            int i;
            this.addOrderingColumnsToSelect();
            RDBMSAdapter rdbmsAdapter = (RDBMSAdapter)this.dba;
            StatementText stmtText = new StatementText("SELECT ");
            if (this.rangeOffset > -1L || this.rangeCount > -1L) {
                if (rdbmsAdapter.getRangeByRowNumberColumn().length() > 0) {
                    stmtText.append(rdbmsAdapter.getRangeByRowNumberColumn() + " rn, ");
                } else {
                    stmtText.append(rdbmsAdapter.getRangeByLimitSelectClause(this.rangeOffset, this.rangeCount));
                }
            }
            boolean usingDistinct = false;
            if (!this.isExistsSubQuery) {
                if (this.distinctResults) {
                    stmtText.append("DISTINCT ");
                    usingDistinct = true;
                }
                Iterator iterator = this.selected.iterator();
                while (iterator.hasNext()) {
                    Object selectExpr = iterator.next();
                    stmtText.append(selectExpr.toString());
                    if (!iterator.hasNext()) continue;
                    stmtText.append(',');
                }
                if ((this.rangeOffset > -1L || this.rangeCount > -1L) && rdbmsAdapter.getRangeByRowNumberColumn().length() > 0) {
                    stmtText.append(',').append(rdbmsAdapter.getRangeByRowNumberColumn());
                }
            } else {
                JavaTypeMapping m = this.dba.getMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = QueryStatement.class$("java.lang.Integer")) : class$java$lang$Integer, this.storeMgr);
                stmtText.append(m.newLiteral(this, new Integer("1")).toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION));
            }
            List sorted = this.sortJoins(this.joins);
            Join[] sortedJoins = sorted.toArray(new Join[sorted.size()]);
            stmtText.append(" FROM ");
            ArrayList<LogicSetExpression> crossJoinss = new ArrayList<LogicSetExpression>();
            crossJoinss.add(this.initialTableExpr);
            crossJoinss.addAll(this.crossJoins);
            if (crossJoinss.size() == 1) {
                stmtText.append(crossJoinss.get(0).toString());
                if (lock && rdbmsAdapter.getSelectWithLockOption() != null && rdbmsAdapter.getPlaceWithOptionAfterFromClause()) {
                    stmtText.append(" WITH " + rdbmsAdapter.getSelectWithLockOption());
                }
                crossJoinss.remove(0);
            }
            for (i = 0; i < sortedJoins.length; ++i) {
                Join join = sortedJoins[i];
                for (int j = crossJoinss.size() - 1; j >= 0; --j) {
                    if (!sortedJoins[i].expr1.getLogicSetExpression().equals(crossJoinss.get(j)) && !sortedJoins[i].expr2.getLogicSetExpression().equals(crossJoinss.get(j))) continue;
                    if (i > 0) {
                        stmtText.append(this.dba.cartersianProduct((LogicSetExpression)crossJoinss.get(j)));
                    } else {
                        stmtText.append(crossJoinss.get(j).toString());
                    }
                    if (lock && rdbmsAdapter.getSelectWithLockOption() != null && rdbmsAdapter.getPlaceWithOptionAfterFromClause()) {
                        stmtText.append(" WITH " + rdbmsAdapter.getSelectWithLockOption());
                    }
                    crossJoinss.remove(j);
                    break;
                }
                stmtText.append(this.stmtJoinsSeparator).append(join.toString(rdbmsAdapter, lock));
            }
            crossJoinss.remove(null);
            for (i = 0; i < crossJoinss.size(); ++i) {
                if (sortedJoins.length > 0 || i > 0) {
                    stmtText.append(this.dba.cartersianProduct((LogicSetExpression)crossJoinss.get(i)));
                } else {
                    stmtText.append(crossJoinss.get(i).toString());
                }
                if (!lock || rdbmsAdapter.getSelectWithLockOption() == null || !rdbmsAdapter.getPlaceWithOptionAfterFromClause()) continue;
                stmtText.append(" WITH " + rdbmsAdapter.getSelectWithLockOption());
            }
            if (this.whereExpr != null) {
                stmtText.append(" WHERE ").append(this.whereExpr.toStatementText(ScalarExpression.FILTER), ScalarExpression.FILTER);
            }
            if (this.groupingExpressions != null) {
                ArrayList<String> groupBy = new ArrayList<String>();
                for (int i2 = 0; i2 < this.groupingExpressions.size(); ++i2) {
                    String exprText = ((ScalarExpression)this.groupingExpressions.get(i2)).toStatementText(ScalarExpression.PROJECTION).toString();
                    if (groupBy.contains(exprText)) continue;
                    groupBy.add(exprText);
                }
                if (groupBy.size() > 0 && this.hasAggregateExpression) {
                    stmtText.append(" GROUP BY ");
                    boolean first = true;
                    for (int i3 = 0; i3 < groupBy.size(); ++i3) {
                        if (!first) {
                            stmtText.append(',');
                        }
                        stmtText.append((String)groupBy.get(i3));
                        first = false;
                    }
                }
            }
            if (this.havingExpr != null) {
                stmtText.append(" HAVING ").append(this.havingExpr.toStatementText(ScalarExpression.FILTER), ScalarExpression.FILTER);
            }
            Iterator iterator = this.union.iterator();
            while (iterator.hasNext()) {
                if (!((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsUnionSyntax()) {
                    throw new JDOFatalInternalException(LOCALISER.msg("QueryStatement.SyntaxNotSupportedByDatastore", "UNION"));
                }
                if (rdbmsAdapter.useUnionAll()) {
                    stmtText.append(" UNION ALL ");
                } else {
                    stmtText.append(" UNION ");
                }
                QueryStatement qs = (QueryStatement)iterator.next();
                stmtText.append(qs.toStatementText(false), ScalarExpression.FILTER);
            }
            if (!this.isExistsSubQuery && this.orderingExpressions != null && this.orderingExpressions.length > 0) {
                StatementText orderByStmt = this.generateOrderingStatement();
                stmtText.append(" ORDER BY ").append(orderByStmt, ScalarExpression.PROJECTION);
            }
            if (this.rangeOffset > -1L || this.rangeCount > -1L) {
                stmtText.append(rdbmsAdapter.getRangeByLimitWhereClause(this.rangeOffset, this.rangeCount));
            }
            if (lock && rdbmsAdapter.supportsLockWithSelectForUpdate()) {
                if (usingDistinct && !rdbmsAdapter.supportsDistinctWithSelectForUpdate()) {
                    JPOXLogger.JDO_QUERY.warn(LOCALISER.msg("QueryStatement.DistinctWithForUpdateNotAllowedForRDBMS"));
                } else {
                    stmtText.append(" FOR UPDATE");
                }
            }
            if ((this.rangeOffset > -1L || this.rangeCount > -1L) && rdbmsAdapter.getRangeByRowNumberColumn().length() > 0) {
                StatementText innerQuery = stmtText;
                stmtText = new StatementText("SELECT ");
                iterator = this.selected.iterator();
                while (iterator.hasNext()) {
                    Object selectExpr = iterator.next();
                    stmtText.append("subq.");
                    String selectedCol = selectExpr.toString();
                    int dotIndex = selectedCol.indexOf(".");
                    if (dotIndex != -1) {
                        selectedCol = selectedCol.substring(dotIndex + 1);
                    }
                    stmtText.append(selectedCol);
                    if (!iterator.hasNext()) continue;
                    stmtText.append(',');
                }
                stmtText.append(" FROM (");
                stmtText.append(innerQuery, ScalarExpression.FILTER);
                stmtText.append(") subq");
                stmtText.append(" WHERE ");
                if (this.rangeOffset > -1L) {
                    stmtText.append("subq.rn").append(">=").append("" + this.rangeOffset);
                }
                if (this.rangeCount > -1L) {
                    if (this.rangeOffset > -1L) {
                        stmtText.append(" AND ");
                    }
                    stmtText.append("subq.rn").append("<").append("" + (this.rangeCount + this.rangeOffset));
                }
            }
            this.stmtText = stmtText;
        }
        return this.stmtText;
    }

    public String toString() {
        throw new JDOFatalInternalException("This method must not be called");
    }

    public String toString(boolean lock) {
        return this.toStatementText(lock).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Join {
        public static final int INNER_JOIN = 1;
        public static final int LEFT_OUTER_JOIN = 2;
        public static final int RIGHT_OUTER_JOIN = 3;
        private final int type;
        private final LogicSetExpression tblExpr;
        private final ScalarExpression expr1;
        private final ScalarExpression expr2;

        public Join(int type, ScalarExpression expr1, ScalarExpression expr2, LogicSetExpression tblExpr) {
            this.type = type;
            this.expr1 = expr1;
            this.expr2 = expr2;
            this.tblExpr = tblExpr;
        }

        public Join(ScalarExpression expr1, ScalarExpression expr2, LogicSetExpression tblExpr) {
            this.type = -1;
            this.expr1 = expr1;
            this.expr2 = expr2;
            this.tblExpr = tblExpr;
        }

        public String toString(RDBMSAdapter rdbmsAdapter, boolean lock) {
            if (this.type > 0) {
                StringBuffer result = new StringBuffer();
                if (this.type == 1) {
                    result.append("INNER JOIN");
                } else if (this.type == 2) {
                    result.append("LEFT OUTER JOIN");
                } else if (this.type == 3) {
                    result.append("RIGHT OUTER JOIN");
                }
                result.append(" " + this.tblExpr);
                if (lock && rdbmsAdapter.getPlaceWithOptionWithinJoinClauses()) {
                    result.append(" WITH ").append(rdbmsAdapter.getSelectWithLockOption());
                }
                return result.append(" ON " + this.expr1.eq(this.expr2).toStatementText(ScalarExpression.FILTER)).toString();
            }
            return "" + this.tblExpr;
        }

        public String toString() {
            return this.toString(null, false);
        }
    }

    private class FieldQueryExpression {
        private final LogicSetExpression te;
        private final DatastoreField datastoreField;
        private final String toString;
        private final int hashCode;

        protected FieldQueryExpression(LogicSetExpression te, DatastoreField datastoreField, String alias) {
            this.te = te;
            this.datastoreField = datastoreField;
            this.toString = alias != null ? te.referenceColumn(datastoreField) + " AS " + alias : te.referenceColumn(datastoreField);
            this.hashCode = this.toString.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldQueryExpression)) {
                return false;
            }
            FieldQueryExpression qsc = (FieldQueryExpression)o;
            return this.te.equals(qsc.te) && this.datastoreField.equals(qsc.datastoreField);
        }

        public String toString() {
            return this.toString;
        }
    }
}

