/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.BooleanCharColumnExpression;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.query.QueryStatement;
import org.jpox.store.rdbms.query.StatementText;
import org.jpox.util.Localiser;

public class OracleQueryStatement
extends QueryStatement {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    public static final String NLS_SORT_ORDER_PROPERTY = "org.jpox.oracle.nlsSortOrder";
    private final String nlsSortOrder = System.getProperty("org.jpox.oracle.nlsSortOrder", "LATIN").toUpperCase();

    public OracleQueryStatement(DatastoreContainerObject initialTable, ClassLoaderResolver clr) {
        super(initialTable, clr);
        this.stmtJoinsSeparator = (char)44;
    }

    public OracleQueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier initialRangeVar, ClassLoaderResolver clr) {
        super(initialTable, initialRangeVar, clr);
        this.stmtJoinsSeparator = (char)44;
    }

    protected StatementText generateOrderingStatement() {
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            orderByStmt = new StatementText();
            boolean needsSelect = ((RDBMSAdapter)this.dba).includeOrderByColumnsInSelect();
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExpr = "JPOXORDER" + i;
                if (i > 0) {
                    orderByStmt.append(',');
                }
                if (needsSelect && !this.hasAggregateExpression) {
                    if (this.orderingExpressions[i] instanceof CharacterExpression && !this.nlsSortOrder.equals("BINARY")) {
                        orderByStmt.append("NLSSORT(").append(orderExpr).append(", 'NLS_SORT = ").append(this.nlsSortOrder).append("')");
                    } else {
                        if (this.orderingExpressions[i] instanceof BooleanExpression && !(this.orderingExpressions[i] instanceof BooleanCharColumnExpression)) {
                            throw new JDOFatalInternalException(LOCALISER_RDBMS.msg("RDBMS.QueryStatement.OracleBooleanExpression"));
                        }
                        orderByStmt.append(orderExpr);
                    }
                } else if (this.orderingExpressions[i] instanceof CharacterExpression && !this.nlsSortOrder.equals("BINARY")) {
                    orderByStmt.append("NLSSORT(").append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION)).append(", 'NLS_SORT = ").append(this.nlsSortOrder).append("')");
                } else {
                    if (this.orderingExpressions[i] instanceof BooleanExpression && !(this.orderingExpressions[i] instanceof BooleanCharColumnExpression)) {
                        throw new JDOFatalInternalException(LOCALISER_RDBMS.msg("RDBMS.QueryStatement.OracleBooleanExpression"));
                    }
                    orderByStmt.append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION));
                }
                if (!this.orderingDirections[i]) continue;
                orderByStmt.append(" DESC");
            }
        }
        return orderByStmt;
    }

    public void innerJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr) {
        this.assertNotFrozen();
        QueryStatement.Join join = new QueryStatement.Join(expr, expr2, tblExpr);
        if (tblExpr.equals(this.getInitialTableExpr())) {
            this.andCondition(expr.eq(expr2));
            return;
        }
        if (this.crossJoins.contains(tblExpr)) {
            this.crossJoins.remove(tblExpr);
        }
        if (this.joinsTo.contains(tblExpr.getRangeVariable())) {
            return;
        }
        this.joinsTo.add(tblExpr.getRangeVariable());
        this.joins.add(join);
        this.andCondition(expr.eq(expr2));
    }

    public void leftOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr) {
        this.assertNotFrozen();
        QueryStatement.Join join = new QueryStatement.Join(expr, expr2, tblExpr);
        if (this.joinsTo.contains(tblExpr.getRangeVariable())) {
            return;
        }
        this.joinsTo.add(tblExpr.getRangeVariable());
        this.joins.add(join);
        if (expr2 instanceof ObjectExpression) {
            ((ObjectExpression)expr2).addOuterJoinSuffix("(+)");
        }
        this.andCondition(expr.eq(expr2));
    }

    public void rightOuterJoin(ScalarExpression expr, ScalarExpression expr2, LogicSetExpression tblExpr) {
        this.assertNotFrozen();
        QueryStatement.Join join = new QueryStatement.Join(expr, expr2, tblExpr);
        if (this.joinsTo.contains(tblExpr.getRangeVariable())) {
            return;
        }
        this.joinsTo.add(tblExpr.getRangeVariable());
        this.joins.add(join);
        if (expr instanceof ObjectExpression) {
            ((ObjectExpression)expr).addOuterJoinSuffix("(+)");
        }
        this.andCondition(expr.eq(expr2));
    }
}

