/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import org.jpox.PersistenceManager;
import org.jpox.exceptions.ClassNotPersistenceCapableException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.IdentityType;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.query.QueryResult;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.exceptions.PersistentSuperclassNotAllowedException;
import org.jpox.store.rdbms.query.BaseSQLQuery;
import org.jpox.store.rdbms.query.ForwardQueryResult;
import org.jpox.store.rdbms.query.InsensitiveQueryResult;
import org.jpox.store.rdbms.query.ResultClassROF;
import org.jpox.store.rdbms.query.TransientIDROF;
import org.jpox.util.MacroString;

public class JPOXSQLQuery
extends BaseSQLQuery {
    protected transient List parameterOccurrences = null;
    protected transient List fieldColumnNames = null;
    protected transient int[] fieldNumbers = null;

    public JPOXSQLQuery(PersistenceManager pm, JPOXSQLQuery query) {
        super(pm, query);
    }

    public JPOXSQLQuery(PersistenceManager pm) {
        super(pm, (String)null);
    }

    public JPOXSQLQuery(PersistenceManager pm, String sql_text) {
        super(pm, sql_text);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.parameterOccurrences = null;
        this.fieldColumnNames = null;
        this.fieldNumbers = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JPOXSQLQuery) || !super.equals(obj)) {
            return false;
        }
        return this.sqlText.equals(((JPOXSQLQuery)obj).sqlText);
    }

    protected void generateQueryStatement() {
        AbstractClassMetaData candidateCmd;
        if (this.candidateClass == null) {
            this.fieldColumnNames = new ArrayList();
            candidateCmd = null;
        } else {
            candidateCmd = this.pm.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.pm.getClassLoaderResolver());
            if (candidateCmd == null) {
                throw new ClassNotPersistenceCapableException(this.candidateClass.getName());
            }
            if (candidateCmd.getPersistenceCapableSuperclass() != null) {
                throw new PersistentSuperclassNotAllowedException(this.candidateClass.getName());
            }
            if (candidateCmd.isRequiresExtent()) {
                throw new JDOUserException(LOCALISER_RDBMS.msg("JPOXSQL.InvalidCandidateClassExtentError", this.candidateClass.getName()));
            }
            if (candidateCmd.getIdentityType() != IdentityType.NONDURABLE) {
                throw new JDOUserException(LOCALISER_RDBMS.msg("JPOXSQL.InvalidCandidateClassNondurableError", this.candidateClass.getName()));
            }
            int fieldCount = candidateCmd.getNoOfManagedFields();
            int[] fn = new int[fieldCount];
            this.statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            this.fieldColumnNames = new ArrayList(fieldCount);
            int n = 0;
            for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                this.statementExpressionIndex[fieldNumber] = new StatementExpressionIndex();
                AbstractPropertyMetaData fmd = candidateCmd.getManagedField(fieldNumber);
                String fieldName = fmd.getName();
                Class fieldType = fmd.getType();
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                    JavaTypeMapping m = this.dba.getMapping(fieldType, this.getStoreManager(), this.pm.getClassLoaderResolver());
                    if (m.includeInFetchStatement()) {
                        this.statementExpressionIndex[fieldNumber].setMapping(m);
                        fn[n++] = fieldNumber;
                        String columnName = null;
                        columnName = fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0 ? fmd.getColumnMetaData()[0].getName() : this.pm.getStoreManager().getIdentifierFactory().newDatastoreFieldIdentifier(fieldName, this.pm.getPMFContext().getTypeManager().isDefaultEmbeddedType(fieldType), 0).getIdentifier();
                        this.fieldColumnNames.add(columnName);
                    }
                    if (!(m instanceof MappingCallbacks)) continue;
                    throw new JDOFatalUserException("Mapping " + m + " not suitable for a JPOXSQL result column, field = " + fieldName);
                }
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                throw new JDOFatalInternalException("Invalid persistence modifier on field " + fieldName);
            }
            if (n == 0) {
                throw new JDOFatalUserException("View class has no persistent fields: " + this.candidateClass.getName());
            }
            this.fieldNumbers = new int[n];
            System.arraycopy(fn, 0, this.fieldNumbers, 0, n);
        }
        this.parameterOccurrences = new ArrayList();
        MacroString ms = new MacroString(this.candidateClass != null ? this.candidateClass.getName() : null, this.candidateClass != null ? this.imports : null, this.sqlText);
        this.jdbcSqlText = ms.substituteMacros(new MacroString.MacroHandler(){

            public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                if (JPOXSQLQuery.this.candidateClass != null) {
                    if (im.className.equals(JPOXSQLQuery.this.candidateClass.getName())) {
                        if (im.fieldName == null) {
                            throw new JDOUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.ResultClassesHaveNoTableError", im));
                        }
                        if (im.subfieldName != null) {
                            throw new JDOUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.NoSuchFieldInResultClassError", im.className, im));
                        }
                        int fieldNumber = candidateCmd.getFieldNumber(im.fieldName);
                        if (fieldNumber < 0) {
                            throw new JDOUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.NoSuchFieldInResultClassError", im.className, im));
                        }
                        im.value = (String)JPOXSQLQuery.this.fieldColumnNames.get(fieldNumber);
                    } else {
                        JPOXSQLQuery.this.getStoreManager().resolveIdentifierMacro(im, JPOXSQLQuery.this.pm.getClassLoaderResolver());
                    }
                }
            }

            public void onParameterMacro(MacroString.ParameterMacro pm) {
                JPOXSQLQuery.this.parameterOccurrences.add(pm.parameterName);
            }
        }, this.pm.getClassLoaderResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection performExecute(Map parameters) {
        this.compile();
        if (parameters.size() != this.parameterNames.size()) {
            throw new JDOUserException(LOCALISER_RDBMS.msg("JPOXSQL.IncorrectNumberOfParametersError", "" + this.parameterNames.size(), "" + parameters.size()));
        }
        QueryResult qr = null;
        try {
            RDBMSManager storeMgr = (RDBMSManager)this.pm.getStoreManager();
            Connection conn = storeMgr.getConnection(this.pm, false, true);
            try {
                PreparedStatement ps = conn.prepareStatement(this.jdbcSqlText);
                try {
                    Iterator iter = this.parameterOccurrences.iterator();
                    int stmtParamNum = 1;
                    while (iter.hasNext()) {
                        String paramName = (String)iter.next();
                        Class paramType = (Class)this.parameterTypesByName.get(paramName);
                        if (!parameters.containsKey(paramName)) {
                            throw new JDOUserException(LOCALISER_RDBMS.msg("JPOXSQL.ParameterNotProvidedError", paramName));
                        }
                        if (paramType == null) {
                            throw new JDOUserException(LOCALISER_RDBMS.msg("JPOXSQL.UndeclaredParameterError", paramName));
                        }
                        JavaTypeMapping mapping = this.dba.getMapping(paramType, this.getStoreManager(), this.pm.getClassLoaderResolver());
                        Object paramValue = parameters.get(paramName);
                        mapping.setObject(this.pm, ps, Mappings.getParametersIndex(stmtParamNum, mapping), paramValue);
                        if (mapping.getNumberOfDatastoreFields() == 0) {
                            ++stmtParamNum;
                            continue;
                        }
                        stmtParamNum += mapping.getNumberOfDatastoreFields();
                    }
                    this.prepareStatementForExecution(ps);
                    ResultSet rs = storeMgr.executeStatementQuery(this.jdbcSqlText, ps);
                    try {
                        if (this.candidateClass != null) {
                            ResultSetMetaData rsmd = rs.getMetaData();
                            HashSet remainingColumnNames = new HashSet(this.fieldColumnNames);
                            int colCount = rsmd.getColumnCount();
                            for (int colNum = 1; colNum <= colCount; ++colNum) {
                                String colName = rsmd.getColumnName(colNum);
                                int fieldNumber = this.fieldColumnNames.indexOf(colName);
                                if (fieldNumber < 0) continue;
                                this.statementExpressionIndex[fieldNumber].setExpressionIndex(new int[]{colNum});
                                remainingColumnNames.remove(colName);
                            }
                            if (!remainingColumnNames.isEmpty()) {
                                throw new JDOUserException(LOCALISER_RDBMS.msg("JPOXSQL.ResultSetMissingColumnsError", remainingColumnNames));
                            }
                            qr = this.resultClass != null ? (this.getResultSetType().equals("scroll-insensitive") ? new InsensitiveQueryResult(null, this, new ResultClassROF(this.resultClass, this.statementExpressionIndex), rs, null) : new ForwardQueryResult(null, this, new ResultClassROF(this.resultClass, this.statementExpressionIndex), rs, null)) : (this.getResultSetType().equals("scroll-insensitive") ? new InsensitiveQueryResult(null, this, new ResultClassROF(this.resultClass, this.statementExpressionIndex), rs, null) : new ForwardQueryResult(null, this, new TransientIDROF(this.candidateClass, this.fieldNumbers, this.statementExpressionIndex), rs, null));
                        } else {
                            qr = this.getQueryResultForNoCandidateClass(rs);
                        }
                    }
                    finally {
                        if (qr == null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (qr == null) {
                        ps.close();
                    }
                }
            }
            finally {
                storeMgr.releaseConnection(this.pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER_RDBMS.msg("JPOXSQL.ExecutionError", this.jdbcSqlText), (Throwable)e);
        }
        this.queryResults.add(qr);
        return qr;
    }
}

