/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jdo.JDOUserException;
import org.jpox.PersistenceManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public abstract class AbstractQueryResult
extends AbstractList
implements QueryResult,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected int pmResultsNumber = -1;
    protected final Query query;
    protected final ResultObjectFactory rof;
    protected ResultSet rs;
    protected QueryExpression qs;
    protected boolean closed = false;

    public AbstractQueryResult(QueryExpression qs, Query query, ResultObjectFactory rof, ResultSet rs) {
        this.query = query;
        this.rof = rof;
        this.rs = rs;
        this.qs = qs;
        this.pmResultsNumber = ((PersistenceManager)query.getPersistenceManager()).addQueryResult(this);
    }

    protected boolean isOpen() {
        return !this.closed;
    }

    protected void assertIsOpen() {
        if (!this.isOpen()) {
            throw new JDOUserException(LOCALISER.msg("QueryResult.Closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSet() {
        if (this.rs != null) {
            try {
                Statement stmt = null;
                try {
                    stmt = this.rs.getStatement();
                    this.rs.close();
                }
                catch (SQLException e) {
                    JPOXLogger.RDBMS.error(LOCALISER.msg("QueryResult.CloseError", e));
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                this.rs = null;
            }
        }
    }

    public synchronized void close() {
        this.closed = true;
        ((PersistenceManager)this.query.getPersistenceManager()).removeQueryResult(this.pmResultsNumber);
        this.closeResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotModifiable"));
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotModifiable"));
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotModifiable"));
    }

    public void clear() {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotModifiable"));
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotSupported"));
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotSupported"));
    }

    public abstract boolean equals(Object var1);

    public abstract Object get(int var1);

    public int hashCode() {
        if (this.qs != null) {
            return this.qs.hashCode();
        }
        return this.query.hashCode();
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotSupported"));
    }

    public abstract boolean isEmpty();

    public abstract Iterator iterator();

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotSupported"));
    }

    public abstract ListIterator listIterator();

    public Object remove(int index) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotModifiable"));
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotModifiable"));
    }

    public abstract int size();

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotSupported"));
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotSupported"));
    }

    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException(LOCALISER.msg("QueryResult.NotSupported"));
    }

    public QueryExpression newQueryStatement() {
        return this.qs;
    }

    public QueryExpression newQueryStatement(Class candidateClass) {
        this.qs.reset();
        return this.qs;
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        return this.rof;
    }
}

