/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.poid;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.jpox.store.poid.PoidBlock;
import org.jpox.store.poid.PoidException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.poid.AbstractRDBMSPoidGenerator;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public final class SequencePoidGenerator
extends AbstractRDBMSPoidGenerator {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected String sequenceName = null;

    public SequencePoidGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 1;
        if (this.properties != null && this.properties.get("key-cache-size") != null) {
            try {
                this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
            }
            catch (Exception e) {
                throw new PoidException(LOCALISER.msg("PoidGenerator.InvalidKeyCacheSize", this.properties.get("key-cache-size")));
            }
        }
    }

    protected synchronized PoidBlock reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        Statement ps = null;
        ResultSet rs = null;
        ArrayList<Long> oid = new ArrayList<Long>();
        try {
            RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            RDBMSManager rdbmsMgr = (RDBMSManager)this.storeMgr;
            String stmt = dba.getSequenceNextStmt(this.getSequenceName());
            ps = rdbmsMgr.getStatement(this.connection, stmt, false);
            rs = rdbmsMgr.executeStatementQuery(stmt, (PreparedStatement)ps);
            Long nextId = new Long(0L);
            if (rs.next()) {
                nextId = new Long(rs.getLong(1));
                oid.add(nextId);
            }
            int i = 1;
            while ((long)i < size) {
                nextId = new Long(nextId + 1L);
                oid.add(nextId);
                ++i;
            }
            PoidBlock poidBlock = new PoidBlock(oid);
            return poidBlock;
        }
        catch (SQLException e) {
            throw new PoidException(LOCALISER_RDBMS.msg("SequencePoidGenerator.CantObtainSequenceId", e.getMessage()));
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    protected String getSequenceName() {
        if (this.sequenceName == null) {
            String sequenceSchemaName;
            String sequenceCatalogName = this.properties.getProperty("sequence-catalog-name");
            if (sequenceCatalogName == null) {
                sequenceCatalogName = this.properties.getProperty("catalog-name");
            }
            if ((sequenceSchemaName = this.properties.getProperty("sequence-schema-name")) == null) {
                sequenceSchemaName = this.properties.getProperty("schema-name");
            }
            String sequenceName = this.properties.getProperty("sequence-name");
            RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
            SQLIdentifier identifier = (SQLIdentifier)idFactory.newSequenceIdentifier(sequenceName);
            if (((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsCatalogsInTableDefinitions() && sequenceCatalogName != null) {
                identifier.setCatalogName(sequenceCatalogName);
            }
            if (((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsSchemasInTableDefinitions() && sequenceSchemaName != null) {
                identifier.setSchemaName(sequenceSchemaName);
            }
            this.sequenceName = identifier.getFullyQualifiedName(true);
        }
        return this.sequenceName;
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected boolean createRepository() {
        PreparedStatement ps = null;
        RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        RDBMSManager rdbmsMgr = (RDBMSManager)this.storeMgr;
        String stmt = dba.getSequenceCreateStmt(this.getSequenceName(), (String)this.properties.get("key-min-value"), (String)this.properties.get("key-max-value"), (String)this.properties.get("key-start-with"), (String)this.properties.get("key-increment-by"), (String)this.properties.get("key-database-cache-size"));
        try {
            ps = rdbmsMgr.getStatement(this.connection, stmt, false);
            rdbmsMgr.executeStatementUpdate(stmt, ps);
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS_SQL.error(e);
            throw new PoidException(LOCALISER_RDBMS.msg("SequencePoidGenerator.CantCreateSequence", e.getMessage()) + stmt);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {}
        }
        return true;
    }
}

