/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.poid;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.jpox.store.poid.PoidBlock;
import org.jpox.store.poid.PoidException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.poid.AbstractRDBMSPoidGenerator;
import org.jpox.util.Localiser;

public class MaxPoidGenerator
extends AbstractRDBMSPoidGenerator {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");

    public MaxPoidGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 1;
    }

    public PoidBlock reserveBlock(long size) {
        PoidBlock poidBlock;
        Statement ps = null;
        ResultSet rs = null;
        RDBMSManager rdbmsMgr = (RDBMSManager)this.storeMgr;
        try {
            String stmt = this.getStatement();
            ps = rdbmsMgr.getStatement(this.connection, stmt, false);
            rs = rdbmsMgr.executeStatementQuery(stmt, (PreparedStatement)ps);
            if (!rs.next()) {
                PoidBlock poidBlock2 = new PoidBlock(new Object[]{new Long(1L)});
                return poidBlock2;
            }
            poidBlock = new PoidBlock(new Object[]{new Long(rs.getLong(1) + 1L)});
        }
        catch (SQLException e) {
            throw new PoidException(e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {}
        }
        return poidBlock;
    }

    private String getStatement() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT max(");
        stmt.append(this.storeMgr.getIdentifierFactory().getIdentifierInAdapterCase((String)this.properties.get("column-name")));
        stmt.append(") FROM ");
        stmt.append(this.storeMgr.getIdentifierFactory().getIdentifierInAdapterCase((String)this.properties.get("table-name")));
        return stmt.toString();
    }
}

